<?php
namespace Cadoles\CoreBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\RepeatedType;
use Symfony\Component\Form\Extension\Core\Type\PasswordType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\ButtonType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\ColorType;
use Cadoles\CoreBundle\Form\IconChoiceType;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Ivory\CKEditorBundle\Form\Type\CKEditorType;
use Tetranz\Select2EntityBundle\Form\Type\Select2EntityType;

use Doctrine\ORM\EntityRepository;
use Doctrine\ORM\EntityManager;

class EthercalcType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('submit', SubmitType::class, [
                    'label'                 => 'Valider',
                    'attr'                  => ['class' => 'btn btn-success']
            ]);

        $builder
            ->add('title', TextType::class, [
                    'label'                 => 'Titre',
                    'disabled'              => ($options["mode"]=="submit"?false:true),
                    'attr'                  => ['class' => 'form-control', 'style' => 'margin-bottom:15px']
            ]);


        $builder
            ->add('groups', Select2EntityType::class, [
                    'label'                 => 'Visible pour les Groupes',
                    'class'                 => 'CadolesCoreBundle:Group',
                    'text_property'         => 'label',
                    'multiple'              => true,
                    'remote_route'          => 'cadoles_core_'.$options["access"].'_group_ajax_list',
                    'primary_key'           => 'id',
                    'text_property'         => 'label',
                    'minimum_input_length'  => 0,
                    'page_limit'            => 100,
                    'allow_clear'           => true,
                    'delay'                 => 250,
                    'cache'                 => false,
                    'cache_timeout'         => 60000,
                    'language'              => 'fr',
                    'placeholder'           => 'Selectionner des groupes',                        
            ]);            

        $builder
            ->add('users', Select2EntityType::class, [
                    'label'                 => 'Visible pour les Utilisateurs',
                    'class'                 => 'CadolesCoreBundle:User',
                    'text_property'         => 'label',
                    'multiple'              => true,
                    'remote_route'          => 'cadoles_core_user_user_ajax_select',
                    'primary_key'           => 'id',
                    'text_property'         => 'displayname',
                    'minimum_input_length'  => 0,
                    'page_limit'            => 100,
                    'allow_clear'           => true,
                    'delay'                 => 250,
                    'cache'                 => false,
                    'cache_timeout'         => 60000,
                    'language'              => 'fr',
                    'placeholder'           => 'Selectionner des utilisateurs',                        
            ]); 
            
        if($options["access"]=="config") {
            $builder
                ->add('user', Select2EntityType::class, [
                        'label'                 => 'Propriétaire',
                        'class'                 => 'CadolesCoreBundle:User',
                        'text_property'         => 'label',
                        'multiple'              => false,
                        'required'              => true,
                        'remote_route'          => 'cadoles_core_user_user_ajax_select',
                        'primary_key'           => 'id',
                        'text_property'         => 'displayname',
                        'minimum_input_length'  => 0,
                        'page_limit'            => 100,
                        'allow_clear'           => true,
                        'delay'                 => 250,
                        'cache'                 => false,
                        'cache_timeout'         => 60000,
                        'language'              => 'fr',
                        'placeholder'           => 'Selectionner un utilisateurs',                        
                ]);            
        }            
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'Cadoles\CoreBundle\Entity\Ethercalc',
            'mode' => "string",
            'access' => "string",
        ));
    }
}
