<?php
namespace Cadoles\CoreBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Ivory\CKEditorBundle\Form\Type\CKEditorType;
use Tetranz\Select2EntityBundle\Form\Type\Select2EntityType;

class ScrumType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        if($options["mode"]!="view") {
            $builder
            ->add('submit', SubmitType::class, [
                    'label'                 => 'Valider',
                    'attr'                  => ['class' => 'btn btn-success']
            ]);

            $builder
            ->add('title', TextType::class, [
                    'label'                 => 'Titre',
                    'attr'                  => ['class' => 'form-control', 'style' => 'margin-bottom:15px']
            ]);

            $choices=["non" => "0","oui" => "1"];
            $builder
            ->add('fgcomment', ChoiceType::class,[
                'label'                     => 'Permettre les commentaires sur les billets',
                'attr'                      => ["class" => "form-control"],
                'required'                  => true,
                'choices'                   => $choices
            ]);  

            $builder
            ->add('groups', Select2EntityType::class, [
                    'label'                 => 'Accès en écriture pour les Groupes',
                    'class'                 => 'CadolesCoreBundle:Group',
                    'text_property'         => 'label',
                    'multiple'              => true,
                    'remote_route'          => 'cadoles_core_'.$options["access"].'_group_ajax_list',
                    'primary_key'           => 'id',
                    'text_property'         => 'label',
                    'minimum_input_length'  => 0,
                    'page_limit'            => 100,
                    'allow_clear'           => true,
                    'delay'                 => 250,
                    'cache'                 => false,
                    'cache_timeout'         => 60000,
                    'language'              => 'fr',
                    'placeholder'           => 'Selectionner des groupes',                        
            ]);            

            $builder
            ->add('groupwriters', Select2EntityType::class, [
                    'label'                 => 'Accès en écriture pour les Groupes sur ses billets',
                    'class'                 => 'CadolesCoreBundle:Group',
                    'multiple'              => true,
                    'remote_route'          => 'cadoles_core_'.$options["access"].'_group_ajax_list',
                    'primary_key'           => 'id',
                    'text_property'         => 'label',
                    'minimum_input_length'  => 0,
                    'page_limit'            => 100,
                    'allow_clear'           => true,
                    'delay'                 => 250,
                    'cache'                 => false,
                    'cache_timeout'         => 60000,
                    'language'              => 'fr',
                    'placeholder'           => 'Selectionner des groupes',                        
            ]);

            $builder
            ->add('groupreaders', Select2EntityType::class, [
                    'label'                 => 'Accès en lecture pour les Groupes',
                    'class'                 => 'CadolesCoreBundle:Group',
                    'text_property'         => 'label',
                    'multiple'              => true,
                    'remote_route'          => 'cadoles_core_'.$options["access"].'_group_ajax_list',
                    'primary_key'           => 'id',
                    'text_property'         => 'label',
                    'minimum_input_length'  => 0,
                    'page_limit'            => 100,
                    'allow_clear'           => true,
                    'delay'                 => 250,
                    'cache'                 => false,
                    'cache_timeout'         => 60000,
                    'language'              => 'fr',
                    'placeholder'           => 'Selectionner des groupes',                        
            ]);  

            $builder
            ->add('users', Select2EntityType::class, [
                    'label'                 => 'Accès en écriture pour les Utilisateurs',
                    'class'                 => 'CadolesCoreBundle:User',
                    'text_property'         => 'label',
                    'multiple'              => true,
                    'remote_route'          => 'cadoles_core_user_user_ajax_select',
                    'primary_key'           => 'id',
                    'text_property'         => 'displayname',
                    'minimum_input_length'  => 0,
                    'page_limit'            => 100,
                    'allow_clear'           => true,
                    'delay'                 => 250,
                    'cache'                 => false,
                    'cache_timeout'         => 60000,
                    'language'              => 'fr',
                    'placeholder'           => 'Selectionner des utilisateurs',                        
            ]);            


            $builder
            ->add('userwriters', Select2EntityType::class, [
                    'label'                 => 'Accès en écriture pour les Utilisateurs sur ses billets',
                    'class'                 => 'CadolesCoreBundle:User',
                    'multiple'              => true,
                    'remote_route'          => 'cadoles_core_user_user_ajax_select',
                    'primary_key'           => 'id',
                    'text_property'         => 'displayname',
                    'minimum_input_length'  => 0,
                    'page_limit'            => 100,
                    'allow_clear'           => true,
                    'delay'                 => 250,
                    'cache'                 => false,
                    'cache_timeout'         => 60000,
                    'language'              => 'fr',
                    'placeholder'           => 'Selectionner des utilisateurs',                        
            ]); 

            $builder
            ->add('userreaders', Select2EntityType::class, [
                    'label'                 => 'Accès en lecture pour les Utilisateurs',
                    'class'                 => 'CadolesCoreBundle:User',
                    'text_property'         => 'label',
                    'multiple'              => true,
                    'remote_route'          => 'cadoles_core_user_user_ajax_select',
                    'primary_key'           => 'id',
                    'text_property'         => 'displayname',
                    'minimum_input_length'  => 0,
                    'page_limit'            => 100,
                    'allow_clear'           => true,
                    'delay'                 => 250,
                    'cache'                 => false,
                    'cache_timeout'         => 60000,
                    'language'              => 'fr',
                    'placeholder'           => 'Selectionner des utilisateurs',                        
            ]); 

            if($options["access"]=="config") {
                $builder
                ->add('user', Select2EntityType::class, [
                        'label'                 => 'Propriétaire',
                        'class'                 => 'CadolesCoreBundle:User',
                        'text_property'         => 'label',
                        'multiple'              => false,
                        'required'              => true,
                        'remote_route'          => 'cadoles_core_user_user_ajax_select',
                        'primary_key'           => 'id',
                        'text_property'         => 'displayname',
                        'minimum_input_length'  => 0,
                        'page_limit'            => 100,
                        'allow_clear'           => true,
                        'delay'                 => 250,
                        'cache'                 => false,
                        'cache_timeout'         => 60000,
                        'language'              => 'fr',
                        'placeholder'           => 'Selectionner un utilisateurs',                        
                ]);                 
            }
        }
        else {
            $builder
            ->add('description',CKEditorType::class,[
                    'config_name'           => 'full_config',    
                    'label'                 => 'Description',
                    'mapped'                => false,
                    'required'              => false,
                    'config'                => [
                        'height' => '300px',
                        'filebrowserUploadRoute' => 'cadoles_core_user_scrum_upload',
                        'filebrowserUploadRouteParameters' => ['id' => $options["id"]]
                    ],
            ]);

            $builder
            ->add('message',CKEditorType::class,[
                    'config_name'           => 'small_config',    
                    'label'                 => 'Message',
                    'mapped'                => false,
                    'required'              => false,
                    'config'                => [
                        'height' => '100px',
                        'filebrowserUploadRoute' => 'cadoles_core_user_scrum_upload',
                        'filebrowserUploadRouteParameters' => ['id' => $options["id"]],  
                    ],                      
            ]);              
        }
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'Cadoles\CoreBundle\Entity\Scrum',
            'mode' => "string",
            'access' => "string",
            'id' => "string",
        ));
    }
}
