<?php
namespace Cadoles\CoreBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\RepeatedType;
use Symfony\Component\Form\Extension\Core\Type\PasswordType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\ButtonType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\DateType;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Tetranz\Select2EntityBundle\Form\Type\Select2EntityType;

use Doctrine\ORM\EntityRepository;
use Doctrine\ORM\Query\Expr\Join;

class UserType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder->add('submit',
            SubmitType::class, array(
                "label"       => ($options["mode"]=="delete"?"Confirmer la Suppression":"Valider"),
                "attr"        => ($options["mode"]=="delete"?array("class" => "btn btn-danger"):array("class" => "btn btn-success"))
            )
        );

         # Obligatoire
        $builder->add('username',
            TextType::class, array(
                "label"       =>"Login",
                "disabled"    => true,
                "attr"        => array("class" => "form-control", "style" => "margin-bottom:15px")
            )
        );

        $builder->add('lastname',
            TextType::class, array(  
                "label"       =>"Nom",
                "disabled"    => true,
                "attr"        => array("class" => "form-control", "style" => "margin-bottom:15px")
            )
        );

        $builder->add('firstname',
            TextType::class, [
                "label"       =>"Prénom",
                "disabled"    => true,
                "attr"        => array("class" => "form-control", "style" => "margin-bottom:15px")
            ]
        );


        $builder->add('email',
            EmailType::class, array(
                "label" =>"Mail",
                "disabled" => true,
                "attr" => array("class" => "form-control", "style" => "margin-bottom:15px")
            )
        );

        $choices=array("Utilisateur" => "ROLE_USER","Animateur de Groupe" => "ROLE_MASTER","Modérateur" => "ROLE_MODO","Administrateur" => "ROLE_ADMIN");
        $builder->add("role",
            ChoiceType::class,array(
                "label"       =>"Rôle",
                "attr"        => array("class" => "form-control", "style" => "margin-bottom:15px;"),
                "required"    => true,
                "choices"     => $choices
            )
        );
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'Cadoles\CoreBundle\Entity\User',
            'mode' => "string",
            'access' => "string",
            'mode_auth' => "string"
        ));
    }
}

