<?php

namespace Cadoles\CoreBundle\Repository;

use Cadoles\CoreBundle\Entity\Etherpad;
use Cadoles\CoreBundle\Entity\User;
use Doctrine\Common\Persistence\ManagerRegistry;

class EtherpadRepository extends \Doctrine\ORM\EntityRepository
{
    protected $entity="CadolesCoreBundle:Etherpad";

    public function getPadgroups(User $user) {
        $groups=$user->getGroups();
        $mygroups=[];
        
        // Partage aux groupes
        foreach($groups as $group) {
            $tmp[$group->getId()] =
                $this->getEntityManager()->createQueryBuilder()
                     ->select('s')
                     ->from($this->entity,'s')
                     ->from('CadolesCoreBundle:Group','g')
                     ->where('g.id=:id')
                     ->andWhere('g MEMBER OF s.groups')
                     ->andWhere('s.user!=:user')
                     ->setParameter('id',$group->getId())
                     ->setParameter('user',$user)
                     ->getQuery()->getResult();

            foreach($tmp[$group->getId()] as $my) {
                if(!in_array($my,$mygroups)) {
                    array_push($mygroups,$my);
                }
            }
        }

        // Partage utilisateur
        $tmp =
            $this->getEntityManager()->createQueryBuilder()
                 ->select('s')
                 ->from($this->entity,'s')
                 ->andWhere(':user MEMBER OF s.users')
                 ->andWhere('s.user!=:user')
                 ->setParameter('user',$user)
                 ->getQuery()->getResult();
        foreach($tmp as $my) {
            if(!in_array($my,$mygroups)) {
                array_push($mygroups,$my);
            }
        }

        return $mygroups;
    }        
}
