<?php

namespace Cadoles\CoreBundle\Service;

class etherpadService
{
    protected $url;
    protected $key;

    public function __construct($appWeburl, $appUrletherpad, $appKeyetherpad)
    {
        $this->url = $appUrletherpad;
        $this->key = $appKeyetherpad;

        // Si url dans le meme domaine on ajoute l'url complète
        if(stripos($this->url,"http")===false) {
            $this->url = "https://".$appWeburl.$appUrletherpad;        
        }
    }

    public function listAllPads() {
        $apiurl = $this->url."api/1.2.1/listAllPads";
        $query  = ["apikey"=>$this->key];
    
        $response=$this->api("GET",$apiurl,$query);
        if(!$response||$response->code!="200") return false;
        else return $response->body->data->padIDs;
    }

    public function createPad($name) {
        $apiurl = $this->url."api/1/createPad";
        $query  = ["apikey"=>$this->key,"padID"=>$name];
    
        $response=$this->api("GET",$apiurl,$query);
        if(!$response||$response->code!="200") return false;
        else return $response;        
    }

    public function deletePad($name) {
        $apiurl = $this->url."api/1/deletePad";
        $query  = ["apikey"=>$this->key,"padID"=>$name];
    
        $response=$this->api("GET",$apiurl,$query);
        if(!$response||$response->code!="200") return false;
        else return $response;        
    }

    private function api($method,$url,$query) {
        // Entete
        $headers = ['Accept' => 'application/json'];
    
        // Paramétrage unirest
        \Unirest\Request::verifyPeer(false);
        \Unirest\Request::verifyHost(false);
        \Unirest\Request::timeout(5);
        
        $response = false;
        switch($method) {
            case "POST":
                // Tentative sans proxy
                try{
                    $response = \Unirest\Request::post($url,$headers,$query);
                }
                catch (\Exception $e) {
                    // On tente avec le proxy s'il y en a un
                    $proxyUse = $this->container->getParameter("proxyUse");
                    if($proxyUse) {
                        $proxyHost = $this->container->getParameter("proxyHost");
                        $proxyPort = $this->container->getParameter("proxyPort");
                        \Unirest\Request::proxy($proxyHost, $proxyPort, CURLPROXY_HTTP, true);

                        try{
                            $response = \Unirest\Request::post($url,$headers,$query);
                        }
                        catch (\Exception $e) {
                            return false;
                        }
                    }
                    else {
                        return false;
                    }            
                }
            break;

            case "GET":
                // Tentative sans proxy
                try{
                    $response = \Unirest\Request::get($url,$headers,$query);
                }
                catch (\Exception $e) {
                    // On tente avec le proxy s'il y en a un
                    $proxyUse = $this->container->getParameter("proxyUse");
                    if($proxyUse) {
                        $proxyHost = $this->container->getParameter("proxyHost");
                        $proxyPort = $this->container->getParameter("proxyPort");
                        \Unirest\Request::proxy($proxyHost, $proxyPort, CURLPROXY_HTTP, true);

                        try{
                            $response = \Unirest\Request::get($url,$headers,$query);
                        }
                        catch (\Exception $e) {
                            return false;
                        }
                    }
                    else {
                        return false;
                    }            
                }            
            break;
        }

        return $response;
    }
}
