<?php

namespace Cadoles\CoreBundle\Service;

use Cadoles\CoreBundle\Entity\User;
use Cadoles\CoreBundle\Entity\Niveau01;
use Cadoles\CoreBundle\Entity\Niveau02;
use Cadoles\CoreBundle\Entity\Group;
use Cadoles\CoreBundle\Entity\UserGroup;

class ldapService
{

    protected $host;
    protected $port;
    protected $baseDN;

    protected $user = null;
    protected $password = null;
    private $connection = null;
    private $ldapSync = false;

    public function __construct($host, $port)
    {
        $this->host = $host;
        $this->port = $port;
    }

    public function isEnabled() {
        return $this->ldapSync;
    }

    public function connect() {
        if($this->connection){
            return $this->connection;
        } else {
            $ldapConn = ldap_connect($this->host, $this->port);
            if($ldapConn){
                ldap_set_option($ldapConn, LDAP_OPT_PROTOCOL_VERSION, 3);
                if(ldap_bind( $ldapConn, $this->user, $this->password)){
                    $this->connection = $ldapConn;
                    return $this->connection;
                }
            }
        }
    }

    public function search($filter, $attributes = array(), $subBranch = '') {
        $connection = $this->connect();
        $branch = ($subBranch ? $subBranch : $this->baseDN);
        $result = ldap_search($connection, $branch, $filter, $attributes,0,0,0);
        if(!$result) {
            $this->ldapError();
        }
        return $this->resultToArray($result);
    }

    public function deleteByDN($dn){
        $connection = $this->connect();
        $removed = ldap_delete($connection, $dn);
        if(!$removed){
            $this->ldapError();
        }
    }

    public function rename($oldDN, $newDN, $parentDN = '', $deleteOldDN = true){

        $connection = $this->connect();

        $result = ldap_rename($connection, $oldDN, $newDN, $parentDN, $deleteOldDN);

        if(!$result) $this->ldapError();
        return $result;
    }

    
    private function resultToArray($result){

        $connection = $this->connect();
        $resultArray = array();

        if($result){
            $entry = ldap_first_entry($connection, $result);
            while ($entry){
                $row = array();
                $attr = ldap_first_attribute($connection, $entry);
                while ($attr){
                    $val = ldap_get_values_len($connection, $entry, $attr);
                    if(array_key_exists('count', $val) AND $val['count'] == 1){
                        $row[strtolower($attr)] = $val[0];
                    } else {
                        $row[strtolower($attr)] = $val;
                    }
                    $attr = ldap_next_attribute($connection, $entry);
                }
                $resultArray[] = $row;
                $entry = ldap_next_entry($connection, $entry);
            }
        }

        return $resultArray;
    }

    public function in_array_r($item , $array){
        return preg_match('/"'.$item.'"/i' , json_encode($array));
    }

    public function disconnect(){
      $connection = $this->connect();
      ldap_unbind($connection);
    }

    public function ldapError(){
        $connection = $this->connect();
        throw new \Exception(
            'Error: ('. ldap_errno($connection) .') '. ldap_error($connection)
        );
    }

    public function ldapModify($dn,$attrs) {
        $connection = $this->connect();
        $result = ldap_modify($connection, $dn, $attrs);
        if(!$result) $this->ldapError();        
    }


//==================================================================================================================================================================
//== Init du Service Synfony========================================================================================================================================
//==================================================================================================================================================================

    public function getUser() {
        return $this->user;
    }

    public function setUser($user) {
        $this->user = $user;
        return $this;
    }

    public function getPassword() {
        return $this->password;
    }

    public function setPassword($password) {
        $this->password = $password;
        return $this;
    }

    public function getBaseDN() {
        return $this->baseDN;
    }

    public function setBaseDN($baseDN) {
        $this->baseDN = $baseDN;
        return $this;
    }
}
