<?php

namespace Cadoles\CronBundle\Command;

use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Doctrine\ORM\Mapping\ClassMetadata;
use Doctrine\ORM\Id\AssignedGenerator;

use Cadoles\CronBundle\Entity\Cron;

class InitDataCommand extends ContainerAwareCommand
{
    private $entityManager;

    protected function configure()
    {
        $this
            ->setName('Cron:InitData')
            ->setDescription('Init Data for Cron')
            ->setHelp('This command Init Data for Portal')
        ;
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $this->entityManager = $this->getContainer()->get('doctrine')->getEntityManager();

       
        $cron_activate = $this->getContainer()->getParameter('cron_activate');
        if(!$cron_activate)
            return false;

        $output->writeln('CRON = Default Data');

        $this->insertCron();

        $output->writeln('');

        return $this->entityManager->flush();
    }

    protected function insertCron() {
        // Job Mail
        // Toute les minutes
        $entity = $this->entityManager->getRepository('CadolesCronBundle:Cron')->find(1);
        if(!$entity) {
            $entity = new Cron;
            $entity->setCommand("Cron:Mail");
            $entity->setDescription("Execution du spool de mail en attente");
            $entity->setId(1);
            $entity->setStatut(2);
            $entity->setRepeatcall(0);
            $entity->setRepeatexec(0);
            $entity->setRepeatinterval(60);
            $entity->setNextexecdate($entity->getSubmitdate());
            $entity->setJsonargument('{"message-limit":"100","env":"prod"}');
            $this->entityManager->persist($entity);
        }


        // afin de forcer les ID sur certaines entités
        $metadata = $this->entityManager->getClassMetaData(get_class($entity));
        $metadata->setIdGeneratorType(ClassMetadata::GENERATOR_TYPE_NONE);
        $metadata->setIdGenerator(new AssignedGenerator());
                
        // Job synchronisation des comptes utilisateur
        // Toute les 24h à 3h00
        $entity = $this->entityManager->getRepository('CadolesCronBundle:Cron')->find(100);
        if(!$entity) {
            $entity = new Cron;
            $nextdate=$entity->getSubmitdate();
            $nextdate->setTime(3,0);            
            $entity->setCommand("Core:Synchro");
            $entity->setDescription("Synchronisation des Comptes Utilisateurs");
            $entity->setId(100);
            $entity->setStatut(2);
            $entity->setRepeatcall(0);
            $entity->setRepeatexec(0);
            $entity->setRepeatinterval(86400);
            $entity->setNextexecdate($nextdate);
            $entity->setJsonargument('{"simulate":"false"}');
            $this->entityManager->persist($entity);
        }

        // Job de purge des fichiers obsolète
        // Toute les 24h à 3h00
        $entity = $this->entityManager->getRepository('CadolesCronBundle:Cron')->find(200);
        if(!$entity) {
            $entity = new Cron;
            $nextdate=$entity->getSubmitdate();
            $nextdate->setTime(3,0);            
            $entity->setCommand("Core:PurgeFile");
            $entity->setDescription("Suppression des fichiers obsolètes");
            $entity->setId(200);
            $entity->setStatut(2);
            $entity->setRepeatcall(0);
            $entity->setRepeatexec(0);
            $entity->setRepeatinterval(86400);
            $entity->setNextexecdate($nextdate);
            $this->entityManager->persist($entity);
        }

        // Job synchronisation des comptes utilisateur
        // Toute les 24h à 4h00
        $entity = $this->entityManager->getRepository('CadolesCronBundle:Cron')->find(210);
        if(!$entity) {
            $entity = new Cron;
            $nextdate=$entity->getSubmitdate();
            $nextdate->setTime(4,0);            
            $entity->setCommand("Core:synchroEther");
            $entity->setDescription("Synchronisation Nineboard <> Ether");
            $entity->setId(210);
            $entity->setStatut(2);
            $entity->setRepeatcall(0);
            $entity->setRepeatexec(0);
            $entity->setRepeatinterval(86400);
            $entity->setNextexecdate($nextdate);
            $entity->setJsonargument('{"simulate":"false"}');
            $this->entityManager->persist($entity);
        }

        // Job Dump
        // Toute les 24h à 2h00
        $entity = $this->entityManager->getRepository('CadolesCronBundle:Cron')->find(220);
        if(!$entity) {
            $entity = new Cron;
            $nextdate=$entity->getSubmitdate();
            $nextdate->setTime(2,0);            
            $entity->setCommand("Cron:Dump");
            $entity->setDescription("Sauvegarde de la BDD");
            $entity->setId(220);
            $entity->setStatut(2);
            $entity->setRepeatcall(0);
            $entity->setRepeatexec(0);
            $entity->setRepeatinterval(86400);
            $entity->setNextexecdate($nextdate);
            $this->entityManager->persist($entity);
        }
        
        $this->entityManager->flush();
    }
}
