<?php

namespace Cadoles\WebsocketBundle\Topic;

use Gos\Bundle\WebSocketBundle\Topic\TopicInterface;
use Ratchet\ConnectionInterface;
use Ratchet\Wamp\Topic;
use Gos\Bundle\WebSocketBundle\Router\WampRequest;

use Doctrine\ORM\EntityManager;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Gos\Bundle\WebSocketBundle\Client\ClientManipulatorInterface;

use Cadoles\CoreBundle\Entity\Scrum;
use Cadoles\CoreBundle\Entity\Scrumcolumn;
use Cadoles\CoreBundle\Entity\Scrumwidget;
use Cadoles\CoreBundle\Entity\Message;

class WebsocketScrum implements TopicInterface
{

    protected $em;
    protected $container;
    protected $clientManipulator;

    public function __construct(ClientManipulatorInterface $clientManipulator, EntityManager $em, ContainerInterface $container) {
        $this->clientManipulator = $clientManipulator;
        $this->em = $em;
        $this->container = $container;
    }

    /**
    * Like RPC is will use to prefix the channel
    * @return string
    */
    public function getName()
    {
        return 'websocket.scrum';
    }

    /**
     * This will receive any Subscription requests for this topic.
     *
     * @param ConnectionInterface $connection
     * @param Topic $topic
     * @param WampRequest $request
     * @return void
     */
    public function onSubscribe(ConnectionInterface $connection, Topic $topic, WampRequest $request)
    {      
        //this will broadcast the message to ALL subscribers of this topic.
        $topic->broadcast(['log' => $connection->resourceId." has joined ".$topic->getId()]);
        
    }

    /**
     * This will receive any UnSubscription requests for this topic.
     *
     * @param ConnectionInterface $connection
     * @param Topic $topic
     * @param WampRequest $request
     * @return void
     */
    public function onUnSubscribe(ConnectionInterface $connection, Topic $topic, WampRequest $request)
    {
        //this will broadcast the message to ALL subscribers of this topic.
        $topic->broadcast(['log' => $connection->resourceId . " has left " . $topic->getId()]);
        $topic->broadcast(['unnotify' => "true", 'from' => $connection->resourceId]);
    }


    /**
     * This will receive any Publish requests for this topic.
     *
     * @param ConnectionInterface $connection
     * @param Topic $topic
     * @param WampRequest $request
     * @param $event
     * @param array $exclude
     * @param array $eligible
     * @return mixed|void
     */
    public function onPublish(ConnectionInterface $connection, Topic $topic, WampRequest $request, $event, array $exclude, array $eligible)
    {
        $id=$request->getAttributes()->get('scrum');
        if(!is_array($event)) $event=json_decode($event, true);

        if($event["type"]=="unnotify") {
            $topic->broadcast(['log'    => "Cast addcol"]);
            $topic->broadcast(['unnotify' => "true", 'from' => $connection->resourceId]);
        }

        if($event["type"]=="addcol") {
            $topic->broadcast(['log'    => "Cast addcol"]);

            // Récupérer le scrum
            $scrum=$this->em->getRepository("CadolesCoreBundle:Scrum")->find($id);

            // On resize les colonnes
            $scrumcolumns=$this->em->getRepository("CadolesCoreBundle:Scrumcolumn")->findBy(['scrum'=>$scrum],['roworder'=>'ASC']);
            $nbcol=0;
            foreach($scrumcolumns as $scrumcolumn) {
                $scrumcolumn->setSize(str_replace("col-md-","",$event["sizes"][$nbcol]));
                $nbcol++;
            }

            // On recherche le derniers roworder de colonne pour ce scrum
            $last=$this->em->getRepository("CadolesCoreBundle:Scrumcolumn")->findOneBy(['scrum'=>$scrum],['roworder'=>'DESC']);
            $roworder=($last?$last->getRoworder()+1:1);


            // On gérère la nouvelle colonne
            $col= new Scrumcolumn();
            $col->setTitle("COLONNE ".$roworder);
            $col->setRoworder($roworder);
            $col->setScrum($scrum);
            $col->setSize(str_replace("col-md-","",$event["sizes"][$nbcol]));
            $this->em->persist($col);
            $this->em->flush();
            
            // Send event
            $topic->broadcast(['addcol' => "true", 'from' => $connection->resourceId, 'id' => $col->getId(), 'title' => $col->getTitle()]);
        }

        if($event["type"]=="delcol") {
            $topic->broadcast(['log'    => "Cast delcol"]);

            // Récupérer le scrum
            $scrum=$this->em->getRepository("CadolesCoreBundle:Scrum")->find($id);

            // On recherche la colonne pour la supprimer
            $col=$this->em->getRepository("CadolesCoreBundle:Scrumcolumn")->find($event["id"]);
            if($col) {
                $this->em->remove($col);
                $this->em->flush(); 
            }

            // On resize les colonnes
            $scrumcolumns=$this->em->getRepository("CadolesCoreBundle:Scrumcolumn")->findBy(['scrum'=>$scrum],['roworder'=>'ASC']);
            $nbcol=0;
            foreach($scrumcolumns as $scrumcolumn) {
                $scrumcolumn->setSize(str_replace("col-md-","",$event["sizes"][$nbcol]));
                $nbcol++;
                $this->em->flush(); 
            }
                           

            // Send event
            $topic->broadcast(['delcol' => "true", 'from' => $connection->resourceId, 'id' => $event["id"]]);
        }     
        
        if($event["type"]=="maxleftcol") {
            $topic->broadcast(['log'    => "Cast maxleftcol"]);

            // On resize la colonne en cours
            $col=$this->em->getRepository("CadolesCoreBundle:Scrumcolumn")->find($event["id"]);
            if($col) {
                $col->setSize($event["size"]);
                $this->em->persist($col);
                $this->em->flush();                
            }

            // On resize la colonne précédente
            $col=$this->em->getRepository("CadolesCoreBundle:Scrumcolumn")->find($event["idprev"]);
            if($col) {
                $col->setSize($event["sizeprev"]);
                $this->em->persist($col);
                $this->em->flush();                
            }

            // Send event
            $topic->broadcast(['maxleftcol' => "true", 'from' => $connection->resourceId, 'id' => $event["id"]]);
        } 
        
        if($event["type"]=="maxrightcol") {
            $topic->broadcast(['log'    => "Cast maxrightcol"]);

            // On resize la colonne en cours
            $col=$this->em->getRepository("CadolesCoreBundle:Scrumcolumn")->find($event["id"]);
            if($col) {
                $col->setSize($event["size"]);
                $this->em->persist($col);
                $this->em->flush();                
            }

            // On resize la colonne suivante
            $col=$this->em->getRepository("CadolesCoreBundle:Scrumcolumn")->find($event["idnext"]);
            if($col) {
                $col->setSize($event["sizenext"]);
                $this->em->persist($col);
                $this->em->flush();                
            }

            // Send event            
            $topic->broadcast(['maxrightcol' => "true", 'from' => $connection->resourceId, 'id' => $event["id"]]);
        }         

        if($event["type"]=="startmovecol") {
            $topic->broadcast(['log'    => "Cast startmovecol"]);

            // Send event
            $topic->broadcast(['startmovecol' => "true", 'from' => $connection->resourceId, 'id' => $event["id"], 'message' => $this->who($event["from"])." déplace la colonne"]);
        }        

        if($event["type"]=="ordercol") {
            $topic->broadcast(['log'    => "Cast ordercol"]);

            // On ordonne la colonne en cours
            $col=$this->em->getRepository("CadolesCoreBundle:Scrumcolumn")->find($event["id"]);
            if($col) {
                $col->setRoworder($event["order"]);
                $this->em->persist($col);
                $this->em->flush();                
            }

            // Send event
            $topic->broadcast(['ordercol' => "true", 'from' => $connection->resourceId, 'id' => $event["id"], 'order' => $event["order"]]);
        }     
        
        if($event["type"]=="starteditcol") {
            $topic->broadcast(['log'    => "Cast starteditcol"]);

            // Send event
            $topic->broadcast(['starteditcol' => "true", 'from' => $connection->resourceId, 'id' => $event["id"], 'message' => $this->who($event["from"])." modifie le titre de la colonne"]);
        }   
        
        if($event["type"]=="editcol") {
            $topic->broadcast(['log'    => "Cast editcol"]);

            // On modifie le titre de la colonne en cours
            $col=$this->em->getRepository("CadolesCoreBundle:Scrumcolumn")->find($event["id"]);
            if($col) {
                $col->setTitle($event["title"]);
                $this->em->persist($col);
                $this->em->flush();                
            }

            // Send event
            $topic->broadcast(['editcol' => "true", 'from' => $connection->resourceId, 'id' => $event["id"], 'title' => $event["title"]]);
        }         

        if($event["type"]=="addwid") {
            $topic->broadcast(['log'    => "Cast addwid to column ".$event["id"]]);

            // Récupérer la colonne
            $scrumcolumn=$this->em->getRepository("CadolesCoreBundle:Scrumcolumn")->find($event["id"]);

            // Récupérer le créateur
            $user=$this->em->getRepository("CadolesCoreBundle:User")->find($event["from"]);

            // On recherche le derniers roworder de widget pour cette colonne
            $last=$this->em->getRepository("CadolesCoreBundle:Scrumwidget")->findOneBy(['scrumcolumn'=>$scrumcolumn],['roworder'=>'DESC']);
            $roworder=($last?$last->getRoworder()+1:1);


            // On gérère le nouveau widget
            $wid= new Scrumwidget();
            $wid->setTitle("BILLET ".$roworder);
            $wid->setRoworder($roworder);
            $wid->setScrumcolumn($scrumcolumn);
            $wid->setUser($user);
            $this->em->persist($wid);
            $this->em->flush();

            $topic->broadcast([
                'addwid' => "true",
                'from' => $connection->resourceId,
                'id' => $event["id"],
                'idwid' => $wid->getId(),
                'title' => $wid->getTitle(),
                'description' => "",
                'username' => ($user?$user->getUsername():""),
                'filetype' => "",
                'file' => "",
            ]);
        }  

        if($event["type"]=="delwid") {
            $topic->broadcast(['log'    => "Cast delwid"]);

            // On recherche le widget pour le supprimer
            $wid=$this->em->getRepository("CadolesCoreBundle:Scrumwidget")->find($event["id"]);
            if($wid) {
                $this->em->remove($wid);
                $this->em->flush(); 
            }                         

            // Send event
            $topic->broadcast(['delwid' => "true", 'from' => $connection->resourceId, 'id' => $event["id"]]);
        } 

        if($event["type"]=="startmovewid") {
            $topic->broadcast(['log'    => "Cast startmovewid"]);

            // Send event
            $topic->broadcast(['startmovewid' => "true", 'from' => $connection->resourceId, 'id' => $event["id"], 'message' => $this->who($event["from"])." déplace le billet"]);
        }  
        
        if($event["type"]=="orderwid") {
            $topic->broadcast(['log'    => "Cast orderwid"]);

            // On recherche la colonne liée au widget
            $col=$this->em->getRepository("CadolesCoreBundle:Scrumcolumn")->find($event["colid"]);
            if($col) {
                // On ordonne la colonne en cours
                $wid=$this->em->getRepository("CadolesCoreBundle:Scrumwidget")->find($event["id"]);
                if($wid) {
                    $wid->setRoworder($event["order"]);
                    $wid->setScrumcolumn($col);
                    $this->em->persist($wid);
                    $this->em->flush();                
                }
            }

            // Send event
            $topic->broadcast(['orderwid' => "true", 'from' => $connection->resourceId, 'colid' => $event["colid"], 'id' => $event["id"], 'order' => $event["order"]]);
        }  

        if($event["type"]=="starteditwid") {
            $topic->broadcast(['log'    => "Cast starteditwid"]);

            // Send event
            $topic->broadcast(['starteditwid' => "true", 'from' => $connection->resourceId, 'id' => $event["id"], 'message' => $this->who($event["from"])." modifie le billet"]);
        }         

        if($event["type"]=="editwid") {
            $topic->broadcast(['log'    => "Cast editwid"]);

            // On modifie le widget en cours
            $wid=$this->em->getRepository("CadolesCoreBundle:Scrumwidget")->find($event["id"]);
            if($wid) {
                if($event["filetype"]=="youtube"&&stripos($event["file"],"https://www.youtube.com/embed")===false&&stripos($event["file"],"youtube")!==false) {
                    $event["file"]=str_replace("http://www.youtube.com","https://www.youtube.com",$event["file"]);
                    $event["file"]=str_replace("https://www.youtube.com/watch?v=","",$event["file"]);     
                    $tmp=explode("&",$event["file"]);
                    $event["file"]="https://www.youtube.com/embed/".$tmp[0];                                       
                }

                // Modification de l'url peertube
                if($event["filetype"]=="youtube"&&stripos($event["file"],"/watch/")!==false) {
                    $event["file"]=str_replace("/watch/","/embed/",$event["file"]);   
                }

                $wid->setTitle($event["title"]);
                $wid->setDescription($event["description"]);
                $wid->setFiletype($event["filetype"]);
                $wid->setFile($event["file"]);

                $this->em->persist($wid);
                $this->em->flush();                
            }

            // Send event
            $topic->broadcast(['editwid' => "true", 'from' => $connection->resourceId, 'id' => $event["id"], 'title' => $event["title"], 'description' => $event["description"], 'filetype' => $event["filetype"], 'file' => $event["file"]]);
        }          

        if($event["type"]=="canceleditwid") {
            $topic->broadcast(['log'    => "Cast canceleditwid"]);

            // Send event
            $topic->broadcast(['canceleditwid' => "true", 'from' => $connection->resourceId]);
        }           

        if($event["type"]=="startuplowid"){
            // Send event
            $topic->broadcast(['starteditcol' => "true", 'from' => $connection->resourceId, 'id' => $event["id"], 'message' => "télécharge des PJ"]);
        }  
        
        if($event["type"]=="stopuplowid"){
            // Send event
            $topic->broadcast(['stopuplowid' => "true", 'from' => $connection->resourceId, 'id' => $event["id"]]);
        }        
        
            
        if($event["type"]=="addmessage"){
            $scrum=$this->em->getRepository("CadolesCoreBundle:Scrum")->find($id);
            $wid=$this->em->getRepository("CadolesCoreBundle:Scrumwidget")->find($event["id"]);
            $user=$this->em->getRepository("CadolesCoreBundle:User")->findOneBy(["username"=>$event["username"]]);
            if($wid&&$user) {
                // On gérère le nouveau message
                $mes= new Message();
                $mes->setMessage($event["message"]);
                $mes->setScrumwidget($wid);
                $mes->setUser($user);

                $this->em->persist($mes);
                $this->em->flush();      
                
                $event["idmsg"]=$mes->getId();
                $event["date"]=$mes->getSubmitdate()->format("d/m/Y H:i");
                $event["usernamne"]=$mes->getUser()->getUsername();
                $event["fgcandel"]=false;
                $event["usermsg"]=$mes->getUser()->getId();
                $event["userwid"]=($wid->getUser()?$wid->getUser()->getId():$scrum->getUser()->getId());
                $event["userboa"]=$scrum->getUser()->getId();

                $topic->broadcast([
                    'addmessage' => "true",
                    'from' => $connection->resourceId,
                    'id' => $event["id"],
                    'idmsg' => $event["idmsg"],
                    'date' => $event["date"],
                    'username' => $event["username"],
                    'fgcandel' => $event["fgcandel"],
                    'usermsg' => $event["usermsg"],
                    'userwid' => $event["userwid"],
                    'userboa' => $event["userboa"],
                    'message' => $event["message"],
                ]);
            }
            else 
                $topic->broadcast(['addmessage' => "true", 'from' => $connection->resourceId, 'id' => $event["id"]]);

        }

        if($event["type"]=="delmessage"){
            $msg=$this->em->getRepository("CadolesCoreBundle:Message")->find($event["id"]);
            if($msg) {
                $event["idwid"]=$msg->getScrumwidget()->getId();
                $this->em->remove($msg);
                $this->em->flush(); 

                $topic->broadcast([
                    'delmessage' => "true",
                    'from' => $connection->resourceId,
                    'id' => $event["id"],
                    'idwid' => $event["idwid"],   
                ]);             
            }
        }
    }

    private function who($id) {
        $user=$this->em->getRepository("CadolesCoreBundle:User")->find($id);
        if($user) return $user->getDisplayname();
        else return "";
    }
}