<?php

namespace Cadoles\WebsocketBundle\Topic;

use Gos\Bundle\WebSocketBundle\Topic\TopicInterface;
use Ratchet\ConnectionInterface;
use Ratchet\Wamp\Topic;
use Gos\Bundle\WebSocketBundle\Router\WampRequest;

use Doctrine\ORM\EntityManager;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Gos\Bundle\WebSocketBundle\Client\ClientManipulatorInterface;

use Cadoles\CoreBundle\Entity\Whiteboard;
use Cadoles\CoreBundle\Entity\Whiteboardcolumn;
use Cadoles\CoreBundle\Entity\Whiteboardwidget;
use Cadoles\CoreBundle\Entity\Message;

class WebsocketWhiteboard implements TopicInterface
{

    protected $em;
    protected $container;
    protected $clientManipulator;

    public function __construct(ClientManipulatorInterface $clientManipulator, EntityManager $em, ContainerInterface $container) {
        $this->clientManipulator = $clientManipulator;
        $this->em = $em;
        $this->container = $container;
    }

    /**
    * Like RPC is will use to prefix the channel
    * @return string
    */
    public function getName()
    {
        return 'websocket.whiteboard';
    }

    /**
     * This will receive any Subscription requests for this topic.
     *
     * @param ConnectionInterface $connection
     * @param Topic $topic
     * @param WampRequest $request
     * @return void
     */
    public function onSubscribe(ConnectionInterface $connection, Topic $topic, WampRequest $request)
    {      
        //this will broadcast the message to ALL subscribers of this topic.
        $topic->broadcast(['log' => $connection->resourceId." has joined ".$topic->getId()]);
        
    }

    /**
     * This will receive any UnSubscription requests for this topic.
     *
     * @param ConnectionInterface $connection
     * @param Topic $topic
     * @param WampRequest $request
     * @return void
     */
    public function onUnSubscribe(ConnectionInterface $connection, Topic $topic, WampRequest $request)
    {
        //this will broadcast the message to ALL subscribers of this topic.
        $topic->broadcast(['log' => $connection->resourceId . " has left " . $topic->getId()]);
        $topic->broadcast(['unnotify' => "true", 'from' => $connection->resourceId]);
    }


    /**
     * This will receive any Publish requests for this topic.
     *
     * @param ConnectionInterface $connection
     * @param Topic $topic
     * @param WampRequest $request
     * @param $event
     * @param array $exclude
     * @param array $eligible
     * @return mixed|void
     */
    public function onPublish(ConnectionInterface $connection, Topic $topic, WampRequest $request, $event, array $exclude, array $eligible)
    {
        $id=$request->getAttributes()->get('whiteboard');
        if(!is_array($event)) $event=json_decode($event, true);

        if($event["type"]=="unnotify") {
            $topic->broadcast(['log'    => "Cast addcol"]);
            $topic->broadcast(['unnotify' => "true", 'from' => $connection->resourceId]);
        }

        if($event["type"]=="addcol") {
            $topic->broadcast(['log'    => "Cast addcol"]);

            // Récupérer le whiteboard
            $whiteboard=$this->em->getRepository("CadolesCoreBundle:Whiteboard")->find($id);

            // On resize les colonnes
            $whiteboardcolumns=$this->em->getRepository("CadolesCoreBundle:Whiteboardcolumn")->findBy(['whiteboard'=>$whiteboard],['roworder'=>'ASC']);
            $nbcol=0;
            foreach($whiteboardcolumns as $whiteboardcolumn) {
                $whiteboardcolumn->setSize(str_replace("col-md-","",$event["sizes"][$nbcol]));
                $nbcol++;
            }

            // On recherche le derniers roworder de colonne pour ce whiteboard
            $last=$this->em->getRepository("CadolesCoreBundle:Whiteboardcolumn")->findOneBy(['whiteboard'=>$whiteboard],['roworder'=>'DESC']);
            $roworder=($last?$last->getRoworder()+1:1);


            // On gérère la nouvelle colonne
            $col= new Whiteboardcolumn();
            $col->setTitle("COLONNE ".$roworder);
            $col->setRoworder($roworder);
            $col->setWhiteboard($whiteboard);
            $col->setSize(str_replace("col-md-","",$event["sizes"][$nbcol]));
            $this->em->persist($col);
            $this->em->flush();
            
            // Send event
            $topic->broadcast(['addcol' => "true", 'from' => $connection->resourceId, 'id' => $col->getId(), 'title' => $col->getTitle()]);
        }

        if($event["type"]=="addwid") {
            $topic->broadcast(['log'    => "Cast addwid"]);

            // Récupération du whiteboard
            $whiteboard=$this->em->getRepository("CadolesCoreBundle:Whiteboard")->find($id);

            // On recherche le derniers roworder pour ce whiteboard
            $last=$this->em->getRepository("CadolesCoreBundle:Whiteboardwidget")->findOneBy(['whiteboard'=>$whiteboard],['roworder'=>'DESC']);
            $roworder=($last?$last->getRoworder()+1:1);

            // Récupérer le créateur
            $user=$this->em->getRepository("CadolesCoreBundle:User")->find($event["from"]);

            // On recherche le derniers roworder de widget pour cette colonne
            $last=$this->em->getRepository("CadolesCoreBundle:Whiteboardwidget")->findOneBy(['whiteboard'=>$whiteboard],['roworder'=>'DESC']);
            $roworder=($last?$last->getRoworder()+1:1);


            // On gérère le nouveau widget
            $wid= new Whiteboardwidget();
            $wid->setTitle("BILLET ".$roworder);
            $wid->setWhiteboard($whiteboard);
            $wid->setPosx(0);
            $wid->setPosy(0);
            $wid->setWidth(350);
            $wid->setRoworder($roworder);
            $wid->setUser($user);

            $this->em->persist($wid);
            $this->em->flush();

            $topic->broadcast([
                'addwid' => "true",
                'from' => $connection->resourceId,
                'id' => $event["id"],
                'idwid' => $wid->getId(),
                'title' => $wid->getTitle(),
                'description' => "",
                'username' => ($user?$user->getUsername():""),
                'filetype' => "",
                'file' => "",
                'posx' => $wid->getPosx(),
                'poxy' => $wid->getPosy(),
                'width' => $wid->getWidth(),
                'roworder' => $wid->getRoworder(),
            ]);
        }  

        if($event["type"]=="delwid") {
            $topic->broadcast(['log'    => "Cast delwid"]);

            // On recherche le widget pour le supprimer
            $wid=$this->em->getRepository("CadolesCoreBundle:Whiteboardwidget")->find($event["id"]);
            if($wid) {
                $topic->broadcast(['log'    => "Cast delwid"]);
                $this->em->remove($wid);
                $this->em->flush(); 
            }                         

            // Send event
            $topic->broadcast(['delwid' => "true", 'from' => $connection->resourceId, 'id' => $event["id"]]);
        } 

        if($event["type"]=="starteditwid") {
            $topic->broadcast(['log'    => "Cast starteditwid"]);

            // Send event
            $topic->broadcast(['starteditwid' => "true", 'from' => $connection->resourceId, 'id' => $event["id"], 'message' => $this->who($event["from"])." modifie le billet"]);
        }         

        if($event["type"]=="editwid") {
            $topic->broadcast(['log'    => "Cast editwid"]);

            // On modifie le widget en cours
            $wid=$this->em->getRepository("CadolesCoreBundle:Whiteboardwidget")->find($event["id"]);
            if($wid) {
                if($event["filetype"]=="youtube"&&stripos($event["file"],"https://www.youtube.com/embed")===false&&stripos($event["file"],"youtube")!==false) {
                    $event["file"]=str_replace("http://www.youtube.com","https://www.youtube.com",$event["file"]);
                    $event["file"]=str_replace("https://www.youtube.com/watch?v=","",$event["file"]);     
                    $tmp=explode("&",$event["file"]);
                    $event["file"]="https://www.youtube.com/embed/".$tmp[0];                                       
                }

                // Modification de l'url peertube
                if($event["filetype"]=="youtube"&&stripos($event["file"],"/watch/")!==false) {
                    $event["file"]=str_replace("/watch/","/embed/",$event["file"]);   
                }

                $wid->setTitle($event["title"]);
                $wid->setDescription($event["description"]);
                $wid->setFiletype($event["filetype"]);
                $wid->setFile($event["file"]);

                $this->em->persist($wid);
                $this->em->flush();                
            }

            // Send event
            $topic->broadcast(['editwid' => "true", 'from' => $connection->resourceId, 'id' => $event["id"], 'title' => $event["title"], 'description' => $event["description"], 'filetype' => $event["filetype"], 'file' => $event["file"]]);
        }          

        if($event["type"]=="canceleditwid") {
            $topic->broadcast(['log'    => "Cast canceleditwid"]);

            // Send event
            $topic->broadcast(['canceleditwid' => "true", 'from' => $connection->resourceId]);
        }           

        if($event["type"]=="sizewid") {
            // Send event
            $topic->broadcast(['sizewid' => "true", 'from' => $connection->resourceId, 'id' => $event["id"], 'width' => $event["width"]]);
        }

        if($event["type"]=="stopsizewid"){
            $wid=$this->em->getRepository("CadolesCoreBundle:Whiteboardwidget")->find($event["id"]);
            if($wid) {
                $wid->setWidth($event["width"]);

                $this->em->persist($wid);
                $this->em->flush();                
            }

            // Send event
            $topic->broadcast(['stopsizewid' => "true", 'from' => $connection->resourceId]);
        }

        if($event["type"]=="movewid") {
            // Send event
            $topic->broadcast(['movewid' => "true", 'from' => $event["from"], 'id' => $event["id"], 'posY' => $event["posY"], 'posX' => $event["posX"], 'topZ' => $event["topZ"] ]);
        } 

        if($event["type"]=="stopmovewid") {
            $wid=$this->em->getRepository("CadolesCoreBundle:Whiteboardwidget")->find($event["id"]);
            if($wid) {
                // On réordonne les widget car celui ci est forcement le dernier
                $roworder=1;
                $whiteboard=$this->em->getRepository("CadolesCoreBundle:Whiteboard")->find($id);
                $orders=$this->em->getRepository("CadolesCoreBundle:Whiteboardwidget")->findBy(["whiteboard"=>$whiteboard],["roworder"=>"ASC"]);
                $tborder=[];
                foreach($orders as $order) {
                    if($order!=$wid) {
                        $order->setRoworder($roworder);
                        $this->em->persist($order);
                        $this->em->flush();                             
                        $tborder[$order->getId()]=$roworder;
                        $roworder=$roworder+1;
                    }
                }
                
                $tborder[$event["id"]]=$roworder;
                $wid->setPosY($event["posY"]);
                $wid->setPosX($event["posX"]);
                $wid->setRoworder($roworder);
                
                $event["tborder"]=$tborder;
                $this->em->persist($wid);
                $this->em->flush();                
            }

            // Send event
            $topic->broadcast(['stopmovewid' => "true", 'from' => $event["from"], 'id' => $event["id"], 'tborder' => $tborder]);
        }
                
        if($event["type"]=="startuplowid"){
            // Send event
            $topic->broadcast(['starteditcol' => "true", 'from' => $connection->resourceId, 'id' => $event["id"], 'message' => "télécharge des PJ"]);
        }  
        
        if($event["type"]=="stopuplowid"){
            // Send event
            $topic->broadcast(['stopuplowid' => "true", 'from' => $connection->resourceId, 'id' => $event["id"]]);
        }        
        
            
        if($event["type"]=="addmessage"){
            $whiteboard=$this->em->getRepository("CadolesCoreBundle:Whiteboard")->find($id);
            $wid=$this->em->getRepository("CadolesCoreBundle:Whiteboardwidget")->find($event["id"]);
            $user=$this->em->getRepository("CadolesCoreBundle:User")->findOneBy(["username"=>$event["username"]]);
            if($wid&&$user) {
                // On gérère le nouveau message
                $mes= new Message();
                $mes->setMessage($event["message"]);
                $mes->setWhiteboardwidget($wid);
                $mes->setUser($user);

                $this->em->persist($mes);
                $this->em->flush();      
                
                $event["idmsg"]=$mes->getId();
                $event["date"]=$mes->getSubmitdate()->format("d/m/Y H:i");
                $event["usernamne"]=$mes->getUser()->getUsername();
                $event["fgcandel"]=false;
                $event["usermsg"]=$mes->getUser()->getId();
                $event["userwid"]=($wid->getUser()?$wid->getUser()->getId():$whiteboard->getUser()->getId());
                $event["userboa"]=$whiteboard->getUser()->getId();

                $topic->broadcast([
                    'addmessage' => "true",
                    'from' => $connection->resourceId,
                    'id' => $event["id"],
                    'idmsg' => $event["idmsg"],
                    'date' => $event["date"],
                    'username' => $event["username"],
                    'fgcandel' => $event["fgcandel"],
                    'usermsg' => $event["usermsg"],
                    'userwid' => $event["userwid"],
                    'userboa' => $event["userboa"],
                    'message' => $event["message"],
                ]);
            }
            else 
                $topic->broadcast(['addmessage' => "true", 'from' => $connection->resourceId, 'id' => $event["id"]]);

        }

        if($event["type"]=="delmessage"){
            $msg=$this->em->getRepository("CadolesCoreBundle:Message")->find($event["id"]);
            if($msg) {
                $event["idwid"]=$msg->getWhiteboardwidget()->getId();
                $this->em->remove($msg);
                $this->em->flush(); 

                $topic->broadcast([
                    'delmessage' => "true",
                    'from' => $connection->resourceId,
                    'id' => $event["id"],
                    'idwid' => $event["idwid"],   
                ]);             
            }
        }
    }

    private function who($id) {
        $user=$this->em->getRepository("CadolesCoreBundle:User")->find($id);
        if($user) return $user->getDisplayname();
        else return "";
    }
}