<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Form\FormError;
use App\Service\ethercalcService;

use App\Entity\Ethercalc as Entity;
use App\Form\EthercalcType as Form;

class EthercalcController extends AbstractController
{
    private $data   = "ethercalc";
    private $route  = "app_ethercalc";
    private $render = "Ethercalc/";
    private $entity = "App:Ethercalc";

    public function __construct(ethercalcService $ethercalc) { $this->ethercalc = $ethercalc; }

    public function list(Request $request)
    {
        $em = $this->getDoctrine()->getManager();
        $datas = $em->getRepository($this->entity)->findAll();

        return $this->render($this->render.'list.html.twig',[
            $this->data."s" => $datas,
            "useheader"     => true,
            "usesidebar"    => true,
        ]);
    }

    public function submit(Request $request,$access="user") {
        // Initialisation de l'enregistrement
        $em = $this->getDoctrine()->getManager();
        $data = new Entity();
        if($access=="user") $data->setUser($this->getUser());

        // Création du formulaire
        $form = $this->createForm(Form::class,$data,array("mode"=>"submit", "access" => $access));

        // Récupération des data du formulaire
        $form->handleRequest($request);
        
        // Sur erreur
        $this->getErrorForm(null,$form,$request,$data,"submit");
        
        // Sur validation
        if ($form->get('submit')->isClicked() && $form->isValid()) {  
            $data = $form->getData();  
            
            $em->persist($data);
            $em->flush();

            // Création du calc dans ethercalc
            $this->ethercalc->createCalc($data->getTitle());

            // Retour à la liste
            if($access=="user")
                return $this->redirect($this->generateUrl('app_home'));          
            else 
                return $this->redirect($this->generateUrl('app_admin_ethercalc'));    
        }

        // Affichage du formulaire
        return $this->render($this->render.'edit.html.twig', [
            'useheader'         => true,
            'usesidebar'        => ($access=="admin"),     
            'maxwidth'          => ($access=="user"),            
            $this->data         => $data,
            'mode'              => 'submit',
            'form'              => $form->createView(),
            'access'            => $access,
        ]);
    }

    public function update($id, Request $request,$access="user") {
        $em = $this->getDoctrine()->getManager();
        $data=$em->getRepository($this->entity)->find($id);
        if (!$data) throw $this->createNotFoundException('Unable to find entity.');
        if($data->getUser()!=$this->getUser()&&!$this->getUser()->hasRole("ROLE_ADMIN")&&!$this->getUser()->hasRole("ROLE_MODO")) 
        throw $this->createNotFoundException('Permission denied');

        // Création du formulaire
        $form = $this->createForm(Form::class,$data,array("mode"=>"update", "access" => $access));

        // Récupération des data du formulaire
        $form->handleRequest($request);

        // Sur erreur
        $this->getErrorForm(null,$form,$request,$data,"update");
        
        // Sur validation
        if ($form->get('submit')->isClicked() && $form->isValid()) {  
            $data = $form->getData();  
            $em->persist($data);
            $em->flush();

            // Création du calc dans ethercalc
            $this->ethercalc->createCalc($data->getTitle());

            // Retour à la liste
            if($access=="user")
                return $this->redirect($this->generateUrl('app_home'));          
            else 
                return $this->redirect($this->generateUrl('app_admin_ethercalc'));     

        }
        
        // Affichage du formulaire
        return $this->render($this->render.'edit.html.twig', [
            'useheader'         => true,
            'usesidebar'        => ($access=="admin"),  
            'maxwidth'          => ($access=="user"),
            $this->data         => $data,
            'mode'              => 'update',
            'form'              => $form->createView(),
            'access'            => $access
        ]);        
    }

    public function delete($id, Request $request,$access="user") {
        $em = $this->getDoctrine()->getManager();
        $data=$em->getRepository($this->entity)->find($id);
        if (!$data) throw $this->createNotFoundException('Unable to find entity.');
        if($data->getUser()!=$this->getUser()&&!$this->getUser()->hasRole("ROLE_ADMIN")&&!$this->getUser()->hasRole("ROLE_MODO")) 
        throw $this->createNotFoundException('Permission denied');

        $em->remove($data);
        $em->flush();
        
        // Suppression du calc dans ethercalc
        $this->ethercalc->deleteCalc($data->getTitle());

        if($access=="user")
            return $this->redirect($this->generateUrl('app_home'));          
        else
            return $this->redirect($this->generateUrl('app_admin_ethercalc'));          
    }    

    protected function getErrorForm($id,$form,$request,$data,$mode) {
        if ($form->get('submit')->isClicked()&&$mode=="delete") {
        }

        if ($form->get('submit')->isClicked() && $mode=="submit") {
        }

        if ($form->get('submit')->isClicked() && ($mode=="submit" || $mode=="update")) {
        }

        if ($form->get('submit')->isClicked() && !$form->isValid()) {
            $this->get('session')->getFlashBag()->clear();

            $errors = $form->getErrors();
            foreach( $errors as $error ) {
                $request->getSession()->getFlashBag()->add("error", $error->getMessage());
            }
        }
    }      
}
