<?php

namespace App\Repository;

use App\Entity\User;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Common\Persistence\ManagerRegistry;

class UserRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, User::class);
    }

    public function getUserpreference($user,$key,$id) {
        // Récupérer les préférences de l'utilisateur
        $preference=$user->getPreference();

        if(is_array($preference)&&array_key_exists($key,$preference)&&array_key_exists($id,$preference[$key]))
            return $preference[$key][$id];
        else
            return null;
    }

    public function setUserpreference($user,$key,$id,$value) {
        // Récupérer les préférences de l'utilisateur
        $preference=$user->getPreference();

        // Mise à jour de la préférence
        $toupdate=false;
        if(!is_array($preference)) {
            $toupdate=true;
            $preference=[];
        }

        if(!array_key_exists($key,$preference)) {
            $toupdate=true;
            $preference[$key]=[];
        }
        if((!array_key_exists($id,$preference[$key]))) {
            $toupdate=true;
            $preference[$key][$id]=$value;
        }
        if($preference[$key][$id]!=$value) {
            $toupdate=true;
            $preference[$key][$id]=$value;            
        }        

        // Mise à jour des préferences
        if($toupdate) {
            $user->setPreference($preference);
            $this->_em->persist($user);
            $this->_em->flush();             
        }
    }
}
