/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.cas;

import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.cas.endpoints.AuthorizationEndpoint;
import org.keycloak.protocol.cas.endpoints.LogoutEndpoint;
import org.keycloak.protocol.cas.endpoints.SamlValidateEndpoint;
import org.keycloak.protocol.cas.endpoints.ServiceValidateEndpoint;
import org.keycloak.protocol.cas.endpoints.ValidateEndpoint;
import org.keycloak.services.resources.RealmsResource;

public class CASLoginProtocolService {
    private KeycloakSession session;
    private RealmModel realm;
    private EventBuilder event;

    public CASLoginProtocolService(KeycloakSession session, EventBuilder event) {
        this.session = session;
        this.realm = session.getContext().getRealm();
        this.event = event;
    }

    public static UriBuilder serviceBaseUrl(UriBuilder baseUriBuilder) {
        return baseUriBuilder.path(RealmsResource.class).path("{realm}/protocol/cas");
    }

    @Path(value="login")
    public Object login() {
        return new AuthorizationEndpoint(this.session, this.event);
    }

    @Path(value="logout")
    public Object logout() {
        return new LogoutEndpoint(this.session, this.realm);
    }

    @Path(value="validate")
    public Object validate() {
        return new ValidateEndpoint(this.session, this.realm, this.event);
    }

    @Path(value="samlValidate")
    public Object validateSaml11() {
        return new SamlValidateEndpoint(this.session, this.realm, this.event);
    }

    @Path(value="serviceValidate")
    public Object serviceValidate() {
        return new ServiceValidateEndpoint(this.session, this.realm, this.event);
    }

    @Path(value="proxyValidate")
    public Object proxyValidate() {
        return this.serviceValidate();
    }

    @Path(value="proxy")
    public Object proxy() {
        return Response.serverError().entity((Object)"Not implemented").build();
    }

    @Path(value="p3/serviceValidate")
    public Object p3ServiceValidate() {
        return this.serviceValidate();
    }

    @Path(value="p3/proxyValidate")
    public Object p3ProxyValidate() {
        return this.proxyValidate();
    }
}

