/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.cas.endpoints;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.AuthorizationEndpointBase;
import org.keycloak.protocol.cas.CASLoginProtocol;
import org.keycloak.protocol.oidc.utils.RedirectUtils;
import org.keycloak.services.ErrorPageException;
import org.keycloak.services.util.CacheControlUtil;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.CommonClientSessionModel;

public class AuthorizationEndpoint
extends AuthorizationEndpointBase {
    private static final Logger logger = Logger.getLogger(AuthorizationEndpoint.class);
    private ClientModel client;
    private AuthenticationSessionModel authenticationSession;
    private String redirectUri;

    public AuthorizationEndpoint(KeycloakSession session, EventBuilder event) {
        super(session, event);
        event.event(EventType.LOGIN);
    }

    @GET
    public Response build() {
        MultivaluedMap params = this.session.getContext().getUri().getQueryParameters();
        String service = (String)params.getFirst((Object)"service");
        boolean isSaml11Request = false;
        if (service == null && params.containsKey((Object)"TARGET")) {
            service = (String)params.getFirst((Object)"TARGET");
            isSaml11Request = true;
        }
        boolean renew = params.containsKey((Object)"renew");
        boolean gateway = params.containsKey((Object)"gateway");
        this.checkSsl();
        this.checkRealm();
        this.checkClient(service);
        this.authenticationSession = this.createAuthenticationSession(this.client, null);
        this.updateAuthenticationSession();
        CacheControlUtil.noBackButtonCacheControlHeader((KeycloakSession)this.session);
        if (renew) {
            this.authenticationSession.setClientNote("renew", "true");
        }
        if (gateway) {
            this.authenticationSession.setClientNote("gateway", "true");
        }
        if (isSaml11Request) {
            this.authenticationSession.setClientNote("TARGET", "true");
        }
        this.event.event(EventType.LOGIN);
        return this.handleBrowserAuthenticationRequest(this.authenticationSession, new CASLoginProtocol(this.session, this.realm, (UriInfo)this.session.getContext().getUri(), this.headers, this.event), gateway, false);
    }

    private void checkClient(String service) {
        if (service == null) {
            this.event.error("invalid_request");
            throw new ErrorPageException(this.session, Response.Status.BAD_REQUEST, "missingParameterMessage", new Object[]{"service"});
        }
        this.event.detail("redirect_uri", service);
        this.client = this.realm.getClientsStream().filter(c -> "cas".equals(c.getProtocol())).filter(c -> RedirectUtils.verifyRedirectUri((KeycloakSession)this.session, (String)service, (ClientModel)c) != null).findFirst().orElse(null);
        if (this.client == null) {
            this.event.error("client_not_found");
            throw new ErrorPageException(this.session, Response.Status.BAD_REQUEST, "clientNotFoundMessage", new Object[0]);
        }
        if (!this.client.isEnabled()) {
            this.event.error("client_disabled");
            throw new ErrorPageException(this.session, Response.Status.BAD_REQUEST, "clientDisabledMessage", new Object[0]);
        }
        this.redirectUri = RedirectUtils.verifyRedirectUri((KeycloakSession)this.session, (String)service, (ClientModel)this.client);
        this.event.client(this.client.getClientId());
        this.event.detail("redirect_uri", this.redirectUri);
        this.session.getContext().setClient(this.client);
    }

    private void updateAuthenticationSession() {
        this.authenticationSession.setProtocol("cas");
        this.authenticationSession.setRedirectUri(this.redirectUri);
        this.authenticationSession.setAction(CommonClientSessionModel.Action.AUTHENTICATE.name());
    }
}

