/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.cas.endpoints;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.keycloak.common.ClientConnection;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.oidc.utils.RedirectUtils;
import org.keycloak.services.ErrorPage;
import org.keycloak.services.managers.AuthenticationManager;

public class LogoutEndpoint {
    private static final Logger logger = Logger.getLogger(LogoutEndpoint.class);
    private KeycloakSession session;
    private RealmModel realm;
    private String redirectUri;

    public LogoutEndpoint(KeycloakSession session, RealmModel realm) {
        this.session = session;
        this.realm = realm;
    }

    @GET
    @NoCache
    public Response logout(@QueryParam(value="service") String service) {
        this.checkClient(service);
        AuthenticationManager.AuthResult authResult = AuthenticationManager.authenticateIdentityCookie((KeycloakSession)this.session, (RealmModel)this.realm, (boolean)false);
        if (authResult != null) {
            UserSessionModel userSession = authResult.getSession();
            userSession.setNote("KEYCLOAK_LOGOUT_PROTOCOL", "cas");
            if (this.redirectUri != null) {
                userSession.setNote("CAS_LOGOUT_REDIRECT_URI", this.redirectUri);
            }
            logger.debug((Object)"Initiating CAS browser logout");
            Response response = AuthenticationManager.browserLogout((KeycloakSession)this.session, (RealmModel)this.realm, (UserSessionModel)authResult.getSession(), (UriInfo)this.session.getContext().getUri(), (ClientConnection)this.session.getContext().getConnection(), (HttpHeaders)this.session.getContext().getRequestHeaders());
            logger.debug((Object)"finishing CAS browser logout");
            return response;
        }
        if (this.redirectUri != null) {
            logger.debugv("no active session, redirecting to {0}", (Object)this.redirectUri);
            return Response.status((int)302).location(URI.create(this.redirectUri)).build();
        }
        return ErrorPage.error((KeycloakSession)this.session, null, (Response.Status)Response.Status.BAD_REQUEST, (String)"failedLogout", (Object[])new Object[0]);
    }

    private void checkClient(String service) {
        if (service == null) {
            return;
        }
        ClientModel client = this.realm.getClientsStream().filter(c -> "cas".equals(c.getProtocol())).filter(c -> RedirectUtils.verifyRedirectUri((KeycloakSession)this.session, (String)service, (ClientModel)c) != null).findFirst().orElse(null);
        if (client != null) {
            this.redirectUri = RedirectUtils.verifyRedirectUri((KeycloakSession)this.session, (String)service, (ClientModel)client);
            this.session.getContext().setClient(client);
        }
    }
}

