/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.cas.endpoints;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.cas.endpoints.AbstractValidateEndpoint;
import org.keycloak.protocol.cas.utils.CASValidationException;

public class ValidateEndpoint
extends AbstractValidateEndpoint {
    private static final String RESPONSE_OK = "yes\n";
    private static final String RESPONSE_FAILED = "no\n";

    public ValidateEndpoint(KeycloakSession session, RealmModel realm, EventBuilder event) {
        super(session, realm, event);
    }

    @GET
    @NoCache
    public Response build() {
        MultivaluedMap params = this.session.getContext().getUri().getQueryParameters();
        String service = (String)params.getFirst((Object)"service");
        String ticket = (String)params.getFirst((Object)"ticket");
        boolean renew = params.containsKey((Object)"renew");
        this.event.event(EventType.CODE_TO_TOKEN);
        try {
            this.checkSsl();
            this.checkRealm();
            this.checkClient(service);
            this.checkTicket(ticket, renew);
            this.event.success();
            return this.successResponse();
        }
        catch (CASValidationException e) {
            return this.errorResponse(e);
        }
    }

    protected Response successResponse() {
        String response = RESPONSE_OK + this.clientSession.getUserSession().getUser().getUsername() + "\n";
        return Response.ok((Object)response).type("text/plain").build();
    }

    protected Response errorResponse(CASValidationException e) {
        return Response.status((Response.Status)e.getStatus()).entity((Object)RESPONSE_FAILED).type("text/plain").build();
    }
}

