#!/bin/bash

envfile=/etc/apache2/conf.d/env.conf
haveenv=/etc/apache2/haveenv.txt

rm -rf $envfile
rm -rf $haveenv

echo "GENERATION DES VARIABLES D'ENVIRONNEMENT"
printf "\n# Expose environment variables to scripts.\nPassEnv" >> $envfile
compgen -e | while read name ; do
    if [[ "$name" != "TERM" && "$name" != "HOME" && "$name" != "HOSTNAME" && "$name" != "PATH" && "$name" != "PWD" && "$name" != "SHLVL" ]]
    then
        touch $haveenv
        printf " $name" >> $envfile
    fi
done
printf "\n" >> $envfile

if [[ ! -f $haveenv ]]
then
    rm -rf $envfile
fi
rm -rf $haveenv

echo "START HTTPD"
httpd -DFOREGROUND
