#!/bin/bash

if [[ ! -f /bitnami/openldap/.isinit ]]
then
    echo ""
    echo "Initialisation annuaire"
    echo ""

    # Suppression de l'entrée users généré automatiquement par l'image docker bitnami/openldap
    ldapdelete ou=users,${LDAP_BASEDN} -r -H ldap://${LDAP_HOST}:${LDAP_PORT} -D ${LDAP_USER} -w ${LDAP_PASSWORD} 2>/dev/null

    # Integration du ldif de base
    ldapadd -H ldap://${LDAP_HOST}:${LDAP_PORT} -D ${LDAP_USER} -w ${LDAP_PASSWORD} -f '/nine/ldif/nine.ldif' 2>/dev/null

    /nine/changepassword.sh admin ${ADMIN_PASSWORD}

    touch /bitnami/openldap/.isinit
fi
