#!/bin/bash

function upkeycloak {
    if [[ $KEYCLOAK_ACTIVATE == 1 && $KEYCLOAK_LOCAL == 1 ]]
    then
        Title ${KEYCLOAK_SERVICE_NAME^^}

        # CREATE BDD
        if [[ $MARIADB_ACTIVATE == 1 && $MARIADB_LOCAL == 1 ]]
        then
            EchoVert "DATABASE" 
            Echo ${KEYCLOAK_SERVICE_NAME^^}
            docker-compose exec $MARIADB_SERVICE_NAME /nine/init.sh $KEYCLOAK_SERVICE_NAME
            Echo
        fi

        EchoVert "CONTAINER"
        upservice $KEYCLOAK_SERVICE_NAME
        Echo
    fi
}

function destroykeycloak {
    if [[ $KEYCLOAK_LOCAL == 1 ]]
    then    
        Title "DESTROY ${KEYCLOAK_SERVICE_NAME}"

        stop ${KEYCLOAK_SERVICE_NAME} 1
        docker-compose rm -s -v -f "${KEYCLOAK_SERVICE_NAME}"    

        if [[ -z $1 ]]; then 
            Question_ouinon "Souhaitez-vous supprimer la BDD associé à $KEYCLOAK_SERVICE_NAME ?";
            response=$?
        fi
        if [[ "$response" == 0 || ! -z $1 ]]
        then
            EchoRouge "Delete BDD = $KEYCLOAK_SERVICE_NAME"
            docker-compose exec $MARIADB_SERVICE_NAME /nine/delete.sh $KEYCLOAK_SERVICE_NAME
        fi

        echo ""
    fi
}