#!/bin/bash

function upnextcloud {
    if [[ $NEXTCLOUD_ACTIVATE == 1 && $NEXTCLOUD_LOCAL == 1 ]]
    then
        Title ${NEXTCLOUD_SERVICE_NAME^^}

        # CREATE BDD
        if [[ $MARIADB_ACTIVATE == 1 && $MARIADB_LOCAL == 1 ]]
        then
            EchoVert "DATABASE" 
            Echo ${NEXTCLOUD_SERVICE_NAME^^}
            docker-compose exec $MARIADB_SERVICE_NAME /nine/init.sh $NEXTCLOUD_SERVICE_NAME
            Echo
        fi

        EchoVert "CONTAINER"
        upservice ${NEXTCLOUD_SERVICE_NAME}
        Echo
    fi    
}

function destroynextcloud {
    if [[ $NEXTCLOUD_LOCAL == 1 ]]
    then    
        Title "DESTROY ${NEXTCLOUD_SERVICE_NAME}"

        stop ${NEXTCLOUD_SERVICE_NAME} 1
        docker-compose rm -s -v -f "${NEXTCLOUD_SERVICE_NAME}"    

        if [[ -z $1 ]]; then 
            Question_ouinon "Souhaitez-vous purger $NEXTCLOUD_SERVICE_NAME ?";
            response=$?
        fi
        if [[ "$response" == 0 || ! -z $1 ]]
        then
            EchoRouge "Purge = $NEXTCLOUD_SERVICE_NAME"
            docker-compose exec $MARIADB_SERVICE_NAME /nine/delete.sh $NEXTCLOUD_SERVICE_NAME
            rm -rf services/50-nextcloud/volume/data
            rm -rf services/50-nextcloud/volume/html
            rm -rf services/50-nextcloud/volume/app
        fi

        echo ""
    fi
}