#!/bin/bash

function upnineboard {
    if [[ $NINEBOARD_ACTIVATE == 1 && $NINEBOARD_LOCAL == 1 ]]
    then
        Title ${NINEBOARD_SERVICE_NAME^^}

        if [[ $MARIADB_ACTIVATE == 1 && $MARIADB_LOCAL == 1 ]]
        then
            EchoVert "DATABASE"
            Echo ${NINEBOARD_SERVICE_NAME^^}
            docker-compose exec $MARIADB_SERVICE_NAME /nine/init.sh $NINEBOARD_SERVICE_NAME
            Echo
        fi

        EchoVert "CONTAINER"
        upservice ${NINEBOARD_SERVICE_NAME}
        Echo
    fi    
}

function destroynineboard {
    if [[ $NINEBOARD_LOCAL == 1 ]]
    then    
        Title "DESTROY ${NINEBOARD_SERVICE_NAME}"

        stop ${NINEBOARD_SERVICE_NAME} 1
        docker-compose rm -s -v -f "${NINEBOARD_SERVICE_NAME}"    

        if [[ -z $1 ]]; then 
            Question_ouinon "Souhaitez-vous purger $NINEBOARD_SERVICE_NAME ?";
            response=$?
        fi
        if [[ "$response" == 0 || ! -z $1 ]]
        then
            EchoRouge "Purge = $NINEBOARD_SERVICE_NAME"
            docker-compose exec $MARIADB_SERVICE_NAME /nine/delete.sh $NINEBOARD_SERVICE_NAME
            rm -rf services/50-nineboard/volume/data
        fi

        echo ""
    fi
}