#!/bin/bash


function upninefolio {
    if [[ $NINEFOLIO_ACTIVATE == 1 && $NINEFOLIO_LOCAL == 1 ]]
    then
        Title ${NINEFOLIO_SERVICE_NAME^^}

        if [[ $MARIADB_ACTIVATE == 1 && $MARIADB_LOCAL == 1 ]]
        then
            EchoVert "DATABASE"
            Echo ${NINEFOLIO_SERVICE_NAME^^}
            docker-compose exec $MARIADB_SERVICE_NAME /nine/init.sh $NINEFOLIO_SERVICE_NAME
            Echo
        fi

        EchoVert "CONTAINER"
        upservice ${NINEFOLIO_SERVICE_NAME}
        chmod -R a+wr ./services/50-ninefolio/volume/data
        Echo
    fi    
}

function destroyninefolio {
    if [[ $NINEFOLIO_LOCAL == 1 ]]
    then
        Title "DESTROY $NINEFOLIO_SERVICE_NAME"

        stop $NINEFOLIO_SERVICE_NAME 1
        docker-compose rm -s -v -f "$NINEFOLIO_SERVICE_NAME"
        
        if [[ -z $1 ]]; then 
            Question_ouinon "Souhaitez-vous supprimer la BDD associé à $NINEFOLIO_SERVICE_NAME ?";
            response=$?
        fi
        if [[ "$response" == 0 || ! -z $1 ]]
        then
            EchoRouge "Delete BDD = $NINEFOLIO_SERVICE_NAME"
            docker-compose exec $MARIADB_SERVICE_NAME /nine/delete.sh $NINEFOLIO_SERVICE_NAME
            rm -rf services/50-ninefolio/volume/data
        fi

        echo ""
    fi   
}