<?php

namespace Cadoles\PortalBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Projecttaskstatus
 *
 * @ORM\Entity
 * @ORM\Table(name="projecttaskstatus")
 */
class Projecttaskstatus
{
    /**
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\Column(name="name", type="string", length=100)
     */
    private $name;

    /**
     * @ORM\OneToMany(targetEntity="Cadoles\PortalBundle\Entity\Projecttask", mappedBy="projecttaskstatus")
     * @ORM\JoinColumn(nullable=true, onDelete="SET NULL")
     */
    private $projecttasks;


    // A garder pour forcer l'id en init
    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }


    /**
     * Constructor
     */
    public function __construct()
    {
        $this->projecttasks = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set name
     *
     * @param string $name
     *
     * @return Projecttaskstatus
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * Get name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Add projecttask
     *
     * @param \Cadoles\PortalBundle\Entity\Projecttask $projecttask
     *
     * @return Projecttaskstatus
     */
    public function addProjecttask(\Cadoles\PortalBundle\Entity\Projecttask $projecttask)
    {
        $this->projecttasks[] = $projecttask;

        return $this;
    }

    /**
     * Remove projecttask
     *
     * @param \Cadoles\PortalBundle\Entity\Projecttask $projecttask
     */
    public function removeProjecttask(\Cadoles\PortalBundle\Entity\Projecttask $projecttask)
    {
        $this->projecttasks->removeElement($projecttask);
    }

    /**
     * Get projecttasks
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getProjecttasks()
    {
        return $this->projecttasks;
    }
}
