<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Doctrine\Persistence\ManagerRegistry;

class SondeController extends AbstractController
{
    public function sonde(Request $request, ManagerRegistry $em)
    {
        // Debug sonde
        $fgdebug = true;

        // Calcul du login
        $user=$this->getUser();
        if($user) $loginsonde=crypt($user->getUsername(),"dkywqZPYNHtWDnSxACjXVcIsFuaiQT");
        else $loginsonde="";

        // Calcul du profil
        $profilsonde="visiteur";
        if($user) {
            $profilsonde="utilisateur";
            $attributes=$request->getSession()->get('attributes');
            if(isset($attributes["ENTPersonProfils"])) $profilsonde=$attributes["ENTPersonProfils"];
        }

        // Calcul de la provenance
        $e = explode('.', $_SERVER["REMOTE_ADDR"]);
        $s = sizeof($e);
        if(($e[0]=="172"&&$e[1]=="30")||($e[0]=="172"&&$e[1]=="16")||($e[0]=="10"&&($e[1]=="77"||$e[1]=="93"||$e[1]=="94")))
            $provenancesonde='interne';
        else
            $provenancesonde='externe';      
            
        // Calcul du service associé à la page
        $request = $this->get('request_stack')->getMasterRequest();
        $usage=$request->query->get('usage');
        $route = $request->attributes->get('_route');

        if($route=="app_core_user_file_list"||$route=="app_core_home")
            $usagesonde="nosonde";
        elseif($route=="app_portal_user_page_view") {
            if($usage=="group") $usagesonde="collaboratif";
            elseif($usage=="user")  $usagesonde="collaboratif";
            elseif($usage=="accueil")  $usagesonde="accueil";
            else $usagesonde="portail";
        }
        elseif(stripos($route,"app_portal_user_calendar")!==false)
            $usagesonde="calendrier";
        elseif(stripos($route,"app_portal_user_project")!==false)
            $usagesonde="calendrier";
        elseif(stripos($route,"app_portal_user_blog")!==false)
            $usagesonde="collaboratif";
        elseif(stripos($route,"app_core_user_file")!==false)
            $usagesonde="fichier";
        else
            $usagesonde="portail";

        
        $urlsonde="";
        if($usagesonde!="nosonde") {
            $url=$this->getParameter("widsonde_url");
            $app=$this->getParameter("app_name");
            $urlsonde = $url."?appli=$app&profil=$profilsonde&login=$loginsonde&provenance=$provenancesonde&usage=$usagesonde&route=$route&fgdebug=$fgdebug";
        }

        return $this->render('Sonde\sonde.html.twig',['urlsonde' => $urlsonde]);
    }


}
