<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Form\FormError;
use Ramsey\Uuid\Uuid;
use Doctrine\Persistence\ManagerRegistry;

use App\Entity\Calendar;
use App\Form\CalendarType;
use App\Form\CalendarShareType;

class CalendarController extends AbstractController
{
    private $nameentity="Calendar";
    private $labelentity="App\Entity\Calendar";
    private $routeprimary="app_portal_config_calendar";

    public function list()
    {
        return $this->render($this->nameentity.'\list.html.twig',[
            'useheader'         => true,
            'usemenu'           => false,
            'usesidebar'        => true,              
        ]);
    }

    public function ajaxlist($access="config", Request $request, ManagerRegistry $em)
    {
        // S'assurer que c'est un appel ajax
        if (!$request->isXmlHttpRequest()) {
            return new JsonResponse(array('message' => 'Interdit'), 400);
        }
        
        $start=$request->query->get('start');
        $length= $request->query->get('length');
        $search= $request->query->get('search');
        $draw= $request->query->get('draw');
        $order= $request->query->get('order');
        $alluser= $request->query->get('alluser');

        // On sauvegarde en session le flag alluser
        $request->getSession()->set("aCadolesllusercalendar",$alluser);

        // Query de base
        $qbase=$em->getManager()->createQueryBuilder()->from($this->labelentity,'table');
        $qsearch=$em->getManager()->createQueryBuilder()->from($this->labelentity,'table');

        if($alluser=="false") {
            $qbase->where("table.user is null");
            $qsearch->where("table.user is null");
        }
        else {
            $qbase->from('CadolesCoreBundle:User','user')
                  ->where("table.user=user");

            $qsearch->from('CadolesCoreBundle:User','user')
                    ->where("table.user=user");
        }           

        if($alluser=="false") 
            $qsearch->andwhere('table.id LIKE :value OR table.name LIKE :value');
        else
            $qsearch->andWhere('table.id LIKE :value OR table.name LIKE :value OR user.username LIKE :value') ;  

        $qsearch->setParameter("value", "%".$search["value"]."%");

        // Nombre total d'enregistrement
        $total = $qbase->select('COUNT(table)')->getQuery()->getSingleScalarResult();

        // Nombre d'enregistrement filtré
        if($search["value"]=="")
            $totalf = $total;
        else {
            $totalf= $qsearch->select('COUNT(table)')->getQuery()->getSingleScalarResult();
        }

        // Parcours des Enregistrement
        if($search["value"]=="")
            $qb = $qbase->select('table');
        else
            $qb = $qsearch->select('table');

        // Order
        switch($order[0]["column"]) {
            case 1 : 
            $qb->orderBy('table.name',$order[0]["dir"]);
            break;
            case 2 : 
            if($alluser=="true") $qb->orderBy('user.username',$order[0]["dir"]);
            break;            
        }

        // Execution de la requete d'affichage
        $datas=$qb->setFirstResult($start)->setMaxResults($length)->getQuery()->getResult();

        // Construction du tableau de retour
        $output = array(
            'draw' => $draw,
            'recordsFiltered' => $totalf,
            'recordsTotal' => $total,
            'data' => array(),
        );

        foreach($datas as $data) {
            $route=str_replace("_config_","_".$access."_",$this->routeprimary);
            $action = "";
            $action.="<a href='".$this->generateUrl($route.'_update', array('id'=>$data->getId()))."' title='Configurer'><i class='fa fa-cog fa-fw fa-2x'></i></a>";
            $action.="<a href='".$this->generateUrl($route.'_view', array('id'=>$data->getId()))."' title='Afficher'><i class='fa fa-eye fa-fw fa-2x'></i></a>";
            $action.="<a href='".$this->generateUrl($route.'_delete', array('id'=>$data->getId()))."' data-method='delete' title='Supprimer'><i class='fa fa-trash fa-fw fa-2x'></i></a>";

            $user="";
            if($data->getUser()) {
                $user.="<img src='/".$this->container->getParameter('alias')."uploads/avatar/".$data->getUser()->getAvatar()."' class='avatar' style='margin:0px 5px 0px 0px;display:inline-block;'>";
                $user.=$data->getUser()->getUsername();
            }            

            array_push($output["data"],array($action,$data->getName(),$user));
        }

        // Retour
        return new Response(json_encode($output), 200);
    }  

    public function ajaxseleclist(Request $request, ManagerRegistry $em)
    {
        // S'assurer que c'est un appel ajax
        if (!$request->isXmlHttpRequest()) {
            return new JsonResponse(array('message' => 'Interdit'), 400);
        }

        $output=array();
        $page_limit=$request->query->get('page_limit');
        $q=$request->query->get('q');
        
        $qb = $em->getManager()->createQueryBuilder();
        $qb->select('table')->from("CadolesPortalBundle:Calendar",'table')
           ->where('table.name LIKE :value')
           ->setParameter("value", "%".$q."%")
           ->orderBy('table.name');
        
        $datas=$qb->setFirstResult(0)->setMaxResults($page_limit)->getQuery()->getResult();
        foreach($datas as $data) {
            array_push($output,array("id"=>$data->getId(),"text"=>$data->getName()));
        }

        $response = new Response(json_encode($output));    
        $response->headers->set('Content-Type', 'application/json');      
        return $response;
    } 

    private function entityForm($access="config", Calendar $entity, ManagerRegistry $em)
    {
        $route=str_replace("_config_","_".$access."_",$this->routeprimary);

        if ($em->getManager()->contains($entity)) {
            return $this->createForm(CalendarType::class, $entity, [
                "mode"   => "update",
                "access" => $access
            ]);
        }
        else {
            return $this->createForm(CalendarType::class, $entity, [
                "mode"   => "submit",
                "access" => $access
            ]);
        }
    }

    public function submit($access="config", Request $request, ManagerRegistry $em)
    {
        if($access=="user"&&!$request->getSession()->get('cancreatecalendar'))
            throw $this->createNotFoundException('Permission denied');

        $entity = new Calendar();

        $form   = $this->entityForm($access,$entity,$em);
        $form->handleRequest($request);

        // Sur erreur
        $this->getErrorForm(null,$form,$request,$entity,"submit");

        if ($form->get('submit')->isClicked() && $form->isValid()) {
            if($access=="user") $entity->setUser($this->getUser());

            $key = Uuid::uuid4();
            $entity->setKeyvalue($key);

            $em->getManager()->persist($entity);
            $em->getManager()->flush();

            return $this->redirect($this->generateUrl('app_portal_'.$access.'_calendar_view',["id"=>$entity->getId()]));          
        }

        return $this->render($this->nameentity.'\edit.html.twig', [
            'useheader'         => ($access=="config"),
            'usemenu'           => false,
            'usesidebar'        => ($access=="config"),   
            'maxwidth'          => ($access=="user"),           
            'entity'            => $entity,
            'mode'              => "submit",
            'access'            => $access,
            'form'              => $form->createView()
        ]);
    }

    public function update($id, $access="config", Request $request, ManagerRegistry $em)
    {
        $entity = $em->getRepository($this->labelentity)->find($id);
        if (!$entity) throw $this->createNotFoundException('Unable to find entity.');

        // On s'assure que l'utilisateur à la permission de modifier
        if($access=="user") {
            $em->getRepository($this->labelentity)->getPermission($this->getUser(),$entity,$cansee,$canupdate,$canadd);
            if(!$canupdate) throw $this->createNotFoundException('Permission denied');
        }            
        $oldpassword=$entity->getPasswordDecrypt();

        // Création du formulaire
        $form = $this->entityForm($access,$entity,$em);
        $form->handleRequest($request);

        // Sur erreur
        $this->getErrorForm(null,$form,$request,$entity,"update");

        if ($form->get('submit')->isClicked() && $form->isValid()) {
            $entity = $form->getData();

            // Si pas de changement de password on replace l'ancien
            if($entity->getPasswordDecrypt()=="") {
                $entity->setPassword($oldpassword);    
            }
            // Sinon on encode le nouveau
            else {
                $entity->setPasswordDirect($entity->getPassword());
            }

            $em->getManager()->flush();

            return $this->redirect($this->generateUrl('app_portal_'.$access.'_calendar_view',["id"=>$entity->getId()]));          
        }


        return $this->render($this->nameentity.'\edit.html.twig', [
            'useheader'         => ($access=="config"),
            'usemenu'           => false,
            'usesidebar'        => ($access=="config"),  
            'maxwidth'          => ($access=="user"),                  
            'entity'            => $entity,
            'access'            => $access,
            'mode'              => "update",
            'form'              => $form->createView(),
        ]);
    }

    public function share($id, $access="config", Request $request, ManagerRegistry $em)
    {
        $entity = $em->getRepository($this->labelentity)->find($id);
        if (!$entity) throw $this->createNotFoundException('Unable to find entity.');

        // On s'assure que l'utilisateur à la permission de modifier
        if($access=="user") {
            $em->getRepository($this->labelentity)->getPermission($this->getUser(),$entity,$cansee,$canupdate,$canadd);
            if(!$canupdate) throw $this->createNotFoundException('Permission denied');
        }            
        
        // Création du formulaire
        $form = $this->createForm(CalendarShareType::class, $entity, ["access" => $access, "user" => $this->getUser()]);
        $form->handleRequest($request);

        if ($form->get('submit')->isClicked() && $form->isValid()) {
            $em->getManager()->flush();

            return $this->redirect($this->generateUrl('app_portal_'.$access.'_calendar_view',["id"=>$id]));
        }


        return $this->render($this->nameentity.'\share.html.twig', [
            'useheader'         => ($access=="config"),
            'usemenu'           => false,
            'usesidebar'        => ($access=="config"),    
            'maxwidth'          => ($access=="user"),
            'entity'            => $entity,
            'access'            => $access,
            'form'              => $form->createView(),
        ]);
    }

    public function delete($id, $access="config", Request $request, ManagerRegistry $em)
    {
        $entity = $em->getRepository($this->labelentity)->find($id);
        if (!$entity) throw $this->createNotFoundException('Unable to find entity.');
    
        // On s'assure que l'utilisateur à la permission de supprimer
        if($access=="user") {
            $em->getRepository($this->labelentity)->getPermission($this->getUser(),$entity,$cansee,$canupdate,$canadd);
            if(!$canupdate) throw $this->createNotFoundException('Permission denied');
        }

        // Suppression
        $em->getManager()->remove($entity);
        $em->getManager()->flush();

        // Retour
        if($access=="config")
            return $this->redirect($this->generateUrl($this->routeprimary));
        else   
            return $this->redirect($this->generateUrl('app_portal_'.$access.'_calendar_view'));
    }

    public function view($access="config", Request $request, ManagerRegistry $em) {

        $id = $request->query->get('id');
        $entity=[];
        if($id!="") {
            $entity = $em->getRepository($this->labelentity)->find($id);
            if (!$entity) throw $this->createNotFoundException('Unable to find entity.');
        }

        // On recherche la premiere page associé au groupe du calendrier
        $idpage=null;
        $idgroup=null;
        if($id!=0) {
            $groups=$entity->getGroups();
            if($groups[0]) {
                if($groups[0]->getFgcanshare()) {
                    $pages=$groups[0]->getPages();
                    if($pages[0]) {
                        $idpage=$pages[0]->getId();
                        $groups=$pages[0]->getGroups();
                        $idgroup=$groups[0]->getId();
                    }                        
                }
            }
        }

        // Permissions
        if($access=="config") {
            $canupdate = true;
            $calendars=$em->getRepository($this->labelentity)->findBy(["id"=>$id]);
            $entity->setCanupdate(true);
        }
        else {
            // On récupère l'ensemble des calendriers de l'utilisateur
            $user=$this->getUser();
            $em->getRepository($this->labelentity)->getCalendarsUser($user,$calendarsuser,$calendarsadmin,$calendarsshared);
            

            // Utilisateur sans calendrier = creation d'un calendrier par défaut
            if(empty($calendarsuser)&&$user) {
                $calendar=new Calendar();
                $calendar->setName("Mon Calendrier");
                $calendar->setType(0);
                $calendar->setUser($user);
                $calendar->setCanupdate(true);
                $calendar->setCanadd(true);
                $key = Uuid::uuid4();
                $calendar->setKeyvalue($key);
                $em->getManager()->persist($calendar);
                $em->getManager()->flush();

                $calendarsuser=[$calendar];
            }

            $calendars=array_merge($calendarsuser,$calendarsadmin->toArray(),$calendarsshared);
            $canupdate=$request->getSession()->get('cancreatecalendar');
        }
        
        return $this->render($this->nameentity.'\view.html.twig', [
            'useheader'         => ($access=="config"),
            'usemenu'           => false,
            'usesidebar'        => ($access=="config"),    
            'maxwidth'          => ($access=="user"),
            'entity'            => $entity,
            'access'            => $access,
            'canupdate'         => $canupdate,
            'calendars'         => $calendars,
            'idpage'            => $idpage,
            'idgroup'           => $idgroup            

        ]);

    }

    protected function getErrorForm($id,$form,$request,$data,$mode) {
        if ($form->get('submit')->isClicked()&&$mode=="delete") {
        }

        if ($form->get('submit')->isClicked() && ($mode=="submit" || $mode=="update")) {
            // Si type de calendrier ICS alors url obligatoire
            if (is_null($data->getUrl()) && $data->getType()==1) {
                $form->addError(new FormError('URL obligatoire'));
            }
        }
     
        if ($form->get('submit')->isClicked() && !$form->isValid()) {
            $errors = $form->getErrors();
            foreach( $errors as $error ) {
                $request->getSession()->getFlashBag()->add("error", $error->getMessage());
            }
        }
    }    
}
