<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Cron
 *
 * @ORM\Table(name="cronexec")
 */
class Cronexec
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="command", type="string", nullable=false)
     * @Assert\NotBlank()
     *
     */
    private $command;

    /**
     * @ORM\Column(type="text", nullable=true)
     */
    private $jsonargument; 



    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set command
     *
     * @param string $command
     *
     * @return Cronexec
     */
    public function setCommand($command)
    {
        $this->command = $command;

        return $this;
    }

    /**
     * Get command
     *
     * @return string
     */
    public function getCommand()
    {
        return $this->command;
    }

    /**
     * Set jsonargument
     *
     * @param string $jsonargument
     *
     * @return Cronexec
     */
    public function setJsonargument($jsonargument)
    {
        $this->jsonargument = $jsonargument;

        return $this;
    }

    /**
     * Get jsonargument
     *
     * @return string
     */
    public function getJsonargument()
    {
        return $this->jsonargument;
    }
}
