<?php
namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;

use Symfony\Bridge\Doctrine\Validator\Constraints\UniqueEntity;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * @ORM\Entity
 * @ORM\Table(name="niveau02")
 * @ORM\HasLifecycleCallbacks()
 *
 * @UniqueEntity(fields="label", message="Un Niveau de rang 2 existe déjà avec ce label")
 */
class Niveau02
{
    /**
     * @ORM\Column(type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=250, unique=true)
     */
    private $label;

    /**
     * @ORM\Column(type="string", length=14, nullable=true)
     */
    private $siret;

    /**
     * @ORM\Column(type="text", nullable=true)
     */
    private $postaladress;
        
    /**
     * @ORM\ManyToOne(targetEntity="Niveau01", inversedBy="niveau02s")
     * @ORM\JoinColumn(nullable=false)
     */
    private $niveau01;
    
    /**
     * @var ArrayCollection $registrations
     * @var Registration
     *
     * @ORM\OneToMany(targetEntity="Registration", mappedBy="niveau02", cascade={"persist"}, orphanRemoval=false)
     */
    private $registrations;

     /**
     * @var ArrayCollection $users
     * @var User
     *
     * @ORM\OneToMany(targetEntity="User", mappedBy="niveau02", cascade={"persist"}, orphanRemoval=false)
     */
    private $users;
    /**
     * Constructor
     */
    public function __construct()
    {
        $this->registrations = new \Doctrine\Common\Collections\ArrayCollection();
        $this->users = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set label
     *
     * @param string $label
     *
     * @return Niveau02
     */
    public function setLabel($label)
    {
        $this->label = $label;

        return $this;
    }

    /**
     * Get label
     *
     * @return string
     */
    public function getLabel()
    {
        return $this->label;
    }

    /**
     * Set siret
     *
     * @param string $siret
     *
     * @return Niveau02
     */
    public function setSiret($siret)
    {
        $this->siret = $siret;

        return $this;
    }

    /**
     * Get siret
     *
     * @return string
     */
    public function getSiret()
    {
        return $this->siret;
    }

    /**
     * Set postaladress
     *
     * @param string $postaladress
     *
     * @return Niveau02
     */
    public function setPostaladress($postaladress)
    {
        $this->postaladress = $postaladress;

        return $this;
    }

    /**
     * Get postaladress
     *
     * @return string
     */
    public function getPostaladress()
    {
        return $this->postaladress;
    }

    /**
     * Set niveau01
     *
     * @param Niveau01 $niveau01
     *
     * @return Niveau02
     */
    public function setNiveau01(Niveau01 $niveau01)
    {
        $this->niveau01 = $niveau01;

        return $this;
    }

    /**
     * Get niveau01
     *
     * @return Niveau01
     */
    public function getNiveau01()
    {
        return $this->niveau01;
    }

    /**
     * Add registration
     *
     * @param Registration $registration
     *
     * @return Niveau02
     */
    public function addRegistration(Registration $registration)
    {
        $this->registrations[] = $registration;

        return $this;
    }

    /**
     * Remove registration
     *
     * @param Registration $registration
     */
    public function removeRegistration(Registration $registration)
    {
        $this->registrations->removeElement($registration);
    }

    /**
     * Get registrations
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getRegistrations()
    {
        return $this->registrations;
    }

    /**
     * Add user
     *
     * @param User $user
     *
     * @return Niveau02
     */
    public function addUser(User $user)
    {
        $this->users[] = $user;

        return $this;
    }

    /**
     * Remove user
     *
     * @param User $user
     */
    public function removeUser(User $user)
    {
        $this->users->removeElement($user);
    }

    /**
     * Get users
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getUsers()
    {
        return $this->users;
    }
}
