<?php
namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;

use Symfony\Bridge\Doctrine\Validator\Constraints\UniqueEntity;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * @ORM\Entity
 * @ORM\Table(name="permmodo")
 * @ORM\HasLifecycleCallbacks()
 *
  */
class PermModo
{
    /**
     * @ORM\Column(type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=50)
     */
    private $route;

    /**
     * @ORM\Column(name="visible", type="boolean")
     */
    private $visible;
  
    /**
     * @ORM\ManyToOne(targetEntity="PermModoProfil", inversedBy="permmodos")
     * @ORM\JoinColumn(nullable=true)
     */
    private $permmodoprofil;

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set route
     *
     * @param string $route
     *
     * @return PermModo
     */
    public function setRoute($route)
    {
        $this->route = $route;

        return $this;
    }

    /**
     * Get route
     *
     * @return string
     */
    public function getRoute()
    {
        return $this->route;
    }

    /**
     * Set visible
     *
     * @param boolean $visible
     *
     * @return PermModo
     */
    public function setVisible($visible)
    {
        $this->visible = $visible;

        return $this;
    }

    /**
     * Get visible
     *
     * @return boolean
     */
    public function getVisible()
    {
        return $this->visible;
    }


    /**
     * Set permmodoprofil
     *
     * @param PermModoProfil $permmodoprofil
     *
     * @return PermModo
     */
    public function setPermmodoprofil(PermModoProfil $permmodoprofil = null)
    {
        $this->permmodoprofil = $permmodoprofil;

        return $this;
    }

    /**
     * Get permmodoprofil
     *
     * @return PermModoProfil
     */
    public function getPermmodoprofil()
    {
        return $this->permmodoprofil;
    }
}
