<?php
namespace App\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\HttpFoundation\Session\Session;

use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Tetranz\Select2EntityBundle\Form\Type\Select2EntityType;
use FOS\CKEditorBundle\Form\Type\CKEditorType;

use Doctrine\ORM\EntityRepository;
use Doctrine\ORM\Query\Expr\Join;

class MailingType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $session = new Session();

        $builder->add('submit',
            SubmitType::class, array(
                "label"       => "Envoyer",
                "attr"        => array("class" => "btn btn-success")
            )
        );

        $perm=$options["perm"];
        $userid=$options["userid"];
        
        $builder
            ->add('niveau01',EntityType::class,[
                "mapped"       => false,
                "required"     => false,
                "class"        => "App\Entity\Niveau01",
                'multiple'     => true,
                "label"        => $session->get('labelsniveau01'),
                'placeholder'  => '== Choisir '.$session->get('labelsniveau01').' ==',
                "choice_label" => "label",
                "query_builder"=> function (EntityRepository $er) use($perm,$userid) { 
                    if($perm)
                        return $er->createQueryBuilder('niveau01');
                    else {
                        $result=$er->createQueryBuilder("table")->innerJoin("App\Entity\UserModo", "usermodo", Join::WITH, "table.id = usermodo.niveau01");
                        $result->andWhere("usermodo.user = :userid");
                        $result->setParameter('userid', $userid);
                        return $result;
                    }
                }
            ]); 
        
        if($perm) {
            $builder
                ->add('groups', Select2EntityType::class, [
                    'mapped'                => false,
                    'label'                 => 'Groupes',
                    'class'                 => 'App\Entity\Group',
                    'text_property'         => 'label',
                    'multiple'              => true,
                    'remote_route'          => 'app_core_ajax_group_list',
                    'primary_key'           => 'id',
                    'text_property'         => 'label',
                    'minimum_input_length'  => 0,
                    'page_limit'            => 100,
                    'allow_clear'           => true,
                    'delay'                 => 250,
                    'cache'                 => false,
                    'cache_timeout'         => 60000,
                    'language'              => 'fr',
                    'placeholder'           => 'Selectionner des groupes',                        
                ]);                  
        }

        $builder
            ->add('subject', TextType::class, [
                "label"       =>"Sujet",
                "mapped"      => false
            ]);

        $builder
            ->add("message",CKEditorType::class,[
                'config_name' => 'small_config',
                'label' => "Message",
                'mapped'=> false,
                'required' => true,
                'config' => ["height" => "400px"]
            ]);

    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'App\Entity\User',
            'perm' => "boolean",
            'userid' => "integer",
        ));
    }
}

