<?php
namespace Cadoles\CoreBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;

use Symfony\Bridge\Doctrine\Validator\Constraints\UniqueEntity;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * @ORM\Entity
 * @ORM\Table(name="usermodo")
 * @ORM\HasLifecycleCallbacks()
 *
 * @UniqueEntity(fields={"user", "service"}, message="Cette liaison existe déjà !")
 */
class UserModo
{
    /**
     * @ORM\Column(type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity="User", inversedBy="modos")
     * @ORM\JoinColumn(name="user_id", referencedColumnName="id", nullable=false)
     */
    private $user;

    /**
     * @ORM\ManyToOne(targetEntity="Niveau01", inversedBy="modos")
     * @ORM\JoinColumn(name="niveau01_id", referencedColumnName="id", nullable=false)
     */
    private $niveau01;
  
    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set user
     *
     * @param \Cadoles\CoreBundle\Entity\User $user
     *
     * @return UserModo
     */
    public function setUser(\Cadoles\CoreBundle\Entity\User $user)
    {
        $this->user = $user;

        return $this;
    }

    /**
     * Get user
     *
     * @return \Cadoles\CoreBundle\Entity\User
     */
    public function getUser()
    {
        return $this->user;
    }

    /**
     * Set niveau01
     *
     * @param \Cadoles\CoreBundle\Entity\Niveau01 $niveau01
     *
     * @return UserModo
     */
    public function setNiveau01(\Cadoles\CoreBundle\Entity\Niveau01 $niveau01)
    {
        $this->niveau01 = $niveau01;

        return $this;
    }

    /**
     * Get niveau01
     *
     * @return \Cadoles\CoreBundle\Entity\Niveau01
     */
    public function getNiveau01()
    {
        return $this->niveau01;
    }
}
