<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Filesystem\Filesystem;
use Symfony\Component\Finder\Finder;
use Symfony\Component\HttpFoundation\File\File;
use Doctrine\Persistence\ManagerRegistry;
use Symfony\Component\HttpKernel\KernelInterface;

use App\Service\MessageService;

use App\Entity\Calendarevent;
use App\Form\CalendareventShareType;

class CalendareventController extends AbstractController
{
    private $nameentity="Calendarevent";
    private $labelentity="App\Entity\Calendarevent";
    private $routeprimary="app_portal_config_calendarevent";

    private $appKernel;
    private $wss;
    
    public function __construct(KernelInterface $appKernel, messageService $wss)
    {
        $this->appKernel = $appKernel;
        $this->wss = $wss;
    }

    public function load($access="config", Request $request, ManagerRegistry $em)
    {       
        $events=array();
        $eventids=array();
        $idcalendar     = $request->query->get('idcalendar');
        $start          = $request->query->get('start');
        $end            = $request->query->get('end');


        // On charge un et un seul calendrier
        if($idcalendar>0) {
            $calendar = $em->getRepository("App\Entity\Calendar")->find($idcalendar);
            if (!$calendar) throw $this->createNotFoundException('Unable to find entity.');
            if($access=="config") {
                $calendar->setCanupdate(true);
                $calendar->setCanadd(true);
            }
            else {
                $em->getRepository("App\Entity\Calendar")->getPermission($this->getUser(),$calendar,$cansee,$canupdate,$canadd);
                if(!$cansee) throw $this->createNotFoundException('Permission denied');
                $calendar->setCanupdate($canupdate);
                $calendar->setCanadd($canadd);
            }

            $calendars=[$calendar];
        }
        // Sinon on charge l'ensemble des calendriers associé au profil
        else {
            $em->getRepository("App\Entity\Calendar")->getCalendarsUser($this->getUser(),$calendarssuser,$calendarsadmin,$calendarsshared);
            $calendars=array_merge($calendarssuser,$calendarsadmin->toArray(),$calendarsshared);
        }

        // On recherche des event partagés
        foreach($calendars as $calendar) {
            $calendarevents = $em->getRepository("App\Entity\Calendarevent")->getCalendareventByDate($calendar,$start,$end);

            foreach($calendarevents as $calendarevent) {
                $tmp=[];
                $tmp['id']            = strval($calendarevent->getId());
                $tmp['title']         = $calendarevent->getName();
                $tmp['description']   = $calendarevent->getDescription();
                $tmp['start']         = $calendarevent->getStart()->format("Y-m-d\TH:i:s");
                $tmp['end']           = $calendarevent->getEnd()->format("Y-m-d\TH:i:s");
                $tmp['color']         = "#".(is_null($calendar->getColor())?$request->getSession()->get('color')["main"]:$calendar->getColor());
                $tmp['allDay']        = $calendarevent->getAllday();
                $tmp['calendar']      = $calendar->getId();
                $tmp['editable']      = $calendarevent->getCalendar()->getCanadd();
                $tmp['files']         = $this->loadpjfile($tmp['id'] );

                array_push($events,$tmp);
                array_push($eventids,$tmp["id"]);
            }

            // On recherche les taches associées aux groupes du calendrier
            if($this->getUser()) {
                $groups=$calendar->getGroups();
                foreach($groups as $group) {
                    $projects=$group->getProjects();
                    foreach($projects as $project) {
                        $projecttasks = $em->getRepository("App\Entity\Projecttask")->getProjectTasksByDate($project,$this->getUser(),$start,$end);
                        foreach($projecttasks as $projecttask) {
                            $tmp=[];
                            $tmp['id']            = "TASK".strval($projecttask->getId());
                            $tmp['title']         = "TACHE = ".$projecttask->getName();
                            $tmp['description']   = $projecttask->getDescription();
                            $tmp['start']         = $projecttask->getEnd()->format("Y-m-d\TH:i:s");
                            $tmp['end']           = $projecttask->getEnd()->format("Y-m-d\TH:i:s");
                            $tmp['color']         = "#".$request->getSession()->get('color')["main"];
                            $tmp['allDay']        = true;
                            $tmp['calendar']      = $project->getId();
                            $tmp['name']          = $project->getName()." - Tache";
                            $tmp['editable']      = false;
                               
                            array_push($events,$tmp);
                            array_push($eventids,$tmp["id"]);
                        }
                    }
                }
            }
        }

        // On récupére les évenement partagé de l'utilisateur
        if($this->getUser()) {
            $calendarevents = $em->getRepository("App\Entity\Calendarevent")->getCalendareventGroupsShareByDate($this->getUser(),$start,$end);
            
            foreach($calendarevents as $calendarevent) {
                if($idcalendar>0) {
                    if(!$calendarevent->getGroups()->contains($calendar->getGroups()[0])) continue;
                }

                $tmp=[];
                $tmp['id']            = strval($calendarevent->getId());
                $tmp['title']         = $calendarevent->getName();
                $tmp['description']   = $calendarevent->getDescription();
                $tmp['start']         = $calendarevent->getStart()->format("Y-m-d\TH:i:s");
                $tmp['end']           = $calendarevent->getEnd()->format("Y-m-d\TH:i:s");
                $tmp['color']         = "#".(is_null($calendar->getColor())?$request->getSession()->get('color')["main"]:$calendar->getColor());
                $tmp['allDay']        = $calendarevent->getAllday();
                $tmp['calendar']      = $calendar->getId();
                $tmp['editable']      = $calendarevent->getCalendar()->getCanupdate();
                $tmp['files']         = $this->loadpjfile($tmp['id'] );

                if(!in_array($tmp['id'],$eventids)) {
                    array_push($events,$tmp);
                    array_push($eventids,$tmp["id"]);
                }
            }
        }

        $response = new Response(json_encode($events));    
        $response->headers->set('Content-Type', 'application/text');        
        return $response; 
    }

    public function submit($access="config", Request $request, ManagerRegistry $em)
    {
        // S'assurer que c'est un appel ajax
        if (!$request->isXmlHttpRequest()) return new JsonResponse(array('message' => 'Interdit'), 400);

        $output=array();
        $idcalendar     = $request->request->get('idcalendar');
        $title          = $request->request->get('title');
        $description    = $request->request->get('description');
        $start          = new \DateTime($request->request->get('start'));
        $end            = new \DateTime($request->request->get('end'));
        $allday         = ($request->request->get('allday')=="true");

        $calendar = $em->getRepository("App\Entity\Calendar")->find($idcalendar);
        if (!$calendar) throw $this->createNotFoundException('Unable to find entity.');

        // On s'assure que l'utilisateur à la permission de supprimer
        if($access=="user") {
            $em->getRepository("App\Entity\Calendar")->getPermission($this->getUser(),$calendar,$cansee,$canupdate,$canadd);
            if(!$canadd) throw $this->createNotFoundException('Permission denied');
        }        

        $calendarevent=new Calendarevent();
        $calendarevent->setCalendar($calendar);
        $calendarevent->setName($title);
        $calendarevent->setDescription($description);
        $calendarevent->setStart($start);
        $calendarevent->setEnd($end);
        $calendarevent->setAllday($allday);

        $em->getManager()->persist($calendarevent);
        $em->getManager()->flush();        

        foreach($calendarevent->getCalendar()->getGroups() as $group) {
            if($group->getFgcanshare()) {
                $message="Création évènement<br>".$calendarevent->getName()."<br>du ".$start->format("d/m/Y H:i")." au ".$end->sub(new \DateInterval('PT1M'))->format("d/m/Y H:i");
                $this->wss->addMessage($this->getUser()->getApikey(),$group->getId(),$message);
            }
        }

        $output["id"]=$calendarevent->getId();
        $output["color"]="#".(is_null($calendar->getColor())?$request->getSession()->get('color')["main"]:$calendar->getColor());

        $response = new Response(json_encode($output));    
        $response->headers->set('Content-Type', 'application/json');        
        return $response; 
    }

    public function update($access="config", Request $request, ManagerRegistry $em)
    {
        // S'assurer que c'est un appel ajax
        if (!$request->isXmlHttpRequest()) return new JsonResponse(array('message' => 'Interdit'), 400);

        $output=array();
        $id             = $request->request->get('id');
        $idcalendar     = $request->request->get('idcalendar');
        $title          = $request->request->get('title');
        $description    = $request->request->get('description');
        $start          = new \DateTime($request->request->get('start'));
        $end            = new \DateTime($request->request->get('end'));
        $allday         = ($request->request->get('allday')=="true");

        $calendar = $em->getRepository("App\Entity\Calendar")->find($idcalendar);
        if (!$calendar) throw $this->createNotFoundException('Unable to find entity.');

        // On s'assure que l'utilisateur à la permission
        if($access=="user") {
            $em->getRepository("App\Entity\Calendar")->getPermission($this->getUser(),$calendar,$cansee,$canupdate,$canadd);
            if(!$canadd) throw $this->createNotFoundException('Permission denied');
        }        

        $calendarevent = $em->getRepository("App\Entity\Calendarevent")->find($id);
        if (!$calendarevent) throw $this->createNotFoundException('Unable to find entity.');

        $calendarevent->setCalendar($calendar);
        $calendarevent->setName($title);
        $calendarevent->setDescription($description);
        $calendarevent->setStart($start);
        $calendarevent->setEnd($end);
        $calendarevent->setAllday($allday);

        $em->getManager()->flush();        

        foreach($calendarevent->getCalendar()->getGroups() as $group) {
            if($group->getFgcanshare()) {
                $message="Modification évènement<br>".$calendarevent->getName()."<br>du ".$start->format("d/m/Y H:i")." au ".$end->sub(new \DateInterval('PT1M'))->format("d/m/Y H:i");
                $this->wss->addMessage($this->getUser()->getApikey(),$group->getId(),$message);
            }
        }

        $output["id"]=$calendarevent->getId();
        $output["color"]="#".(is_null($calendar->getColor())?$request->getSession()->get('color')["main"]:$calendar->getColor());

        $response = new Response(json_encode($output));    
        $response->headers->set('Content-Type', 'application/json');        
        return $response; 
    }

    public function delete($access="config", Request $request, ManagerRegistry $em)
    {
        // S'assurer que c'est un appel ajax
        if (!$request->isXmlHttpRequest()) return new JsonResponse(array('message' => 'Interdit'), 400);

        $output=array();
        $id             = $request->request->get('id');
        $idcalendar     = $request->request->get('idcalendar');
        $title          = $request->request->get('title');
        $description    = $request->request->get('description');
        $start          = new \DateTime($request->request->get('start'));
        $end            = new \DateTime($request->request->get('end'));
        $allday         = ($request->request->get('allday')=="true");

        $calendar = $em->getRepository("App\Entity\Calendar")->find($idcalendar);
        if (!$calendar) throw $this->createNotFoundException('Unable to find entity.');

        // On s'assure que l'utilisateur à la permission
        if($access=="user") {
            $em->getRepository("App\Entity\Calendar")->getPermission($this->getUser(),$calendar,$cansee,$canupdate,$canadd);
            if(!$canadd) throw $this->createNotFoundException('Permission denied');
        }        

        $calendarevent = $em->getRepository("App\Entity\Calendarevent")->find($id);
        if (!$calendarevent) throw $this->createNotFoundException('Unable to find entity.');

        // Suppression
        $em->getManager()->remove($calendarevent);
        $em->getManager()->flush();

        $response = new Response(json_encode($output));    
        $response->headers->set('Content-Type', 'application/json');        
        return $response; 
    }

    public function share($id, $access="config", Request $request, ManagerRegistry $em)
    {
        $calendarevent = $em->getRepository($this->labelentity)->find($id);
        if (!$calendarevent) throw $this->createNotFoundException('Unable to find entity.');
        $calendar=$calendarevent->getCalendar();

        // On s'assure que l'utilisateur à la permission de modifier
        if($access=="user") {
            $em->getRepository("App\Entity\Calendar")->getPermission($this->getUser(),$calendar,$cansee,$canupdate,$canadd);
            if(!$canadd) throw $this->createNotFoundException('Permission denied');
        }            
        
        // Création du formulaire
        $form = $this->createForm(CalendareventShareType::class, $calendarevent, ["access" => $access, "user" => $this->getUser()]);
        $form->handleRequest($request);

        if ($form->get('submit')->isClicked() && $form->isValid()) {
            $em->getManager()->flush();

            return $this->redirect($this->generateUrl('app_portal_'.$access.'_calendar_view',["id"=>$calendar->getId()]));
        }


        return $this->render($this->nameentity.'\share.html.twig', [
            'useheader'         => ($access=="config"),
            'usemenu'           => false,
            'usesidebar'        => ($access=="config"),    
            'maxwidth'          => ($access=="user"),
            'entity'            => $calendarevent,
            'access'            => $access,
            'form'              => $form->createView(),
        ]);
    }

    public function loadpj($access="config", Request $request, ManagerRegistry $em) {
        $id = $request->request->get('id');
        
        $calendarevent = $em->getRepository($this->labelentity)->find($id);
        if (!$calendarevent) throw $this->createNotFoundException('Unable to find entity.');
        $calendar=$calendarevent->getCalendar();

        // On s'assure que l'utilisateur à la permission
        if($access=="user") {
            $em->getRepository("App\Entity\Calendar")->getPermission($this->getUser(),$calendar,$cansee,$canupdate,$canadd);
            if(!$canadd) throw $this->createNotFoundException('Permission denied');
        }  

        $files = $this->loadpjfile($id);

        $response = new Response(json_encode($files));    
        $response->headers->set('Content-Type', 'application/json');        
        return $response;         
    }


    private function loadpjfile($id) {
        $directory=$this->appKernel->getProjectDir()."/uploads/file/calendarevent-".$id;
        $files=[];
        $fs = new Filesystem();
        if($fs->exists($directory)) {
            $finder = new Finder();
            $finder->sortByName()->in($directory)->exclude('thumb')->exclude('thumbmini');
            foreach ($finder as $file) {
                $tmpfile=[];
                $tmpfile["name"]=$file->getRelativePathname();
                $tmpfile["extension"]=strtolower($file->getExtension());
                $fileinfo = new file($file->getPathname());
                $tmpfile["minetype"]=$fileinfo->getMimeType();
                $tmpfile["minefamily"]=explode("/",$tmpfile["minetype"])[0];

                $tmpfile["thumb"]="";
                if($tmpfile["extension"]=="pdf") {
                    $tmpfile["thumb"]="/".$this->getParameter('alias')."images/files/".$tmpfile["extension"].".png";
                }
                elseif($fs->exists($directory."/thumbmini/".$tmpfile["name"])) {
                    $data = file_get_contents($directory."/thumbmini/".$tmpfile["name"]);
                    $tmpfile["thumb"]="data:image/" . $tmpfile["extension"] . ";base64," . base64_encode($data);
                }
                elseif($fs->exists($directory."/thumb/".$tmpfile["name"])) {
                    $data = file_get_contents($directory."/thumb/".$tmpfile["name"]);
                    $tmpfile["thumb"]="data:image/" . $tmpfile["extension"] . ";base64," . base64_encode($data);
                }
                elseif($fs->exists($this->appKernel->getProjectDir()."/public/images/files/".$tmpfile["extension"].".png")) {
                    $tmpfile["thumb"]="/".$this->getParameter('alias')."images/files/".$tmpfile["extension"].".png";
                }

                array_push($files,$tmpfile);
            }                        
        }        

        return $files;
    }
}
