<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Filesystem\Filesystem;
use Symfony\Component\Form\FormError;
use Doctrine\Common\Collections\ArrayCollection;

use App\Entity\Message as Entity;
use App\Form\MessageType as Form;
use App\Form\ActivitymessageType as Activitymessage;
use App\Form\CorrectedType as Corrected;

class MessageController extends AbstractController
{
    private $data   = "message";
    private $route  = "app_message";
    private $render = "Message/";
    private $entity = "App:Message";

    public function message($id,Request $request)
    {
        $em = $this->getDoctrine()->getManager();

        // Création du formulaire
        $data=new Entity;
        $form = $this->createForm(Form::class,$data,array("mode"=>"submit"));

        // Récupération des data du formulaire
        $form->handleRequest($request);
    
        
        return $this->render('Message/message.html.twig',[
            'id'            => $id,
            'form'          => $form->createView()
        ]);
    }

    public function messagegroup($id, Request $request) {
        $em = $this->getDoctrine()->getManager();

        // Création du formulaire
        $activity=$em->getRepository("App:Activity")->find($id);
        if(!$activity) return $this->redirectToRoute("app_activity");

        // Formulaire
        $form = $this->createForm(Activitymessage::class,$activity,array("mode"=>"submit","id"=>$activity->getId()));

        // Récupération des data du formulaire
        $form->handleRequest($request);

        // Sur validation
        if ($form->get('submit')->isClicked() && $form->isValid()) {  
            $data = $form->getData();  
            $message = $form->get("message")->getData();

            if($message) {
                foreach($data->getAnswers() as $answer) {
                    $data=new Entity;
                    $data->setMessage($message);
                    $data->setUser($this->getUser());
                    $data->addReader($this->getUser());
                    $data->setDeletable(true);
                    $data->setAnswer($answer);

                    $em->persist($data);
                    $em->flush();
                }
            }

            // Fermeture de la popup
            return $this->render($this->render.'close.html.twig');
        }
    
        return $this->render('Message/group.html.twig',[
            'id'            => $id,
            'activity'      => $activity,
            'form'          => $form->createView()
        ]);
    }

    public function load($id,Request $request) {
        return new Response(json_encode($this->getMessages($id)));
    }

    public function submit($id,Request $request) {
        $em = $this->getDoctrine()->getManager();
        $answer=$em->getRepository("App:Answer")->find($id);
        if(!$answer) {
            $output=["return"=>"KO","error"=>"Utilisateur inconnu"];
            return new Response(json_encode($output));
        }
        // Controler que l'on peut créer mesage sur la answer

        // Récupérer les datas envoyés en post
        $html = $request->request->get('html');

        // Création du message
        $data = new Entity();
        $data->setUser($this->getUser());
        $data->setAnswer($answer);
        $data->setMessage($html);
        $data->setDeletable(true);
        $data->setInformation(false);
        $em->persist($data);
        $em->flush();        

        // Si on génère le message c'est qu'il est forcement lu
        $data->addReader($this->getUser());

        return new Response(json_encode($this->getMessages($id))); 
    }

    public function unread() {
        $em = $this->getDoctrine()->getManager();
        $user=$this->getUser();
        $output=[];

        // View master
        if ($user->hasRole('ROLE_ADMIN')||$user->hasRole('ROLE_MASTER')) {
            // Sur chaque activité de l'activité
            $activitys = $em->getRepository("App:Activity")->findBy(["user"=>$user]);
            foreach($activitys as $activity) {
                // Sur chaque réponse de l'activité
                $answers = $em->getRepository("App:Answer")->findBy(["activity"=>$activity]);
                foreach($answers as $answer) {
                    // Statut de la réponse
                    switch($answer->getStatus()) {
                        case -1: $status = "non vu"; break;
                        case 0:  $status = "vu"; break;
                        case 1:  $status = "en cours"; break;
                        case 2:  $status = "réouvert"; break;
                        case 10: $status = "rendu"; break;
                        case 15: $status = "corrigé"; break;
                    }
    
                    // Initialisation du tableau des messages non lus
                    $tmp = [
                        "id" => $answer->getId(),
                        "cpt" => 0,
                        "status" => $status
                    ];

                    // Sur chaque message de la réponse
                    $messages  = $em->getRepository("App:Message")->findBy(["answer"=>$answer]);
                    foreach($messages as $message) {
                        $readers=$message->getReaders();
                        if(!$readers->contains($user)) 
                            $tmp["cpt"]=$tmp["cpt"]+1;
                    }
                    array_push($output,$tmp);
                }
            }
        }
        // View user
        elseif($user->hasRole('ROLE_USER')) {
            $answers = $em->getRepository("App:Answer")->findBy(["user"=>$user]);
            foreach($answers as $answer) {
                // Statut de la réponse
                switch($answer->getStatus()) {
                    case -1: $status = "non vu"; break;
                    case 0:  $status = "vu"; break;
                    case 1:  $status = "en cours"; break;
                    case 2:  $status = "réouvert"; break;
                    case 10: $status = "rendu"; break;
                    case 15: $status = "corrigé"; break;
                }

                // Initialisation du tableau des messages non lus
                $tmp = [
                    "id" => $answer->getId(),
                    "cpt" => 0,
                    "status" => $status
                ];

                // Sur chaque message de la réponse
                $messages  = $em->getRepository("App:Message")->findBy(["answer"=>$answer]);
                foreach($messages as $message) {
                    $readers=$message->getReaders();
                    if(!$readers->contains($user)) 
                        $tmp["cpt"]=$tmp["cpt"]+1;
                }
                array_push($output,$tmp);
            }
        }

        return new Response(json_encode($output)); 
    }

    private function getMessages($id) {
        $em = $this->getDoctrine()->getManager();

        $datas=$em->getRepository($this->entity)->findBy(["answer"=>$id],["submitdate"=>"DESC"]);
        
        $return=[];
        foreach($datas as $data) {
            $user=$this->getUser();
            $isadmin=($user->Hasrole("ROLE_ADMIN"));
            $ismaster=($user==$data->getAnswer()->getActivity()->getUser());
            $isuser=($user==$data->getUser());
    
            //Si le message est supprimable : seul le propriétaire peut supprimer
            $deletable=$data->getDeletable();
            if($deletable) {
                if(!$isadmin&&!$ismaster&&!$isuser) $deletable=false;
            }
            else{
                // Un admin peut tout supprimer
                if($isadmin) $deletable=true;
            }

            // Si on liste le message c'est qu'il est lu
            $readers=$data->getReaders();
            if(!$readers->contains($user)) {
                $data->addReader($user);
                $em->persist($data);
                $em->flush();
            }

            $tmp = [
                "id" => $data->getId(),
                "message" => $data->getMessage(),
                "submitdate" => $data->getSubmitdate()->format("d/m/Y H:i"),
                "userdisplayname" => $data->getUser()->getDisplayname(),
                "deletable" => $deletable,
                "information" => $data->getInformation(),
            ];
            array_push($return,$tmp);
        }

        return $return;
    }

    public function delete($id) {
        $em = $this->getDoctrine()->getManager();
        $data=$em->getRepository($this->entity)->find($id);
        if(!$data) {
            $output=["return"=>"KO","error"=>"Message non retrouvé"];
            return new Response(json_encode($output));
        }

        $user=$this->getUser();
        $isadmin=($user->Hasrole("ROLE_ADMIN"));
        $ismaster=($user==$data->getAnswer()->getActivity()->getUser());
        $isuser=($user==$data->getUser());

        //Si le message est supprimable : seul le propriétaire peut supprimer
        $deletable=$data->getDeletable();
        if($deletable) {
            if(!$isadmin&&!$ismaster&&!$isuser) $deletable=false;
        }
        else{
            // Un admin peut tout supprimer
            if($isadmin) $deletable=true;
        }

        if(!$deletable) {
            $output=["return"=>"KO","error"=>"Message non supprimable"];
            return new Response(json_encode($output));
        }

        $em->remove($data);
        $em->flush();

        return new Response(json_encode([])); 
    }
}
