<?php
namespace App\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\Extension\Core\Type\RepeatedType;
use Symfony\Component\Form\Extension\Core\Type\PasswordType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\ButtonType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Tetranz\Select2EntityBundle\Form\Type\Select2EntityType;
use FOS\CKEditorBundle\Form\Type\CKEditorType;

use Symfony\Bridge\Doctrine\Form\Type\EntityType;


use Doctrine\ORM\EntityRepository;
use Doctrine\ORM\EntityManager;

class CorrectedType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder->add('submit',
            SubmitType::class, [
                "label" => "Valider",
                "attr" => ["class" => "btn btn-success"],
            ]
        );

        if($options["status"]>=10 && $options["status"]<15 && $options["activitystatus"]==1) {
            $builder->add('corrected',
            SubmitType::class, [
                "label" => "Rendre le corrigé",
                "attr" => [
                    "class" => "btn btn-success",
                    "data-method" => "submit",
                    "data-confirm" => "Confirmez vous ? Une fois corrigée, vous ne pourrez plus modifier l'activité."],
                ]
            );

            $builder->add('canceled',
            SubmitType::class, [
                "label" => "Permettre à l'élève de revoir sa copie",
                "attr" => [
                    "class" => "btn btn-danger",
                    "data-method" => "submit",
                    "data-confirm" => "Confirmez vous ? L'élève pourra modifier de nouveau son activité."],
                ]
            );
        }

        if($options["status"]>=10&&$options["status"]<15 && $options["activitystatus"]==1) {
            $builder->add('answercorrected',
                CKEditorType::class, [
                    "required" => false,
                    "config" => [
                        'uiColor' => '#ffffff',
                        'height' => 400,
                        'filebrowserUploadRoute' => 'app_ckeditor_upload',
                        'language' => 'fr',
                    ],
                ]
            );        
        }
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class'        => 'App\Entity\Answer',
            'mode'              => 'string',
            'status'            => 'integer',
            'activitystatus'    => 'integer'
        ));
    }
}
