<?php

namespace App\Entity;

use App\Repository\SurveyvoteRepository;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass=SurveyvoteRepository::class)
 */
class Surveyvote
{
    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\Surveyguest", inversedBy="surveyvotes")
     */
    private $surveyguest;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\Surveyoption", inversedBy="surveyvotes")
     */
    private $surveyoption;

    /**
     * @ORM\Column(name="vote", type="integer", nullable=true)
     */
    private $vote;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getVote(): ?int
    {
        return $this->vote;
    }

    public function setVote(?int $vote): self
    {
        $this->vote = $vote;

        return $this;
    }

    public function getSurveyguest(): ?Surveyguest
    {
        return $this->surveyguest;
    }

    public function setSurveyguest(?Surveyguest $surveyguest): self
    {
        $this->surveyguest = $surveyguest;

        return $this;
    }

    public function getSurveyoption(): ?Surveyoption
    {
        return $this->surveyoption;
    }

    public function setSurveyoption(?Surveyoption $surveyoption): self
    {
        $this->surveyoption = $surveyoption;

        return $this;
    }



}
