<?php

namespace App\Entity;

use App\Repository\VoteRepository;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass=App\Repository\QuestvoteRepository::class)
 */
class Questvote
{
    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\Questguest", inversedBy="questvotes")
     */
    private $questguest;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\Questoption", inversedBy="questvotes")
     */
    private $questoption;

    /**
     * @ORM\Column(name="vote", type="string", nullable=true)
     */
    private $vote;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getVote(): ?string
    {
        return $this->vote;
    }

    public function setVote(?string $vote): self
    {
        $this->vote = $vote;

        return $this;
    }

    public function getQuestguest(): ?Questguest
    {
        return $this->questguest;
    }

    public function setQuestguest(?Questguest $questguest): self
    {
        $this->questguest = $questguest;

        return $this;
    }

    public function getQuestoption(): ?Questoption
    {
        return $this->questoption;
    }

    public function setQuestoption(?Questoption $questoption): self
    {
        $this->questoption = $questoption;

        return $this;
    }

}
