<?php
/**
 * Gere les actions liées aux options
 */

class OptionsController extends Controller {

	/**
	 * Met à jour les options d'un sondgae.
	 * @return void 
	 */
	public function update( $token, $create = false, $add = false){
		//$this->autoRender = false;

		if (!$this->request->data) {
			$this->Session->setFlash("Veuillez saisir au moins une date.", "danger");
			return $this->redirect('/options/'.$token);
		}
		

		$this->loadModel('Sondage');
		$sondage = $this->Sondage->findFirst(array('conditions' => array('token' => $token)));

		if (empty($sondage)) {
			$this->error("404", 404, "Impossible de trouver ce sondage.");
		}

		$postData = $this->request->data;
		$error = false;
		
		if ($sondage->type == "D+"){
			// gestion des dates
			foreach ($postData->date as $k => $date) {
				if (!$this->Sondage->cleanHours( $date )) {
					$this->Session->setFlash("Veuillez vérifier le format de vos horaires.", "danger");
					$error = true;
				}
			}
		} else {
			// gestion des options "texte"
			foreach ($postData->text as $k => $sujet) {
				if (empty($sujet))
					unset($postData->text[$k]);
				else
					$postData->text[$k] = strip_tags($sujet);
			}
		}
			

		if (!$error) {
			// Suppression de tous les sujets du sondage déjà enregistré ainsi que les réponses associées
			// Et préparation à l'enregistrement des nouvelles valeurs
			if (!$add AND !$edit)
				$this->Sondage->query('DELETE FROM sujets WHERE sondage_id = "'.$token.'"', false);

			$values = array();
			if ($sondage->type == "D+") {
				foreach ($postData->date as $k => $sujet) {
					foreach ($sujet as $l => $hours) {
						foreach( $hours as $a => $v) {
							if (!empty($v)) {
								$s = $l.'@'.$v;
								$data = array('sondage_id' => $token, 'value' => $s);
								array_push($values, $data);
							}
						}
					}
				}
			} else {
				foreach ($postData->text as $k => $sujet) {
					array_push($values, $sujet);
				}
			}

			// Enregistrement des sujets
			$this->loadModel('Sujet');
			$this->Sujet->primaryKey = 'id';

			if ($sondage->type != "D+") {
				foreach ($values as $k => $val) {
					$data  = array(
						'sondage_id' => $sondage->token,
						'value' => $val
						);
					$this->Sujet->save($data);
				}
			} else {
				foreach ($values as $k => $val) {
					$data  = array(
						'sondage_id' => $sondage->token,
						'value' => $val
						);
					$this->Sujet->save($val);
				}
			}

			// Envoi des mails si activé
			if (isset($postData->sendEmail) AND $sondage->published == 1) {
				$this->loadModel('Destinataire');
				$dests = $this->Destinataire->find(array('conditions' => array('sondage_id' => $sondage->token)));
								
				if (!empty($dests)) {
					foreach ($dests as $k => $dest) {
						list(, $extension) = explode('@', $dest->mail);
						if ($extension == MAIL_TO_CAS) {
							$link_to_polls = HOST.URL.'/sondage/resp/'.$token.'/'.md5(MAIL_TO_CAS.$token);
						} else {
							$link_to_polls = HOST.URL.'/sondage/resp/'.$token;
						}

						// bundary
						$boundary = "-----=".md5(rand());

						// headers
						$headers  = 'MIME-Version: 1.0' . "\r\n";
						$headers .= 'Content-type: text/html; charset=utf8' . "\r\n";
						$headers .= 'From: '.Conf::$nameAppMail.' <'.NOREPLY_MAIL.'>' . "\r\n";

						// sujet
						$sujet = "[".Conf::$nameApp."] ".$sondage->titre;

						// Récupération du template pour l'envoi de mail
						ob_start();
						require ROOT . DS . 'view' . DS . 'mails' . DS . 'modification.php';
						$body = ob_get_clean();

						mail($dest->mail,$sujet, $body, $headers);
					}
				} else {
					$this->Session->setFlash("Aucun destinataire n'a été trouvé pour ce sondage.", 'error');
				}
			}

			$this->Session->setFlash("Mise à jour des options effectuée.", "success");

			if (!$create) {
				$_SESSION['active_pan'] = "options";
				return $this->redirect('/sondage/edit/' . $token);
			}
			elseif($create AND $add) 
				return $this->redirect('/options/' . $token);
			else
				return $this->redirect('/destinataires/' . $token);
		} else {
			$this->Session->setFlash("Une erreur a été détectée dans l'un de vos horaire. Veuillez corriger vos informations.", "danger");
			$_SESSION['active_pan'] = "options";
			if (!$create) {
				return $this->redirect('/sondage/edit/' . $token);
			}
			elseif($create OR $add)
				return $this->redirect('/options/'.$token);
			else
				return $this->redirect('/destinataires/' . $token);
		}
	}

	public function updateTexte( $token, $exist = false, $create = false, $add = false){
		$this->autoRender = false;

		if (!$this->request->data) {
			$this->error("400", 400, "Bad Request");
		}

		$this->loadModel('Sondage');
		$sondage = $this->Sondage->findFirst(array('conditions' => array('token' => $token)));

		if (empty($sondage)) {
			$this->error("404", 404, "Impossible de trouver ce sondage.");
		}

		$postData = $this->request->data;
		$error = false;
		
		if ($sondage->type == "D+"){
			// gestion des dates
			foreach ($postData->date as $k => $date) {
				if (!$this->Sondage->cleanHours( $date )) {
					$this->Session->setFlash("Veuillez vérifier le format de vos horaires.", "error");
					$error = true;
				}
			}
		} else {
			// gestion des options "texte"
			
			if (!$exist) {
				foreach ($postData->text as $k => $sujet) {
					if (empty($sujet))
						unset($postData->text[$k]);
					else
						$postData->text[$k] = strip_tags($sujet);
				}
			} else {
				foreach ($postData->text as $k => $sujet) {
					foreach($sujet as $l => $value) {
						if (empty($value[0]))
							unset($postData->text[$k]);
						else {
							$tmp[$k]['id'] = $l;
							$tmp[$k]['value'] = strip_tags($value[0]);
						}
					}
					$postData->text = $tmp;
				}
			}
			

		}
			

		if (!$error) {
			// Suppression de tous les sujets du sondage déjà enregistré ainsi que les réponses associées
			// Et préparation à l'enregistrement des nouvelles valeurs

			$values = array();
			if ($sondage->type == "D+") {
				foreach ($postData->date as $k => $sujet) {
					foreach ($sujet as $l => $hours) {
						foreach( $hours as $a => $v) {
							if (!empty($v)) {
								$s = $l.'@'.$v;
								$data = array('sondage_id' => $token, 'value' => $s);
								array_push($values, $data);
							}
						}
					}
				}
			} else {
				foreach ($postData->text as $k => $sujet) {
					array_push($values, $sujet);
				}

			}

			// Enregistrement des sujets
			$this->loadModel('Sujet');
			$this->Sujet->primaryKey = 'id';

			if($exist != "update") {
				foreach ($values as $k => $val) {
					$data  = array(
						'sondage_id' => $sondage->token,
						'value' => $val
						);
					$this->Sujet->save($data);
				}
			} else {
				foreach ($values as $k => $val) {
					$this->Sujet->delete($val['id']);
					$data  = array(
						'sondage_id' => $sondage->token,
						'value' => $val['value']
						);
					$this->Sujet->save($data);
				}
			}

			// Envoi des mails si activé
			if (isset($postData->sendEmail) AND $sondage->published == 1) {
				$this->loadModel('Destinataire');
				$dests = $this->Destinataire->find(array('conditions' => array('sondage_id' => $sondage->token)));
								
				if (!empty($dests)) {
					foreach ($dests as $k => $dest) {
						list(, $extension) = explode('@', $dest->mail);
						if ($extension == MAIL_TO_CAS) {
							$link_to_polls = HOST.URL.'/sondage/resp/'.$token.'/'.md5(MAIL_TO_CAS.$token);
						} else {
							$link_to_polls = HOST.URL.'/sondage/resp/'.$token;
						}

						// bundary
						$boundary = "-----=".md5(rand());

						// headers
						$headers  = 'MIME-Version: 1.0' . "\r\n";
						$headers .= 'Content-type: text/html; charset=utf8' . "\r\n";
						$headers .= 'From: '.Conf::$nameApp.' <'.NOREPLY_MAIL.'>' . "\r\n";

						// sujet
						$sujet = "[".Conf::$nameApp."] ".$sondage->titre;

						// Récupération du template pour l'envoi de mail
						ob_start();
						require ROOT . DS . 'view' . DS . 'mails' . DS . 'modification.php';
						$body = ob_get_clean();

						mail($dest->mail,$sujet, $body, $headers);
					}
				} else {
					$this->Session->setFlash("Aucun destinataire n'a été trouvé pour ce sondage.", 'error');
				}
			}

			$this->Session->setFlash("Mise à jour des options effectuée.", "success");
		}

		if (!$create) {
			$_SESSION['active_pan'] = "options";
			return $this->redirect('/sondage/edit/' . $token);
		}
		else
			return $this->redirect('/destinataires/' . $token);
	}


	public function delete( $sondage_id, $option_id, $create = false ) {
		$this->autoRender = false;

		$this->loadModel('Sondage');

		$this->Sondage->query('DELETE FROM sujets WHERE sondage_id = "'.$sondage_id.'" AND id = ' . $option_id, false);
		$this->Sondage->query('DELETE FROM reponses WHERE sondage_id = "'.$sondage_id.'" AND value = ' . $option_id, false);

		if (!$create) {
			$_SESSION['active_pan'] = "options";
			return $this->redirect('/sondage/edit/' . $sondage_id);
		}
		else
			return $this->redirect('/options/' . $sondage_id);
	}
}