<?php
/**
* Dispatcher
* Permet de charger le controller en fonction de la requête utilisateur
**/
class Dispatcher{
	
	public $request;	// Object Reques

	/**
	* Fonction principale du dispatcher
	* Charge le controller en fonction du routing
	**/
	function __construct(){
		$uri  = isset($_SERVER['PATH_INFO']) ? $_SERVER['PATH_INFO'] : '/';
		$this->request = new Request($uri); 
		Router::parse($this->request->url,$this->request); 
		
		$controller = $this->loadController();
		$action = $this->request->action;

		if (array_key_exists(ucfirst($this->request->controller), Conf::$CAS_actions)) {
			if (in_array($this->request->action, Conf::$CAS_actions[ucfirst($this->request->controller)])) {
				require_once ROOT. DS . 'lib' . DS . 'CAS' . DS . 'auth.inc.php';
		   	cas_auth();
		    $user = array();
				if (isset($_SESSION['phpCAS']['attributes']['utilisateur']['email'][0])) {
					$user['email'] = $_SESSION['phpCAS']['attributes']['utilisateur']['email'][0];
				}
				if (isset($_SESSION['phpCAS']['attributes']['utilisateur']['fullname'][0])) {
					$user['fullname'] = $_SESSION['phpCAS']['attributes']['utilisateur']['fullname'][0];
				}
				if (empty($user['email']) OR empty($user['fullname'])) {
					if (Conf::$debug)
						$controller->authorized = false;
					else
						$controller->authorized = false;
				}

				$controller->Session->write('User', $user);
			}
		} else {
			$user = array();
			if (isset($_SESSION['phpCAS']['attributes']['utilisateur']['email'][0])) {
				$user['email'] = $_SESSION['phpCAS']['attributes']['utilisateur']['email'][0];
			}
			if (isset($_SESSION['phpCAS']['attributes']['utilisateur']['fullname'][0])) {
				$user['fullname'] = $_SESSION['phpCAS']['attributes']['utilisateur']['fullname'][0];
			}
			$controller->Session->write('User', $user);
		}
		
		if($this->request->prefix){
			$action = $this->request->prefix.'_'.$action;
		}
		if(!in_array($action , array_diff(get_class_methods($controller),get_class_methods('Controller'))) ){
			if( Conf::$debug )
				$this->error('missing_action', 'Le controller &laquo;<b>'.$this->request->controller.'</b> n\'a pas d\'action &laquo;<b>'.$action.'</b>&raquo;');
			else
				$controller->e404();
		}
		call_user_func_array(array($controller,$action),$this->request->params); 

		if( $this->request->isAjax() )
			$controller->layout = "ajax";

		if ( $controller->autoRender ) {
			$controller->render($action);
		}
	}

	/**
	* Permet de générer une page d'erreur en cas de problème au niveau du routing (page inexistante)
	* @param  string $view Vue à charger
	* @param  string $message Message à afficher.
	* 
	**/
	function error($view, $message){
		$controller = new Controller($this->request);
		$controller->layout = "error";
		
		if( Conf::$debug ) {
			$controller->error($view, $message);
		} else {
			$controller->e404();
		}
		
	}

	/**
	* Permet de charger le controller en fonction de la requête utilisateur
	**/
	function loadController(){
		$name = ucfirst($this->request->controller).'Controller'; 
		$file = ROOT.DS.'controller'.DS.$name.'.php';
		if(!file_exists($file)){
			$this->error('missing_controller', 'Le controller &laquo;<b>'.$this->request->controller.'</b>&raquo; n\'existe pas'); 
		} 
		require $file; 
		$controller = new $name($this->request); 
		return $controller;  
	}


}
