<?php
/**
 * Page d'édition des destinataires
 */
?>

<div class="row">
	<div class="col-md-8">
		<div class="panel panel-default">
			<div class="panel-heading">
				<h3 class="panel-title"><i class="fa fa-plus fa-fw"></i> Ajouter de nouveaux invités</h3>
			</div>
			<div class="panel-body">
				<?php if (!$s_sondage['sondages']->public) : ?>
					<?php require ELEMENT . '/sondage/form_add_dest.php'; ?>
				<?php else : ?>
					<?php require ELEMENT . '/sondage/message_type.php'; ?>
				<?php endif; ?>
			</div>
		</div>
	</div>
	<div class="col-md-4">
		<?php if (isset($create) AND $create) : ?>
			<a href="<?= URL . '/sondage/publication/'.$s_sondage['sondages']->token; ?>" class="btn btn-success btn-block">
				<i class="fa fa-check fa-fw"></i> Publier le sondage
			</a>
			<hr>
			<div class="alert alert-info">
				Votre sondage est disponible pendant 60 jours.
			</div>
			<hr>
			<div class="panel panel-info">
				<div class="panel-heading">
					<h3 class="panel-title"><i class="fa fa-users fa-fw"></i> Les invités</h3>
				</div>
				<?php if (!$s_sondage['sondages']->public) : ?>
				<table class="table">
				<?php if (!empty($s_sondage['sondages']->dests)) : ?>
					<?php foreach ($s_sondage['sondages']->dests as $k => $dest) : ?>
						<tr>
							<td>
								<?= ($dest->answered) ? '<i class="fa fa-check text-success fa-fw"></i>': '<i class="fa fa-clock-o text-warning fa-fw"></i>'; ?>
								<?= $dest->mail; ?>
								<?php if (isset($create) AND $create) : ?>
									<a href="<?= URL . '/users/delete/'.$dest->id.'/'.$dest->sondage_id.'/create'; ?>" class="btn btn-danger btn-xs pull-right"><i class="fa fa-times"></i></a>
								<?php else : ?>
									<a href="<?= URL . '/users/delete/'.$dest->id.'/'.$dest->sondage_id; ?>" class="btn btn-danger btn-xs pull-right"><i class="fa fa-times"></i></a>
								<?php endif; ?>
							</td>
						</tr>
					<?php endforeach; ?>
				<?php else : ?>
					<tr>
						<td class="text-muted">Aucun invité enregistré.</td>
					</tr>
				<?php endif; ?>
				</table>
				<?php else : ?>
					<div class="panel-body">
						<span class="text-info">Ce sondage est public.</span>
					</div>
				<?php endif; ?>
			</div>
			<?php if (!$s_sondage['sondages']->public) : ?>

			<?php else : ?>
				<div class="alert alert-warning">
					Pensez à envoyer le mail d'invitation à vos contacts.
				</div>
			<?php endif; ?>
		<?php else : ?>
			<?php if ($s_sondage['sondages']->published) : ?>
				<div class="alert alert-info">
					Un mail d'invitation sera envoyé à chaque nouvel invité.
				</div>
			<?php endif; ?>
			<div class="panel panel-info">
				<div class="panel-heading">
					<h3 class="panel-title"><i class="fa fa-users fa-fw"></i> Les invités</h3>
				</div>
				<?php if (!$s_sondage['sondages']->public) : ?>
				<table class="table">
				<?php foreach ($s_sondage['sondages']->dests as $k => $dest) : ?>
					<tr>
						<td>
							<?= ($dest->answered) ? '<i class="fa fa-check text-success fa-fw"></i>': '<i class="fa fa-clock-o text-warning fa-fw"></i>'; ?>
							<?= $dest->mail; ?>
							<a href="<?= URL . '/users/delete/'.$dest->id.'/'.$dest->sondage_id; ?>" class="btn btn-danger btn-xs pull-right"><i class="fa fa-times"></i></a>
						</td>
					</tr>
				<?php endforeach; ?>
				</table>
				<?php else : ?>
					<div class="panel-body">
						<span class="text-info">Ce sondage est public.</span>
					</div>
				<?php endif; ?>
			</div>
		<?php endif; ?>
	</div>
</div>

	
