<?php $this->Session->flash(); ?>
<?php
	// calcul de la meilleur reponse
	$res = array();

	if (!empty($reponses)) {
		foreach ($reponses as $k=>$v) {
			if ($v->resp) {
				if (!isset($res[$v->sujet]))
					$res[$v->sujet] = 1;
				else
					$res[$v->sujet] += 1;
			}
		}
	arsort($res); 
	}

	// Récupération des réponses de l'utilisateur, si elles existent
	if ($this->Session->read('reponse')) {
		if (array_key_exists($sondage->token, $this->Session->read('reponse'))) {
			$reponse = array();
			foreach ($this->Session->read('reponse') as $token => $obj) {
				foreach ($obj as $time => $v)
					array_push($reponse, $time);
			}
		}
	}
?>

<?php if ($sondage->published == 1) : ?>
	<form action="" method="post" class="mb2">
		<?php echo $this->Session->flash(); ?>
		<?php if (!empty($resps)) : ?>
			<ul class="list-group">
			<?php foreach ($sujets as $k=>$sujet) : ?>
				<li class="list-group-item <?php echo ($resps[$k]->resp) ? 'list-group-item-success' : 'list-group-item-danger'; ?>">
					<strong><?php echo '#'.($k+1) .' - ' . $sujet->value; ?></strong><br />
					<?php if (empty($resps) OR !isset($resps[$k])) : ?>
						<input type="hidden" name="<?php echo $sujet->id; ?>" value="0" <?php echo (isset($resps[$k]->resp) AND $resps[$k]->resp == 0) ? 'checked' : ''; ?> />
						<input type="checkbox" name="<?php echo $sujet->id; ?>"  value="0" />
					<?php else : ?>
						<input type="hidden" name="<?php echo $sujet->id; ?>" value="0" <?php echo (isset($resps[$k]->resp) AND $resps[$k]->resp == 0) ? 'checked' : ''; ?> />
						<input type="checkbox" name="<?php echo $sujet->id; ?>" value="1" <?php echo (isset($resps[$k]->resp) AND $resps[$k]->resp == 1) ? 'checked' : ''; ?> />
					<?php endif; ?>
				</li>
			<?php endforeach; ?>
		<?php else : ?>
			<ul class="list-group">
			<?php foreach ($sujets as $k=>$sujet) : ?>
					<li class="list-group-item">
						<strong><?php echo $sujet->value; ?></strong><br />
						<?php if (empty($resps)) : ?>
						<input type="hidden" name="<?php echo $sujet->id; ?>" value="0" <?php echo (isset($resps[$k]->resp) AND $resps[$k]->resp == 0) ? 'checked' : ''; ?> />
						<input type="checkbox" name="<?php echo $sujet->id; ?>"  value="1" />
						<?php else : ?>
							<input type="hidden" name="<?php echo $sujet->id; ?>" value="0" <?php echo (isset($resps[$k]->resp) AND $resps[$k]->resp == 0) ? 'checked' : ''; ?> />
						<input type="checkbox" name="<?php echo $sujet->id; ?>" value="1" <?php echo (isset($resps[$k]->resp) AND $resps[$k]->resp == 1) ? 'checked' : ''; ?> />
						<?php endif; ?>
					</li>
			<?php endforeach; ?>
		<?php endif; ?>
			<li class="list-group-item">
				<input type="submit" value="Enregistrer mes réponses" class="btn btn-success">
			</li>
		</ul>
	</form>
<?php endif; ?>

<div class="table-responsive">
<table class="table table-bordered">
	<thead>
		<tr>
			<th rowspan="2" class="w20">Invités</th>
			<th colspan="<?= count($sujets); ?>">Réponses</th>
		</tr>
		<tr>
			<?php foreach ($sujets as $k => $sujet) : ?>
				<th class="excerptRep">
					<span><?php echo '#'.($k+1) .' - '.str_replace('_', ' ', substr($sujet->value, 0,20)); ?> <?php echo (strlen($sujet->value)>20) ? ' ...' : ''; ?></span>
				</th>
			<?php endforeach; ?>
		</tr>
	</thead>
	<tbody>
	<?php if($sondage->mail_admin == $user['email']) : ?>
		<?php foreach( $respByAuthors as $k => $v) : ?>
			<tr>
			<td><?= $k; ?></td>
			<?php foreach ($v as $l=>$resp) : ?>
				<td class="<?= ($resp['resp']) ? 'success' : 'danger'; ?>">
					<i class="fa fa-<?= ($resp['resp']) ? 'check' : 'times'; ?> <?= ($resp['resp']) ? 'text-success' : 'text-danger'; ?>"></i>
				</td>
			<?php endforeach; ?>
			</tr>
		<?php endforeach; ?>
	<?php else : ?>
		<?php foreach( $respByAuthors as $k => $v) : ?>
			<tr>
			<td><?= $k; ?></td>
			<?php foreach ($v as $l=>$resp) : ?>
				<td class="<?= ($resp['resp']) ? 'success' : 'danger'; ?>">
					<i class="fa fa-<?= ($resp['resp']) ? 'check' : 'times'; ?> <?= ($resp['resp']) ? 'text-success' : 'text-danger'; ?>"></i>
				</td>
			<?php endforeach; ?>
			</tr>
		<?php endforeach; ?>
			<?php if (!empty($resps)) : ?>
			<tr>
				<td>Vous</td>
				<?php foreach ($sujets as $k => $sujet) : ?>
					<td class="excerptRep <?= ($resps[$k]->resp) ? 'success' : 'danger'; ?> text-center">
						<i class="fa fa-<?= ($resps[$k]->resp) ? 'check' : 'times'; ?> <?= ($resps[$k]->resp) ? 'text-success' : 'text-danger'; ?>"></i>
					</td>
				<?php endforeach; ?>
			</tr>
			<?php foreach( $respByAuthors as $k => $v) : ?>
				<tr>
				<td><?= $k; ?></td>
				<?php foreach ($v as $l=>$resp) : ?>
					<td class="<?= ($resp['resp']) ? 'success' : 'danger'; ?>">
						<i class="fa fa-<?= ($resp['resp']) ? 'check' : 'times'; ?> <?= ($resp['resp']) ? 'text-success' : 'text-danger'; ?>"></i>
					</td>
				<?php endforeach; ?>
				</tr>
			<?php endforeach; ?>
			<?php else : ?>
			<td class="text-muted">
				aucune réponse
			</td>
			<?php endif; ?>
	<?php endif; ?>
		
	</tbody>
</table>
</div>
<hr />
<div class="row">
	<div class="col-md-6">
		<div class="panel panel-info">
			<div class="panel-heading">
				<h3 class="panel-title"><i class="fa fa-trophy"></i> Résultat(s)</h3>
			</div>
				<?php if (empty($res)) : ?>
				<div class="text-muted">Aucune réponse enregistrée.</div>
				<?php else : ?>
					<?php 
						$data = array_shift(array_keys($res));
						$max = $res[$data];
						$resultats = array();
						
						$i = 0;
						foreach ($res as $k=>$v) : 
							if ($i < 3) :
								$tmp['sujet'] = $k;
								$tmp['nb'] = $v;
								array_push($resultats, $tmp);
							endif;
							$i++;
						endforeach;
					?>
					<table class="table">
						<thead>
							<tr>
								<th>#</th>
								<th>Intitulés</th>
								<th>Vote(s)</th>
							</tr>
						</thead>
						<tbody>
					<?php foreach ($resultats as $k=>$v) : ?>
						<tr>
								<td class="text-muted"><?php echo $k+1; ?></td>
								<td><?php echo $v['sujet']; ?></td>
								<td><?php echo $v['nb']; ?></td>						 
						</tr>
					<?php endforeach; ?>
						</tbody>
					</table>
				<?php endif; ?>
		</div>
	</div>
	<?php if ($isAuthor) : ?>
		<div class="col-md-6">
			<div class="panel panel-default">
				<div class="panel-heading">
					<h3 class="panel-title"><i class="fa fa-info"></i> État</h3>
				</div>
					<?php if ($sondage->public) : ?>
						<div class="panel-body">
							<span class="text-info">Ce sondage est public</span>
						</div>
					<?php else : ?>
						<ul class="list-group">
							<?php foreach($dests as $k => $dest) : ?>
								<li class="list-group-item">
									<?php if ($dest->answered) : ?>
										<i class="fa fa-check text-success fa-fw"></i>
									<?php else : ?>
										<i class="fa fa-clock-o text-warning fa-fw"></i>
									<?php endif; ?>
									<?= $dest->mail; ?>
									<?php if ($dest->answered) : ?>
										<span class="text-muted">(<?= date('d.m.Y', strtotime($dest->date_answered)); ?>)</span>
									<?php endif; ?>
								</li>
							<?php endforeach; ?>
							</ul>
					<?php endif; ?>
			</div>
		</div>
	<?php endif; ?>
</div>
