
<div class="row">
	<div class="col-md-12 col-sm-12 col-xs-12">
		<?php echo $this->Session->flash(); ?>
	</div>
</div>
<?php if(empty($user['email'])) : ?>
	<div class="alert alert-info">
		Afin de pouvoir créer un sondage, vous devez renseigner une adresse email pour votre compte. <br/> 
		Veuillez contacter votre administrateur.
	</div>
<?php else : ?>

<?php if (empty($sondages)) : ?>
	<div class="row">
		<div class="col-md-12">
			<div class="alert alert-info">
				Vous n'avez aucun sondage en cours.
			</div>
			<div class="line">
				<div class="mod left w33">
					<a class="btn btn-primary" href="<?php echo URL; ?>/create">Créer un nouveau sondage</a>
				</div>
			</div>
			<hr>
		</div>
	</div>
	
<?php else : ?>
	<div class="row">
		<div class="col-md-6 col-sm-12 col-xs-12">
			<div class="panel panel-primary">
				<div class="panel-heading">
					<h3 class="panel-title"><i class="fa fa-check fa-fw"></i> Mes sondages publiés</h3>
				</div>
				<ul class="list-group">
					<?php $empty = true; foreach ($sondages as $k => $sondage) : ?>
						<?php if ($sondage->published) : ?>
						<li class="list-group-item">
							
							<a href="<?= URL . '/sondages/view/' . $sondage->token; ?>" title=""><?php echo $sondage->titre; ?></a> 
							<span class="text-muted">
								(Termine le <?php echo date('d/m/Y', strtotime($sondage->date_end)); ?>)
							</span>
							<?php if ($sondage->published == -1) : ?>
								<span class="label label-warning pull-right">Clôturé</span>
							<?php else : ?>
								<span class="label label-success pull-right">Ouvert</span>
							<?php endif; ?>
							<ul class="list-inline">
							  <li><i class="fa fa-bell"></i> <?php echo ($sondage->notif_mail) ? 'Activées' : 'Désactivées' ; ?></li>
							  <li>
							  	<a href="<?php echo URL; ?>/sondage/edit/<?php echo $sondage->token; ?>" class="text-info"><span class="fa fa-cog"></span> Editer</a>
							  </li>
							  <li class="pull-right">
							  	<a href="<?php echo URL; ?>/delete/<?php echo $sondage->token; ?>" class="text-danger"><span class="fa fa-trash-o"></span> Supprimer</a>
							  </li>
							</ul>
						</li>
						<?php $empty = false; endif; ?>
					<?php endforeach; ?>
					<?php if ($empty) : ?>
						<li class="list-group-item text-muted">
							Aucun sondage publié
						</li>
					<?php endif; ?>
				</ul>
			</div>
		</div>
		<div class="col-md-6 col-sm-12 col-xs-12">
			<div class="panel panel-default">
				<div class="panel-heading">
					<h3 class="panel-title"><i class="fa fa-clock-o fa-fw"></i> Mes sondages en attentes</h3>
				</div>
				<ul class="list-group">
					<?php $empty = true; foreach ($sondages as $k => $sondage) : ?>
						<?php if (!$sondage->published) : ?>
						<li class="list-group-item">
							<?php echo $sondage->titre; ?>
							<span class="text-muted">
								(Termine le <?php echo date('d/m/Y', strtotime($sondage->date_end)); ?>)
							</span><br />
							
							<ul class="list-inline">
							  <li>
							  	<a href="<?php echo URL; ?>/sondage/publication/<?php echo $sondage->token; ?>" class="text-success"><span class="fa fa-check"></span> Publier</a>
							  </li>
							  <li>
							  	<a href="<?php echo URL; ?>/sondage/edit/<?php echo $sondage->token; ?>" class="text-info"><span class="fa fa-cog"></span> Editer</a>
							  </li>
							  <li class="pull-right">
							  	<a href="<?php echo URL; ?>/delete/<?php echo $sondage->token; ?>" class="text-danger"><span class="fa fa-trash-o"></span> Supprimer</a>
							  </li>
							</ul>
						</li>
						<?php $empty = false; endif; ?>
					<?php endforeach; ?>
					<?php if ($empty) : ?>
						<li class="list-group-item text-muted">
							Aucun sondage publié
						</li>
					<?php endif; ?>
				</ul>
			</div>
		</div>
	</div>	
<?php endif; ?>
<div class="row">
	<div class="col-md-12">
		<?php if (empty($participes)) : ?>
			<div class="alert alert-info">
				Vous ne participez à aucun sondage.
			</div>
		<?php else : ?>	
			<div class="panel panel-info">
				<div class="panel-heading">
					<h3 class="panel-title"><i class="fa fa-check-square fa-fw"></i>Participations</h3>
				</div>
				<ul class="list-group">
				<?php foreach ($participes as $k => $sondage) : ?>
					<?php if ($sondage->published == 1) : ?>
					<li class="list-group-item">
						<a href="<?php echo URL; ?>/sondage/resp/<?php echo $sondage->token; ?>" title="Accéder à <?php echo $sondage->titre; ?>"><?php echo $sondage->titre; ?></a>
						<span class="text-muted">(Termine le <?php echo date('d/m/Y', strtotime($sondage->date_end)); ?>)</span><br />
						<ul class="list-inline">
							<?php echo ($sondage->answered) ? '<span class="text-success"><i class="fa fa-check"></i> Répondu le '.date('d/m/Y', strtotime($sondage->date_answered)).'</span>' : '<span class="text-danger"><i class="fa fa-frown-o"></i> Vous n\'avez pas répondu</span>' ; ?>
						</ul>
					</li>
					<?php endif; ?>
				<?php endforeach; ?>	
				</ul>
			</div>
		<?php endif; ?>
	</div>
</div>
<?php endif; ?>
	</div>
</div>
