$( document ).ready( function() {

	// Détermine si la page est appelée depuis une iframe
	var isInIframe = (window.location != window.parent.location) ? true : false;

	if ($('.manageOptions').length) {
		var $groupsInputs = $('.manageOptions').parent().find('input');

		if ($groupsInputs.length == 0)
			$('.manageOptions').hide();
	}


	var $monthsList = $('.list-months');
	var $yearsList 	= $('.list-year');
	var $date      	= $('td.day');

	var _curYear  = $('.list-years').find(':selected').val();
	var _curMonth = $('.list-months').find(':selected').val();


	if (isInIframe) {
		$('#header').hide();
	}

	$('.table-month').hide();
	$('#year-' + _curYear + '-month-' + ((_curMonth < 10) ? '0' : '') + _curMonth).show();

	// Changement de calendrier en fonction de l'année et mois sélectionné
	//
	$('.list-years, .list-months').on('change', function() {
		$('#year-' + _curYear + '-month-' + ((_curMonth < 10) ? '0' : '') + _curMonth).slideUp('fast', function() {
			_curYear  = $('.list-years').find(':selected').val();
			_curMonth = $('.list-months').find(':selected').val();
			$('#year-' + _curYear + '-month-' + ((_curMonth < 10) ? '0' : '') + _curMonth).slideDown();
		});
	});

	// Enregistrement de la sélection d'un jour
	// AJAX
	//
	$date.on('click', function() {

		var _target = $(this).attr('data-target');
		var _action = _target.split('/');
		var entry = _action.length;

		if ($(this).hasClass('selected')) {
			$(this).removeClass('selected');
			$(this).children('input[type="hidden"]').val('0');

			$.post(_target, {}, function(data) {

				if (data.error) {
					alert(data.msg);
				} else {
					if (data.template != undefined) {
						$('.manageOptions').show();
						$('#hours').children('#container').append(data.template);
					}
					if (data.timestamp != undefined) {
						if ($('.manageOptions').length) {
							var $groupsInputs = $('.manageOptions').parent().find('input');

							if ($groupsInputs.length == 0)
								$('.manageOptions').hide();
						}
						$('#time'+data.timestamp).remove();
					}
				}
			}, 'json');
			if (_action[entry-1] == "edit") {
				_action[entry-2] = "add";
			} else {
				_action[entry-1] = "add";
			}
			$(this).attr('data-target', _action.join('/'));

		} else {
			$(this).addClass('selected');
			$(this).children('input[type="hidden"]').val('1');

			$.post(_target, {}, function(data) {
				if (data.error) {
					alert(data.msg);
				} else {

					if (data.template != undefined) {
						$('.manageOptions').show();
						$('#hours').children('#container').append(data.template);
					}
					if (data.timestamp != undefined) {
						if ($('.manageOptions').length) {
							var $groupsInputs = $('.manageOptions').parent().find('input');

							if ($groupsInputs.length == 0)
								$('.manageOptions').hide();
						}
						$('#time'+data.timestamp).remove();
					}

				}
			}, 'json');

			if (_action[entry-1] == "edit") {
				_action[entry-2] = "remove";
			} else {
				_action[entry-1] = "remove";
			}

			$(this).attr('data-target', _action.join('/'));
		}
	});

	// Champs texte d'ajout de destinataires
	//
	var $group_fields_dest = $('#dest-list').find('div.form-group.lim');
	var pointer = 12;
	$group_fields_dest.hide();

	$group_fields_dest.slice(0,pointer).show().end();

	$('#addDest').on('click', function() {
		pointer += 5;
		$group_fields_dest.slice(0,pointer).show().end();
		if (pointer == 100)
			$(this).hide();

		return false;
	});
	// Champs options text sondage type texte
	//
	var $group_fields = $('#inputTextChoice').find('div.form-group');
	var pointer = 5;
	$group_fields.hide();

	$group_fields.slice(0,pointer).show().end();

	$('#addFieldsText').on('click', function() {
		pointer += 5;
		$group_fields.slice(0,pointer).show().end();
		if (pointer == 100)
			$(this).hide();

		return false;
	});

	// UI choix
	//
	var $checkbox = $('.check-choice');
	$checkbox.each(function() {
		if ($(this).prop('checked'))
			$(this).parent().parent().parent().parent().addClass('active');
	})

	$('.check-choice').on('click', function() {
		if ($(this).prop('checked'))
			$(this).parent().parent().parent().parent().addClass('active');
		else
			$(this).parent().parent().parent().parent().removeClass('active');
	});

	// Popups
	//
	var overlay = "<div id='overlay'></div>";

	$('.btnpopup').on('click', function() {
		var _target = $(this).attr('data-target');

		$('body').append(overlay);

		$('#overlay').show('fast', function() {
			$('#' + _target).show();
		});

		$('#overlay, .close').on('click', function() {
			$('#' + _target).hide('fast', function() {
				$('#overlay').hide();
			});
		});

		return false;
	});

	// Report horaire
	//
	$(document).on('click', '.reportHours', function() {
		var $link = $(this);
		var $refHoraire = $('.optionTime:first').find('input');
		var $groupInputs = $('.optionTime:not(:first)').find('input');
		var $tabRef = [];

		if ($refHoraire.length) {
			$refHoraire.each( function(i) {
				$tabRef.push($(this).val());
			});

			$groupInputs.each( function(el) {

				var index = el % 6;



				$groupInputs[el].value = $tabRef[index];
			})

		}

		return false;
	});

	// Report horaire
	//
	$(document).on('click', '.cleanAllHours', function() {
		var $link = $(this);
		var $groupInputs = $('.optionTime').find('input');

		$groupInputs.each(function(i) {
			$(this).val('');
		});

		return false;
	});

	$(document).on('keyup', '.hoursOptions', function() {
		var target = "/opensondage/check-horaire";
		var $el = $(this);
		var value = $el.val();

		$.post(target, {format: value}, function(res) {
			if (res.error) {
				if ($el.parent().hasClass('has-success'))
					$el.parent().removeClass('has-success');

				$el.parent().addClass('has-error');
			} else {
				if ($el.parent().hasClass('has-error'))
					$el.parent().removeClass('has-error');

				$el.parent().addClass('has-success')
			}
			if (!$el.val().length){
				$el.parent().removeClass('has-error');
			}
		}, 'json');
	});

	$(document).on('change', '.hoursOptions', function() {
		var target = "/opensondage/check-horaire";
		var $el = $(this);
		var value = $el.val();

		$.post(target, {format: value}, function(res) {
			if (res.error) {
				if ($el.parent().hasClass('has-success'))
					$el.parent().removeClass('has-success');

				$el.parent().addClass('has-error');
			} else {
				if ($el.parent().hasClass('has-error'))
					$el.parent().removeClass('has-error');

				$el.parent().addClass('has-success')
			}
			if (!$el.val().length){
				$el.parent().removeClass('has-error');
			}
		}, 'json');
	});

	$(document).on('focusin', '.hoursOptions', function() {
		var target = "/opensondage/check-horaire";
		var $el = $(this);
		var value = $el.val();

		$.post(target, {format: value}, function(res) {
			if (res.error) {
				if ($el.parent().hasClass('has-success'))
					$el.parent().removeClass('has-success');

				$el.parent().addClass('has-error');
			} else {
				if ($el.parent().hasClass('has-error'))
					$el.parent().removeClass('has-error');

				$el.parent().addClass('has-success')
			}
			if (!$el.val().length){
				$el.parent().removeClass('has-error');
			}
		}, 'json');
	});
	$(document).on('focusout', '.hoursOptions', function() {
		var target = "/opensondage/check-horaire";
		var $el = $(this);
		var value = $el.val();

		$.post(target, {format: value}, function(res) {
			if (res.error) {
				if ($el.parent().hasClass('has-success'))
					$el.parent().removeClass('has-success');

				$el.parent().addClass('has-error');
			} else {
				if ($el.parent().hasClass('has-error'))
					$el.parent().removeClass('has-error');

				$el.parent().addClass('has-success')
			}
			if (!$el.val().length){
				$el.parent().removeClass('has-error');
			}
		}, 'json');
	});

	$(document).on('submit', '#formDate', function(e) {

		var $form = $(this);
		var inputs = $(this).find('input[type="text"]');
		console.log(inputs);
		inputs.each(function(){
			if ($(this).parent().hasClass('has-error')){
				console.log('erreur');
				alert( $(this).val() + " n'est pas un format de date autorisé. Veuillez corriger cet horaire afin de continuer l'édition de votre sondage.");
				e.preventDefault();
			}
		});
	});

	/**
	 * Checkboxes
	 */
	 $(':checkbox').iphoneStyle();

	/**
	 * autocompletion destinataire
	 */
	$('.autocompleteDest').autocomplete({
    source: "/opensondage/destinataires/autocomplete",
    minLength: 3,
    type : 'post',
    select: function( event, ui ) {
        console.log( ui.item ?
          "Selected: " + ui.item.value + " aka " + ui.item.id :
          "Nothing selected, input was " + this.value );
      }
  });
});
