<?php
/**
 * This is core configuration file.
 *
 * Use it to configure Heimdall.
 *
 */



class Conf {

	/**
	 * Heimdall debug level
	 * 	Production mode:
	 * 		0: No error message
	 * 	Developement mode:
	 * 		1: All error message without debug backtrace
	 * 		2: All error message with debug backtrace
	 * @var integer
	 */
	static $debug = 0;

	/**
	 * Nom de l'application - Nom affiché dans les vues
	 * @var string
	 */
	static $nameApp = "OpenSondage";

	static $nameAppSlug = "opensondage";

	/**
	 * Défini l'adresse hôte de l'application
	 */
	static $web_url = "%%web_url";

	/**
	 * Nom de domaine mail qui doit être cassifié
	 * lorsqu'un utilisateur veut répondre à un sondage.
	 * @var string
	 */
	%if %%is_defined('domaine_messagerie_etab')
	static $mail_to_CAS = array("%%domaine_messagerie_etab", "i-%%domaine_messagerie_etab"); 	
	%else
	static $mail_to_CAS = "";
	%end if

	/**
	 * Nom du theme couleur à utiliser pour l'application
	 * Le fichier CSS de theme doit respecter la syntaxe suivante:
	 * 		nom_du_theme.theme.css
	 * Par exemple ici: envole.theme.css
	 * @var string
	 */
	static $CSStheme = "envole";

	/**
	 * Version de l'application
	 * @var string
	 */
	static $version = "1.0";

	/**
	 * Défini la limite du nombre de destinataire
	 * possible pour un sondage
	 * @var integer
	 */
	static $limDestinataire = 100;

	/**
	 * Défini la limite d'options possible pour les sondages de type "autre"
	 * @var integer
	 */
	static $limTexte = 100;

	/**
	 * Active ou non la librairie CAS
	 * @var integer
	 */
	static $CAS_enable = 1;

	/**
	 * Permet de choisir quelles actions d'un controller doit etre cassifiée
	 * @var array
	 */
	static $CAS_actions = array(
		'Sondages' => array(
			'index',
			'create',
			'options',
			'saveDate',
			'updateOptions',
			'update',
			'publication'
			),
		'Options' => array(
			'update',
			'delete',
			'updateTexte'
			),
		'Destinataires' => array(
			'update',
			'delete',
			'import'
			)
		);

static $dbpwd="monpassword";
	/**
	 * Databases configuration
	 * @var array
	 */
	static $databases = array(
		'default' => array(
			'host'		=> '%%adresse_ip_mysql',
			'database'	=> 'opensondage',
			'login'		=> 'opensondage',
			//prefix  	=> '',
			//encode 	=> 'utf8'
		)
	);

}
?>
