<?php 
/**
* Controller
**/
class Controller {
	
	public $modelName = "";
/**
 * Request object
 * @var Mixed FALSE ou Request
 */
	public $request = false;  

/**
 * Variables to push into view
 * @var array
 */
	private $vars = array();

/**
 * Default action layout
 * @var string
 */
	public $layout = 'default'; 

/**
 * View rendered
 * @var boolean
 */
	private $rendered = false;

/**
 * Auto render view
 * @var boolean
 */
	public $autoRender = true;

	public $authorized = true;

	protected $mapErrors = array(
		"403" => "HTTP/1.0 403 Forbidden"
		);

/**
* Constructeur
* @param $request Objet request de notre application
**/
	function __construct( $request = false ){
		$this->Session 	= new Session(); 
		$this->Form 	= new Form($this); 

		if($request){
			$this->request = $request; 	// On stock la request dans l'instance	
			require '../config/hook.php'; 			
		}

		$this->loadModel($this->modelName);
	}

/**
* Permet de rendre une vue
* @param $view Fichier à rendre (chemin depuis view ou nom de la vue) 
**/
	public function render($view){
		if($this->rendered){ return false; }
		
		extract($this->vars); 
		
		if(strpos($view,'/')===0){
			$view = ROOT.DS.'view'.$view.'.php';
		}else{
			$view = ROOT.DS.'view'.DS.$this->request->controller.DS.$view.'.php';
		}

		ob_start(); 
		require($view);
		$content_for_layout = ob_get_clean();  
		
		require ROOT.DS.'view'.DS.'layout'.DS.$this->layout.'.php'; 
		
		$this->rendered = true; 
	}


	/**
	* Permet de passer une ou plusieurs variable à la vue
	* @param $key nom de la variable OU tableau de variables
	* @param $value Valeur de la variable
	**/
	public function set($key,$value=null){
		if(is_array($key)){
			$this->vars += $key; 
		}else{
			$this->vars[$key] = $value; 
		}
	}

	/**
	* Permet de charger un model
	* @param  string $name Nom du model à charger
	**/
	function loadModel($name){
		if(!isset($this->$name)){
			$file = ROOT.DS.'model'.DS.$name.'.php'; 
			if (file_exists($file)) {
				require_once($file);
				$this->$name = new $name();
				if(isset($this->Form)){
					$this->$name->Form = $this->Form;  
				}
			} else {
				return false;
			}
		}
	}

	/**
	* Permet de charger une librairie
	* @param  string $name Nom du model à charger
	**/
	function loadLib($name, $location = ''){
		if(!isset($this->$name)){
			$file = ROOT.DS.'lib'.DS.$location.$name.'.php'; 
			if (file_exists($file)) {
				require_once($file);
			} else {
				die($file.' not found');
			}
		}
	}

	/**
	* Permet de gérer les erreurs 404
	* @param  string $message Message a afficher
	**/
	function e404($message = null){	
		header("HTTP/1.0 404 Not Found");
		$this->set('message',$message); 
		$this->render('/errors/404');
		die();
	}

	/**
	* Permet de gérer les erreurs
	* @param string $view Nom de la vue à afficher
	* @param  string $message Message a afficher
	**/
	function error($view, $code, $message = null){	
		header($this->mapErrors[$code]);
		$this->set('message',$message); 
		$this->render('/errors/'.$view);
		die();
	}


	/**
	* Permet d'appeller un controller depuis une vue
	* @param  string $controller Nom du controller (sans 'Controller')
	* @param  string $action Nom de l'action a executer
	**/
	function request($controller,$action){
		$controller .= 'Controller';
		
		if( !is_file(ROOT.DS.'controller'.DS.$controller.'.php') )
			$this->error('missing_controller', 'Le controller &laquo;<b>'.$controller.'</b>&raquo; n\'existe pas');

		require_once ROOT.DS.'controller'.DS.$controller.'.php';
		$c = new $controller();

		if(!in_array($action , array_diff(get_class_methods($controller),get_class_methods('Controller'))) ){
			if( Conf::$debug )
				$this->error('missing_action', 'Le controller &laquo;<b>'.$this->request->controller.'</b> n\'a pas d\'action &laquo;<b>'.$action.'</b>&raquo;');
			else
				$controller->e404();
		}

		return $c->$action(); 
	}


	/**
	* Redirect
	* @param string $url URL cible
	* @param  string $code Code de la redirection
	**/
	function redirect($url,$code = null ){
		if($code == 301){
			header("HTTP/1.1 301 Moved Permanently");
		}
		header("Location: ".Router::url($url)); 
	}


}
?>