<?php

class OC_Calendar_Envole{
	// Hook a ajouter dans /apps/calendar/index.php
	public static function calendarCDT($none) {
		// Vérifier que ce calendrier l'existance d'un calendrier CdT
		$stmt = OCP\DB::prepare( 'SELECT * FROM `*PREFIX*clndr_calendars` WHERE `userid` = ? AND `displayname`=?' );
		$result = $stmt->execute(array(OCP\User::getUser(),"CdT"));
		if($row=$result->fetchRow()) {
			$idcalcdt=$row["id"];
		}

		// Si aucun calendrier CdT : on en génère un
		if($idcalcdt=="") {
			$idcalcdt=OC_Calendar_Calendar::addCalendar(OCP\User::getUser(),"CdT","VEVENT,VTODO,VJOURNAL",null,0,"#333333");
			$calendars = OC_Calendar_Calendar::allCalendars(OCP\USER::getUser(), true);
		}
		return true;
	}
	
	// Hook a ajouter dans /apps/calendar/lib/app.php
	public static function synchroCDT($id) {
		// Vérifier que ce calendrier est celui de CdT
		$stmt = OCP\DB::prepare( 'SELECT * FROM `*PREFIX*clndr_calendars` WHERE `userid` = ? AND `displayname`=?' );
		$result = $stmt->execute(array(OCP\User::getUser(),"CdT"));
		if($row=$result->fetchRow()) {
			$idcalcdt=$row["id"];
		}
		
		// Si on est sur un calendrier et que ce calendrier correspond à celui de CdT on lance la génération des évènements CdT
		if($id==$idcalcdt) {
			$cdt_plugin = new readCDT();
			$cdt_plugin->cdt_events($id,OCP\User::getUser(),date("Ymd"),3);
		}
		return true;
	}
}


class readCDT {
	// Mode débug
	private $debug = false;
	
	// Si élève non reconnu, on cherche un emploi du temps "prof"
	private $profil_eleve = "National_1";

	// Login en cours
	private $login ="";
	
	// Chemin d'accès au cahier de textes
	private $path = '/var/www/html/cdt/';

	// Fichier de connexion MySQL
	private $file_connexion = '/var/www/html/cdt/Connections/conn_cahier_de_texte.php';

	// Libellé des jours
	private $jours = array(0=>"Dimanche",1=>"Lundi",2=>"Mardi",3=>"Mercredi",4=>"Jeudi",5=>"Vendredi",6=>"Samedi");

	// Connexion MySQL
	private $link = false;

	// Témoin que la lecture du cahier de textes est possible
	public $is_ok = false;

	// Identifiant utilisé pour les popups
	private $popup_id = 0;

	// Les périodes de vacances du cahier de textes =pour ne rien afficher si jour de vacances */
	private $vacances = array();

	// Les semaines A/B du cahier de textes
	private $alternances = array();

	// Les plages horaires du cahier de textes
	private $horaires = array();

	// Format de date jj/mm/aaaa pour l'accès à une séance précise dans le cdt
	private $consult_date = "";

	// Format de date Ymd pour la recherche d'évènements
	private $date = "";

	// Quel type de vue ? classe ou prof ?
	private $view = "";

	// Valeur à rechercher= Nom de la classe ou login du prof selon $view
	private $valeur = "";

	// Identifiant à considérer = Id de la classe ou id du prof selon $view
	private	$id_cdt = 0;

	// Complément de requête = Liste des regroupements concernés, utilisée si vue "classe"
	private $gics_list = "";

	// Nombre de cours récupérés
	private $total_cours = 0;

	// Format de la vue WebCalendar à afficher = day(1)/week(2)/month(3)
	private $format = 0;

	// Périodes de vacances à afficher dans le bilan
	private $displayVacances = array();
	
	// Calendrier owncloud
	private $idcalendrier = 0;

	// Constructeur
	public function __construct() {
		$this->is_ok = $this->mysqlConnexion(); //connexion MySQL
		$this->search_vacances(); //périodes de vacances
		$this->search_plages_horaires(); //plages horaires des cours
	}


	// Traitements à faire en fin d'exécution ou arrêt du script
	public function __destruct() {
		@mysql_close($this->link);
	}


	// Connexion et sélection de la base de données 
	// @return boolean true si connexion réussie
	public function mysqlConnexion() {
		//connexion mysql
		if(!is_file($this->file_connexion)) return false;
		@include($this->file_connexion);
		$this->link = $conn_cahier_de_texte;	
		if(!@mysql_select_db($database_conn_cahier_de_texte,$this->link)) return false;
		else return true;
	}


	// Recherche de la classe associée au login
	public function search_classe() {
		//$userBE = new \OCA\user_ldap\USER_LDAP();
		$ldap_host=\OCP\Config::getAppValue("user_ldap",'ldap_host','');
		$ldap_port=\OCP\Config::getAppValue("user_ldap",'ldap_port','');
		$ldap_base=\OCP\Config::getAppValue("user_ldap",'ldap_base','');
		$ds = ldap_connect($ldap_host,$ldap_port);
		if($ds) {
			$r=ldap_bind($ds);	
			$res = ldap_search($ds,$ldap_base,"uid=".$this->login);
			$entryID=ldap_first_entry($ds,$res);
			if($entryID!=false) {
				@$classe=ldap_get_values($ds,$entryID,'Divcod');
			}
		}
		
		return $classe[0];
	}
		
	// Traitement des infos du cdt selon deux vues : "classe" et "prof" 
	public function search_view() {
		if(!$this->is_ok || !empty($this->view)) return false;
		
		// Revoir totalement cette fonction
		$classe = $this->search_classe(); //fonction présente dans user-cas.php
		if($classe)	{
			// élève ou meta_classe
			if($classe!="autre") {
				$this->view = "classe";
				$this->valeur = $classe;
			}
			
			// autres donc prof...
			else {
				$this->view = "prof";
				$this->valeur = $user;				
			}
		}
		else {
			$this->view = "prof";
			$this->valeur = $this->login;
		}
	}

	/* Recherche de l'id de l'enseignant ou de la classe concerné sur le cdt */
	public function search_id_cdt() {
		if(!$this->is_ok || $this->id_cdt!==0) return false;
		
		// si classe, priorité à trouver $this->valeur dans le champ code_classe
		if($this->view=="classe") {
			$query_search = "SELECT `ID_".$this->view."` FROM `cdt_".$this->view."` WHERE `code_".$this->view."`='".$this->valeur."' LIMIT 1;";
			$result_search = @mysql_query($query_search,$this->link);
			$row_search = @mysql_fetch_row($result_search);
			if($row_search) $this->id_cdt = $row_search[0];
		}
		
		//recherche de $this->valeur dans le champ nom_xxxxx
		if($this->id_cdt===0) {
			$query_search = "SELECT `ID_".$this->view."` FROM `cdt_".$this->view."` WHERE `nom_".$this->view."`='".$this->valeur."' LIMIT 1;";
			$result_search = @mysql_query($query_search,$this->link);
			$row_search = @mysql_fetch_row($result_search);
			if(!$row_search) return false;
			$this->id_cdt = $row_search[0];
		}
			
		//si classe : recherche des groupements éventuels dont elle fait partie
		if($this->id_cdt>0 && $this->view=="classe") {
			$query_gic = "SELECT `gic_ID` FROM `cdt_groupe_interclasses_classe` WHERE `classe_ID`='".$this->id_cdt."';";
			$result_gic = @mysql_query($query_gic,$this->link);
			if(mysql_num_rows($result_gic)>0) {
				$this->gics_list .= "OR `e`.`gic_ID` IN (";
				while($row_gic = @mysql_fetch_row($result_gic))	$this->gics_list .= $row_gic[0].",";
				$this->gics_list = substr($this->gics_list,0,-1);
				$this->gics_list .= ")";
			}
		}
		
		//le cdt nécessite des variables de session pour y accéder en consultation
		if($this->view=="classe") $_SESSION["consultation"] = $this->id_cdt; //pour lire.php et consulter.php, il faut $_SESSION["consultation"] == $_GET['classe_ID']
		elseif(!isset($_SESSION['nom_prof'])) $_SESSION['nom_prof'] = "#"; //la simple existence suffit si vue "prof" pour lequel le "classe_ID" varie (voir début de lire.php)
	}

	/* Recherche des périodes de vacances indiquées dans le cahier de textes = La requête est reprise du script "administration/even_ajout.php" */
	public function search_vacances() {
		if(!$this->is_ok) return false;
		$query_vacances = "SELECT `heure_debut`,`heure_fin`,`theme_activ`,`ID_agenda` FROM `cdt_agenda` WHERE `classe_ID`=0 AND `theme_activ`<>'Remplacement' ORDER BY `code_date`;";
		$result_vacances = @mysql_query($query_vacances,$this->link);
		
		while($row_vacances = @mysql_fetch_row($result_vacances)) {
			list($day,$month,$year) = explode("/",trim($row_vacances[0]));
			$date_debut = mktime(0,0,0,$month,$day,$year);
			$dtdebutYmd = $year.$month.$day;
			
			list($day,$month,$year) = explode("/",trim($row_vacances[1]));
			$date_fin = mktime(23,59,59,$month,$day,$year);
			$dtfinYmd = $year.$month.$day;
			
			$this->vacances[] = array($date_debut,$date_fin,$row_vacances[2],$row_vacances[3],$dtdebutYmd,$dtfinYmd);
		}	
	}

	/* Recherche des plages horaires indiquées dans le cahier de textes */
	public function search_plages_horaires() {
		if(!$this->is_ok) return false;
		$query_horaires = "SELECT * FROM `cdt_plages_horaires`;";
		$result_horaires = @mysql_query($query_horaires,$this->link);
		while($row_horaires = @mysql_fetch_assoc($result_horaires))	{
			extract($row_horaires);
			$id = intval($ID_plage);
			$this->horaires[$id]["debut"] = $h1."h".$mn1;
			$this->horaires[$id]["fin"] = $h2."h".$mn2;
		}
	}


	/**
	 * Si le cdt est installé, lit l'emploi du temps au format attendu
	 * Pour le mois, on ne recherche que les devoirs
	 *
	 * @param  string $date timestamp ou forme "Ymd"
	 * @param  int    $format 1 pour day, 2 pour week et 3 pour month
	 */
	public function cdt_events($idcalendrier,$login,$date,$format=2) {
		
		if($this->debug) $fp = fopen('/www/tmp/owncloudata.txt', 'a');
				
		// Initialisation de l'utilisateur
		$this->login=$login;
		
		// Initialisation du calendrier
		$this->idcalendrier=$idcalendrier;
		
		//ici car on est sûr que la session est démarrée à cet appel, la recherche n'est faite qu'une fois
		$this->search_view();
		$this->search_id_cdt();
		
		//inutile de poursuivre si pas de vue identifiée ou pas d'identifiant prof/classe retrouvé
		if(empty($this->view) || empty($this->id_cdt)) return false;
		
		if(strlen($date)==8) {
			$day = substr($date,6,2);
			$month = substr($date,4,2);
			$year = substr($date,0,4);
			$this->date = $date;
			$this->consult_date = $day."/".$month."/".$year;
			$date = mktime(0,0,0,intval($month),intval($day),intval($year));
		}
		else {
			$this->date = date("Ymd",$date);
			$this->consult_date = date("d/m/Y",$date);
		}
		
		$num_jour = date('w',$date);
		$jour = $this->jours[$num_jour]; //jour demandé au format cdt
		$lundi = ($num_jour==0) ? $date-6*60*60*24 : $date-($num_jour-1)*60*60*24;
		$lundi = date("Ymd",$lundi); //pour vérifier l'alternance des semaines

		//emploi du temps seulement pour les vues day/week (un ou moins des id vaut 0 dans 'cdt_emploi_du_temps')
		//trop chargé sinon dans le vue month pour laquelle, on se contentera du compteur...
		$query_cours = "SELECT `cdt_semaine_ab`.`ID_sem`, `cdt_semaine_ab`.`semaine` as `nbsemaine`,`cdt_semaine_ab`.`s_code_date`,`e`.*,`m`.`nom_matiere`,`c`.`nom_classe`,`gi`.`nom_gic`,`p`.`nom_prof`,`p`.`identite`
						FROM `cdt_semaine_ab`, `cdt_emploi_du_temps` AS `e` 
						LEFT JOIN `cdt_matiere` AS `m` ON `m`.`ID_matiere`=`e`.`matiere_ID` 
						LEFT JOIN `cdt_classe` AS `c` ON `c`.`ID_classe`=`e`.`classe_ID` 
						LEFT JOIN `cdt_groupe_interclasses` AS `gi` ON `gi`.`ID_gic`=`e`.`gic_ID` 
						LEFT JOIN `cdt_prof` AS `p` ON `p`.`ID_prof`=`e`.`prof_ID` 
						WHERE (`e`.`".$this->view."_ID`='".$this->id_cdt."' ".$this->gics_list.");";

		if($this->debug) fwrite($fp, $query_cours);
		
		$result_cours = @mysql_query($query_cours,$this->link);
		while($row_cours = @mysql_fetch_assoc($result_cours)) {
			extract($row_cours);
			
			// Est-on dans la bonne semaine ?
			if($semaine!="A et B" && $semaine!=$nbsemaine) continue;
			
			
			// Calculer le jour du cours
			switch ($jour_semaine) {
				case "Lundi"   : $nbaddday=0; break;
				case "Mardi"   : $nbaddday=1; break;
				case "Mercredi": $nbaddday=2; break;
				case "Jeudi"   : $nbaddday=3; break;
				case "Vendredi": $nbaddday=4; break;
				case "Samedi"  : $nbaddday=5; break;
				case "Dimanche": $nbaddday=6; break;
			}
			$Ymd_date = date("Ymd", strtotime($s_code_date . " + $nbaddday days"));			

			// Est-on dans la bonne période ?
			if($this->debug) fwrite($fp, "\nPERIODE = ".$edt_exist_debut." ".$edt_exist_fin." >>> ".$Ymd_date);
			if($Ymd_date<str_replace("-","",$edt_exist_debut) || $Ymd_date>str_replace("-","",$edt_exist_fin)) continue;
			
			
			//cours valide, on le comptabilise pour vérifier que l'affichage est complet et on sort si vue mensuelle demandée
			$this->total_cours++;
			//if($this->format==3) continue;
			
			// Pour un regroupement, il faut retrouver une/la classe pour générer un lien valide vers le cdt
			$this->gic_id = intval($gic_ID);
			if($this->view=="classe") $this->classe_id = intval($this->id_cdt);
			elseif(intval($classe_ID)>0) $this->classe_id = intval($classe_ID);
			else {
				//c'est un enseignant pour un regroupement, on cherche une classe au hasard faisant partie de ce regroupement (affichage séance identique)
				$query_classe 		= "SELECT `classe_ID` FROM `cdt_groupe_interclasses_classe` WHERE `gic_ID`=".$this->gic_id." LIMIT 1;";
				$result_classe 		= @mysql_query($query_classe,$this->link);
				$row_classe 		= @mysql_fetch_row($result_classe);
				$this->classe_id	= ( $row_classe ? intval($row_classe[0]) : 0 );
			}

			//mise en place des variables
			
			$this->type 		= "Cours";
			$this->idsem		= $ID_sem;
			$this->idcdt		= $ID_emploi;
			$this->date_debut 	= $Ymd_date;
			$this->date_fin 	= $Ymd_date;
			$this->heure_debut 	= str_replace("h",":",$heure_debut);
			$this->heure_fin 	= str_replace("h",":",$heure_fin);
			$this->classe 		= ( empty($nom_gic) ? ( empty($nom_classe) ? 'Inconnue' : $nom_classe ) : $nom_gic );
			$this->matiere 		= ( empty($nom_matiere) ? 'Inconnue' : $nom_matiere );
			$this->enseignant 	= ( empty($identite) ? ( empty($nom_prof) ? 'Inconnu' : $nom_prof ) : $identite );
			$this->group 		= ( empty($groupe) ? 'Inconnu' : $groupe );
			$this->devoir 		= "";
			$this->alternance 	= $semaine;
			$this->matiere_id 	= intval($matiere_ID);
			$this->allday 		= 0;

			if($this->view=="classe" && !empty($nom_gic))
				$this->show_classe = true;
			else
				$this->show_classe = false;

			//génération de l'évènement
			$this->make_event();
		}
		
		//devoirs (classe_ID jamais nul dans 'cdt_travail' car si regroupement, le travail est copié pour chaque classe concernée)
		$query_devoirs = "SELECT `t`.*,`a`.`heure_debut`,`a`.`heure_fin`,`m`.`nom_matiere`,`c`.`nom_classe`,`gi`.`nom_gic`,`p`.`nom_prof`,`p`.`identite` FROM `cdt_travail` AS `t` 
				    	  LEFT JOIN `cdt_agenda` AS `a` ON `a`.`ID_agenda`=`t`.`agenda_ID` 
						  LEFT JOIN `cdt_matiere` AS `m` ON `m`.`ID_matiere`=`t`.`matiere_ID` 
						  LEFT JOIN `cdt_classe` AS `c` ON `c`.`ID_classe`=`t`.`classe_ID` 
						  LEFT JOIN `cdt_groupe_interclasses` AS `gi` ON `gi`.`ID_gic`=`t`.`gic_ID` 
						  LEFT JOIN `cdt_prof` AS `p` ON `p`.`ID_prof`=`t`.`prof_ID` 
						  WHERE `t`.`".$this->view."_ID`='".$this->id_cdt	."'
						  ORDER BY `t`.`gic_ID`;";
		$result_devoirs = @mysql_query($query_devoirs,$this->link);
		$travaux = array();
		while($row_devoirs = @mysql_fetch_assoc($result_devoirs)) {
			extract($row_devoirs);

			//on ne traite pas les devoirs liés à une séance de cours qui n'a pas encore eu lieu !
			$hour 	= substr($heure_debut,0,2);
			$minute = substr($heure_debut,3,2);
			$day 	= substr($code_date,6,2);
			$month 	= substr($code_date,4,2);
			$year 	= substr($code_date,0,4);
			$seance = mktime(intval($hour),intval($minute),0,intval($month),intval($day),intval($year));
			$now 	= time();
			if($now>=$seance) continue;
			
			$this->classe_id 	= intval($classe_ID);
			$this->gic_id 		= intval($gic_ID);
			$this->matiere_id 	= intval($matiere_ID);
			
			//pour un prof, attention à ne pas afficher 3 fois le travail donnée si regroupement de 3 classes...
			//sur une même journée, le critère de non affichage est de retrouver le même travail pour un même regroupement
			if($this->view=="prof") {
				if($this->gic_id>0)	{
					if(is_array($travaux[$gic_ID]) && in_array($travail,$travaux[$gic_ID])) continue;
					$travaux[$gic_ID][] = $travail;
				}
			}
			
			//mise en place des variables
			$this->type 		= "Devoir";
			$this->idsem		= 0;
			$this->idcdt		= $agenda_ID;
			$this->date_debut 	= $year.$month.$day;
			$this->date_fin 	= $this->date_debut;
			$this->heure_debut 	= str_replace("h",":",$heure_debut);
			$this->heure_fin 	= str_replace("h",":",$heure_fin);				
			$this->classe 		= ( empty($nom_gic) ? ( empty($nom_classe) ? 'Inconnue' : $nom_classe ) : $nom_gic );
			$this->matiere 		= ( empty($nom_matiere) ? 'Inconnue' : $nom_matiere );
			$this->enseignant 	= ( empty($identite) ? ( empty($nom_prof) ? 'Inconnu' : $nom_prof ) : $identite );
			$this->group 		= ( empty($t_groupe) ? 'Inconnu' : $t_groupe );
			$this->devoir 		= ( empty($travail) ? 'Inconnu' : $travail );
			$this->alternance 	= "";
			$this->matiere_id 	= intval($matiere_ID);
			$this->allday 		= 0;
			
			if($this->view=="classe" && !empty($nom_gic))
				$this->show_classe = true;
			else
				$this->show_classe = false;
								
			//génération de l'évènement
			$this->make_event();
		}

		// jour de vacances scolaires éventuellement renseignées dans le cdt
		foreach($this->vacances as $i=>$periodes) {
			$this->type 		= "Vacances";
			$this->idsem		= 0;
			$this->idcdt		= $periodes[3];
			$this->date_debut 	= $periodes[4];
			$this->date_fin 	= $periodes[5];
			$this->heure_debut 	= "";
			$this->heure_fin 	= "";
			$this->classe 		= $periodes[2];
			$this->matiere 		= "";
			$this->enseignant 	= "";
			$this->group 		= "";
			$this->devoir 		= "";
			$this->alternance 	= "";
			$this->matiere_id 	= 0;
			$this->allday 		= 1;

			$this->make_event();		
		}
		
		// Purge des évènements owncloud obsolètes
		if($this->debug) fwrite($fp, "\n\n==PURGE==============================================================");
		
		$stmt = OCP\DB::prepare("SELECT * FROM `*PREFIX*clndr_objects` WHERE calendarid=?");
		$result = $stmt->execute(array($this->idcalendrier));
		while($row = $result->fetchRow()) {
			if($this->debug) fwrite($fp, "\nTest evènement : ".$row["summary"]." ");
			
			// Si le lien envole n'existe pas supprimer l'évènement
			$result2=array();
			$row2=array();
			$stmt = OCP\DB::prepare("SELECT * FROM `*PREFIX*clndr_envolecdt` WHERE idowncloud=?");
			$result2 = $stmt->execute(array($row["id"]));
			if(!($row2=$result2->fetchRow())) {
				// Supprimer le lien owncloud <> cdt
				if($this->debug) fwrite($fp, "lien envole n'existe pas");
				$stmt = OCP\DB::prepare("DELETE FROM `*PREFIX*clndr_objects` WHERE id=?");
				$result2 = $stmt->execute(array($row["id"]));
			}
			else {
				switch($row2["typecdt"]) {
					case "Cours" :
						$query_cours = "SELECT `cdt_semaine_ab`.`ID_sem`, `cdt_semaine_ab`.`semaine` as `nbsemaine`,`cdt_semaine_ab`.`s_code_date`,`e`.*,`m`.`nom_matiere`,`c`.`nom_classe`,`gi`.`nom_gic`,`p`.`nom_prof`,`p`.`identite`
										FROM `cdt_semaine_ab`, `cdt_emploi_du_temps` AS `e` 
										LEFT JOIN `cdt_matiere` AS `m` ON `m`.`ID_matiere`=`e`.`matiere_ID` 
										LEFT JOIN `cdt_classe` AS `c` ON `c`.`ID_classe`=`e`.`classe_ID` 
										LEFT JOIN `cdt_groupe_interclasses` AS `gi` ON `gi`.`ID_gic`=`e`.`gic_ID` 
										LEFT JOIN `cdt_prof` AS `p` ON `p`.`ID_prof`=`e`.`prof_ID` 
										WHERE (`ID_sem`=".$row2["idsem"]." AND `ID_emploi`= ".$row2["idcdt"]." AND `e`.`".$this->view."_ID`='".$this->id_cdt."' ".$this->gics_list.");";
						$result_cours = @mysql_query($query_cours,$this->link);
						if(!($row_cours = @mysql_fetch_assoc($result_cours))) {
							if($this->debug) fwrite($fp, "emploi du temps CdT n'existe pas");
							$stmt = OCP\DB::prepare("DELETE FROM `*PREFIX*clndr_objects` WHERE id=?");
							$result2 = $stmt->execute(array($row["id"]));							
						}
					break;
					
					case "Devoir" :
						$query_devoirs = "SELECT `t`.*,`a`.`heure_debut`,`a`.`heure_fin`,`m`.`nom_matiere`,`c`.`nom_classe`,`gi`.`nom_gic`,`p`.`nom_prof`,`p`.`identite` FROM `cdt_travail` AS `t` 
										  LEFT JOIN `cdt_agenda` AS `a` ON `a`.`ID_agenda`=`t`.`agenda_ID` 
										  LEFT JOIN `cdt_matiere` AS `m` ON `m`.`ID_matiere`=`t`.`matiere_ID` 
										  LEFT JOIN `cdt_classe` AS `c` ON `c`.`ID_classe`=`t`.`classe_ID` 
										  LEFT JOIN `cdt_groupe_interclasses` AS `gi` ON `gi`.`ID_gic`=`t`.`gic_ID` 
										  LEFT JOIN `cdt_prof` AS `p` ON `p`.`ID_prof`=`t`.`prof_ID` 
										  WHERE `agenda_ID`=".$row2["idcdt"]." AND `t`.`".$this->view."_ID`='".$this->id_cdt."'
										  ORDER BY `t`.`gic_ID`;";
						$result_devoirs = @mysql_query($query_devoirs,$this->link);
						if(!($row_devoirs = @mysql_fetch_assoc($result_devoirs))) {
							if($this->debug) fwrite($fp, "agenda CdT n'existe pas");
							$stmt = OCP\DB::prepare("DELETE FROM `*PREFIX*clndr_objects` WHERE id=?");
							$result2 = $stmt->execute(array($row["id"]));							
						}
					break;
					
					case "Vacances" :
						$query_vacances = "SELECT * FROM `cdt_agenda`
										   WHERE `ID_agenda`=".$row2["idcdt"]." AND `classe_ID`=0 AND `theme_activ`<>'Remplacement';";
						fwrite($fp, $query_vacances);
						$result_vacances = @mysql_query($query_vacances,$this->link);
						if(!($row_vacances = @mysql_fetch_assoc($result_vacances))) {
							if($this->debug) fwrite($fp, "vacances CdT n'existe pas");
							$stmt = OCP\DB::prepare("DELETE FROM `*PREFIX*clndr_objects` WHERE id=?");
							$result2 = $stmt->execute(array($row["id"]));							
						}
					break;	
				}
			}
		}
		if($this->debug) fwrite($fp, "\n");		
	}

	/* Généreration d'un évènement */
	public function make_event() {
		if($this->debug) $fp = fopen('/www/tmp/owncloudata.txt', 'a');
		
		if($this->debug) {
			fwrite($fp, "\n\n==MAKE EVENT==========================================================");
			fwrite($fp, "
		Type        = ".$this->type."
		IdSem       = ".$this->idsem."
		IdCdT       = ".$this->idcdt."
		DateDébut   = ".$this->date_debut."
		DateFin     = ".$this->date_fin."
		HeureDébut  = ".$this->heure_debut."
		HeureFin    = ".$this->heure_fin."
		Classe      = ".$this->classe."
		MatiereId   = ".$this->matiere_id."
		Matiere     = ".$this->matiere."
		Enseignant  = ".$this->enseignant."
		Group       = ".$this->group."
		Devoir      = ".$this->devoir."
		Alternance  = ".$this->alternance."
		ShowClasse  = ".$this->show_classe."
		AllDay		= ".$this->allday);
		}
		
		// Lister l'emploie du temps de l'utilisateur
		$request=array();
		$request['title']		=$this->type;
		if($this->classe!="")   $request['title']=$request['title']." = ".$this->classe;
		if($this->matiere!="")  $request['title']=$request['title']." > ".$this->matiere;
		$request['title']       = trim(utf8_encode(strip_tags(html_entity_decode($request['title']))));
		
		$request['from']		=$this->date_debut;
		$request['fromtime']	=$this->heure_debut;
		$request['to']			=$this->date_fin;
		$request['totime']		=$this->heure_fin;
		$request['categories']	=$this->type;
		
		$request['allday']		=$this->allday;
		if(!($this->allday)) unset($request['allday']);
		
		$request['description']	=trim(utf8_encode(strip_tags(html_entity_decode($this->devoir))));
		$request['description'] = strtr($request['description'], array("\r\n"=>"\n"));
		
		// Recherche si l'évènement n'existe pas déjà
		$stmt = OCP\DB::prepare("SELECT idowncloud FROM `*PREFIX*clndr_envolecdt` WHERE login=? AND typecdt=? AND idsem=? AND idcdt=?");
		$result = $stmt->execute(array($this->login,$this->type,$this->idsem,$this->idcdt));
			
		// S'il existe on vérifie qu'il n'y pas eu de changement
		if($row = $result->fetchRow()) {
			$idowncloud=$row["idowncloud"];
			
			$event = OC_Calendar_Object::find($idowncloud);
			if($event["summary"]!="") {
				$object			= OC_VObject::parse($event['calendardata']);				
				$description	= $object->VEVENT->DESCRIPTION;
				$dtstart 		= $object->VEVENT->DTSTART;
				$dtend 			= $object->VEVENT->DTEND;
				$start_dt 		= $dtstart->getDateTime()->format('d-m-Y H:i');
				$end_dt 		= $dtend->getDateTime()->format('d-m-Y H:i');
				
				fwrite($fp,"\n>>>>> SABRE = ".Sabre\VObject\Property\DateTime::UTC);
				switch($dtstart->getDateType()) {
					case Sabre\VObject\Property\DateTime::UTC:
						$timezone = new DateTimeZone(OC_Calendar_App::getTimezone());
						$newDT    = $dtstart->getDateTime();
						$newDT->setTimezone($timezone);
						$dtstart->setDateTime($newDT);
						$newDT    = $dtend->getDateTime();
						$newDT->setTimezone($timezone);
						$dtend->setDateTime($newDT);
						
					case Sabre\VObject\Property\DateTime::LOCALTZ:
					case Sabre\VObject\Property\DateTime::LOCAL:
						$startdate = $dtstart->getDateTime()->format('Ymd');
						$starttime = $dtstart->getDateTime()->format('H:i');
						$enddate = $dtend->getDateTime()->format('Ymd');
						$endtime = $dtend->getDateTime()->format('H:i');
						$allday = false;
						break;
					case Sabre\VObject\Property\DateTime::DATE:
						$startdate = $dtstart->getDateTime()->format('Ymd');
						$starttime = '';
						$dtend->getDateTime()->modify('-1 day');
						$enddate = $dtend->getDateTime()->format('Ymd');
						$endtime = '';
						$allday = true;
						break;
				}
				
				$event["description"]	= trim($description);
				$event["from"]			= $startdate;
				$event["fromtime"]		= $starttime;
				$event["to"]			= $enddate;
				$event["totime"]		= $endtime;
				$event["allday"]		= $allday;
				
				if($event["summary"]!=$request["title"]||
				   $event["description"]!=$request["description"]||
				   $event["from"]!=$request["from"]||
				   $event["fromtime"]!=$request["fromtime"]||
				   $event["to"]!=$request["to"]||
				   $event["totime"]!=$request["totime"]||
				   $event["allday"]!=$request["allday"]) {
					   
					if($this->debug) fwrite($fp, "\n\nMISE A JOUR :
		title	 	= ".$request["title"]." > ".$event["summary"]."
		description = ".$request["description"]." > ".$event["description"]."
		from     	= ".$request["title"]." > ".$event["summary"]."
		from     	= ".$request["from"]." > ".$event["from"]."
		fromtime 	= ".$request["fromtime"]." > ".$event["fromtime"]."
		end		 	= ".$request["to"]." > ".$event["to"]."
		endtime  	= ".$request["totime"]." > ".$event["totime"]."
		allday  	= ".$request["allday"]." > ".$event["allday"]);

					$vcalendar = OC_Calendar_App::getVCalendar($idowncloud);
					$vcalendar = OC_Calendar_Object::updateVCalendarFromRequest($request,$vcalendar);
					$insertid  = OC_Calendar_Object::edit($idowncloud, $vcalendar->serialize());
				}
			}
		}
		
		// S'il n'existe plus on le regenère
		if($idowncloud!="") {
			$stmt = OCP\DB::prepare("SELECT id FROM `*PREFIX*clndr_objects` WHERE id=?");
			$result = $stmt->execute(array($idowncloud));
			if(!($row=$result->fetchRow())) {
				// Supprimer le lien owncloud <> cdt
				$stmt = OCP\DB::prepare("DELETE FROM `*PREFIX*clndr_envolecdt` WHERE idowncloud=? AND login=? AND typecdt=? AND idsem=? AND idcdt=?");
				$result = $stmt->execute(array($idowncloud,$this->login,$this->type,$this->idsem,$this->idcdt));
				
				// Vider l'id pour regénération 
				$idowncloud="";				
			}
		}

		if($idowncloud=="") {
			$errarr=OC_Calendar_Object::validateRequest($request);
			$vcalendar = OC_Calendar_Object::createVCalendarFromRequest($request);
			$insertid = OC_Calendar_Object::add($this->idcalendrier, $vcalendar->serialize());			
					
			if($insertid>0) {
				$stmt = OCP\DB::prepare("INSERT INTO `*PREFIX*clndr_envolecdt` (`idowncloud`,`login`,`typecdt`,`idsem`,`idcdt`) VALUES(?,?,?,?,?)");
				$result = $stmt->execute(array($insertid,$this->login,$this->type,$this->idsem,$this->idcdt));
			}
		}
	}
}
