<?php

namespace OCA\Documents;

\OCP\JSON::callCheck();
\OCP\JSON::checkAdminUser();

$converter = isset($_POST['converter']) ? $_POST['converter'] : null;
$url = isset($_POST['url']) ? $_POST['url'] : null;
try {
	if (!is_null($converter)){
		Config::setConverter($converter);
	}
	
	if (!is_null($url)){
		Config::setConverterUrl($url);
	}
	
	if (Config::getConverter()!='local'){
		if (!Converter::checkConnection()){
			Helper::warnLog('Bad response from Format Filter Server');
			\OCP\JSON::error(array( 'data'=>
				array('message' => Config::getL10n()->t('Format filter server is down or misconfigured') )
			));
			exit();
		}
	} else {
		$targetFilter = 'odt:writer8';
		$targetExtension = 'odt';
		$input = '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
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA8DAAAB4AAABgMwAAGAAAAAAAAAAAAAAA6hkAABgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAeDMAAAgAAAAAAAAAAAAAAIAzAAAMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIA2QAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAB0AGUAcwB0AAwAEwAgAFQATwBDACAAFAAVAAwACAANAA0ADQANAA0AEwAgAFAAQQBHAEUAIAAUADEAFQANAA0ADQANAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIAAAKCAAADAgAABYIAAAYCAAAGggAABwIAAAeCAAAKAgAACoIAAA2CAAAOAgAADoIAAA8CAAAQggAAAD9AP39APgA8e7x7vEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABDBKaQAADTBKaQADagAAAABVCAEJA2oAAAAAVQgBA1UIAQAOAAgAAAoIAAAcCAAAIAgAACIIAAAkCAAAJggAACgIAAA+CAAAQAgAAEIIAABECAAA+QAAAAAAAAAAAAAAAPcAAAAAAAAAAAAAAAD1AAAAAAAAAAAAAAAA8wAAAAAAAAAAAAAAAPEAAAAAAAAAAAAAAADvAAAAAAAAAAAAAAAA7QAAAAAAAAAAAAAAAOsAAAAAAAAAAAAAAADpAAAAAAAAAAAAAAAA5wAAAAAAAAAAAAAAAOUAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAQAAAAEAAAABAAAAAYAAAAEAAAABAAAAAQAAAAEAAAABgAAAAQAAAAV0AA3GBQAB6CkKAAs0AB+w0C8gsOA9IbBuBCKwaAIjkMUCGLDQAiSQUwMyUAAAMZBoATBwAAAAADNQAAAoMgAOMAA3AB+w0C8gsOA9IbBuBCKwaAIjkMUCGLDQAiSQUwMyUAAAMZBoATBwAAAAADNQAAAoMgAoMgAJMAA3AB+w0C8gsOA9IbBuBCKwaAIjkMUCGLDQAiSQUwMyUAAAMZBoATBwAAAAADNQAAAoMgAOMAAJMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAD+/
wAAAQACAAAAAAAAAAAAAAAAAAAAAAACAAAAAtXN1ZwuGxCTlwgAKyz5rkQAAAAF1c3VnC4bEJOXCAArLPmuXAAAABgAAAABAAAAAQAAABAAAAACAAAA6f0AABgAAAABAAAAAQAAABAAAAACAAAA6f0AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAUgBvAG8AdAAgAEUAbgB0AHIAeQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABYABQD//////////wEAAAAGCQIAAAAAAMAAAAAAAABGAAAAAAAAAAAAAAAAAAAAAAAAAAADAAAAgBEAAAAAAAABAEMAbwBtAHAATwBiAGoAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAEgACAAIAAAAEAAAA/////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABqAAAAAAAAAAEATwBsAGUAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAKAAIA/////wMAAAD/////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgAAABQAAAAAAAAAMQBUAGEAYgBsAGUAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA4AAgD///////////////8AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAEAAAAgzkAAAAAAAAFAFMAdQBtAG0AYQByAHkASQBuAGYAbwByAG0AYQB0AGkAbwBuAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAKAACAAUAAAAHAAAA/////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAMAAABEAQAAAAAAAFcAbwByAGQARABvAGMAdQBtAGUAbgB0AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAaAAIABgAAAP//////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACQAAAKgOAAAAAAAATwBiAGoAZQBjAHQAUABvAG8AbAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABYAAQD///////////////8AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAD+////AAAAAAAAAAAFAEQAbwBjAHUAbQBlAG4AdABTAHUAbQBtAGEAcgB5AEkAbgBmAG8AcgBtAGEAdABpAG8AbgAAAAAAAAAAAAAAOAACAP///////////////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAEQAAAB0AAAAAAAAAA==';
		
		$infile = \OCP\Files::tmpFile();
		$outdir = \OCP\Files::tmpFolder();
		$outfile = $outdir . '/' . basename($infile) . '.' . $targetExtension;
		$cmd = Helper::findOpenOffice();
 
		$params = ' --headless --convert-to ' . escapeshellarg($targetFilter) . ' --outdir ' 
			. escapeshellarg($outdir) 
			. ' --writer '. escapeshellarg($infile) 
			. ' -env:UserInstallation=file://' . escapeshellarg(get_temp_dir()) . ' 2>&1'
		;
		file_put_contents($infile, $input);
 
		$result = shell_exec($cmd . $params);
 		$exists = file_exists($outfile);
		
		if (!$exists){
			Helper::warnLog('Conversion failed. Raw output:' . $result);
			\OCP\JSON::error(array( 'data'=>
					array('message' => Config::getL10n()->t('Conversion failed. Check log for details.') )
			));
			exit();
		} else {
			unlink($outfile);
		}
	}
	
	\OCP\JSON::success(array( 'data'=>array('message'=>Config::getL10n()->t('Saved')) ));
} catch (\Exception $e){
	\OCP\JSON::error(array( 'data'=>
					array('message' => $e->getMessage() )
	));
}
