<?php

/**
 * ownCloud - user_cas
 *
 * @author Sixto Martin <sixto.martin.garcia@gmail.com>
 * @copyright Sixto Martin Garcia. 2012
 * @copyright Leonis. 2014 <devteam@leonis.at>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU AFFERO GENERAL PUBLIC LICENSE
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU AFFERO GENERAL PUBLIC LICENSE for more details.
 *
 * You should have received a copy of the GNU Affero General Public
 * License along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 */


	require_once 'CAS-1.3.1/eoleCAS.php';
	require_once 'configCAS/cas.inc.php';	

	if (__CAS_DEBUG){
		EolephpCAS::setDebug('/var/log/posh/phpCAS-owncloud.log');
	}
	
	$baseurl=basename($_SERVER['PHP_SELF']);
	$url=$_SERVER['PHP_SELF'];
	$querystring=$_SERVER["QUERY_STRING"];
	
	//non casifie pour webdav & filessharing & console
	$webdav=strpos($_SERVER['PHP_SELF'],'/webdav');
	$filesharing=strpos($_SERVER['PHP_SELF'],'/files_sharing');
	$remote=strpos($_SERVER['PHP_SELF'],'remote.php');
	$apicalendar=strpos($_SERVER['PHP_SELF'],'calendar/ajax/');
	
	if( $baseurl != "public.php"
		&& $baseurl != "occ"
		&& $baseurl != "core.css"
		&& $baseurl != "public.css" 
		&& $baseurl != "getstoragestats.php"
		&& $baseurl != "heartbeat"
		&& $baseurl != "status.php"
		&& $baseurl != "shares"
		&& $baseurl != "translations.php"
		&& $baseurl != "mimes.php"
		&& $baseurl != "cron.php"
		&& $baseurl != "oc.js"		
		&& $baseurl != "viewer.php"
		&& $baseurl != "files.php"
		&& $baseurl != "editor.css"
		&& $baseurl != "odfviewer.css"
		&& $baseurl != "download.php"
		&& $baseurl != "share.php"		
		&& $baseurl != "upload.php"	
		&& $webdav 	== FALSE 
		&& $filesharing	== FALSE 
		&& $remote == FALSE
		&& $apicalendar == FALSE)
	{
		require_once 'envole_cas/envole_cas.php';

		//OCP\App::registerAdmin('user_cas', 'settings');

		// register user backend
		OC_User::useBackend( 'CAS' );

		OC::$CLASSPATH['OC_USER_CAS_Hooks'] = 'envole_cas/lib/hooks.php';
		OCP\Util::connectHook('OC_User', 'post_createUser', 'OC_USER_CAS_Hooks', 'post_createUser');
		OCP\Util::connectHook('OC_User', 'post_login', 'OC_USER_CAS_Hooks', 'post_login');
		OCP\Util::connectHook('OC_User', 'logout', 'OC_USER_CAS_Hooks', 'logout');

		if( isset($_GET['app']) && $_GET['app'] == 'envole_cas' ) {

			require_once 'envole_cas/auth.php';

			
			
			if (!OC_User::login('', '')) {
				$error = true;
			}
			
			if (isset($_SERVER["QUERY_STRING"]) && !empty($_SERVER["QUERY_STRING"]) && $_SERVER["QUERY_STRING"] != 'app=envole_cas') {
				$redirect=str_replace("app=envole_cas&","",$url."/?".$querystring);
				$redirect=str_replace("owncloud/index.php/?redirect=/","",$redirect);
				header( 'Location: ' . $redirect);
				exit();
			}
			
			OC::$REQUESTEDAPP = '';
			OC_Util::redirectToDefaultPage();

		}


		if (!OCP\User::isLoggedIn()) {
			$redirect=$url;
			if($querystring!="") $redirect=$redirect."/?".$querystring;;

			header( 'Location: ' . OC::$WEBROOT . '/?app=envole_cas&redirect='.$redirect);
			exit();				
			
		}
	}
