<?php
/**
 * ownCloud - user_cas
 *
 * @author Sixto Martin <sixto.martin.garcia@gmail.com>
 * @copyright Sixto Martin Garcia. 2012
 * @copyright Leonis. 2014 <devteam@leonis.at>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU AFFERO GENERAL PUBLIC LICENSE
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU AFFERO GENERAL PUBLIC LICENSE for more details.
 *
 * You should have received a copy of the GNU Affero General Public
 * License along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

/**
 * This class contains all hooks.
 */
 
use \OCA\user_ldap\lib\ldap;
 
class OC_USER_CAS_Hooks {

	static public function post_login($parameters) {

		$uid = $parameters['uid'];
		$casBackend = OC_USER_CAS::getInstance();
		$userDatabase = new OC_User_Database;

		if (eolephpCAS::isAuthenticated()) {
			$ldapWrapper = new OCA\user_ldap\lib\LDAP();
			$configPrefixes = OCA\user_ldap\lib\Helper::getServerConfigurationPrefixes(true);
			$ocConfig = \OC::$server->getConfig();
			$userManager = new OCA\user_ldap\lib\user\Manager($ocConfig,new OCA\user_ldap\lib\FilesystemHelper(),new OCA\user_ldap\lib\LogWrapper(),\OC::$server->getAvatarManager(),new \OCP\Image());
			$connector = new OCA\user_ldap\lib\Connection($ldapWrapper, $configPrefixes[0]);
			$ldapAccess = new OCA\user_ldap\lib\Access($connector, $ldapWrapper, $userManager);
			$userBackend  = new OCA\user_ldap\USER_LDAP($ldapAccess);
			$dn=$ldapAccess->searchUsers("uid=".$uid ,"dn",10,0);
			if(array($dn)) {
				$ldapAccess->dn2ocname($dn[0],$uid,true);
			}			
			
			// $cas_attributes may vary in name, therefore attributes are fetched to $attributes
			$cas_attributes = eolephpCAS::getAttributes();
			$cas_uid = eolephpCAS::getUser();

			// parameters 
			$attributes = array();


			if ($cas_uid == $uid) {
				if (array_key_exists($casBackend->displayNameMapping, $cas_attributes)) 
					$attributes['cas_name'] = $cas_attributes[$casBackend->displayNameMapping];	

                
				if (array_key_exists($casBackend->mailMapping, $cas_attributes)) 
					$attributes['cas_email'] = $cas_attributes[$casBackend->mailMapping];


				if (array_key_exists($casBackend->groupMapping, $cas_attributes)) {
					$attributes['cas_groups'] = $cas_attributes[$casBackend->groupMapping];
				}
				else if (!empty($casBackend->defaultGroup)) {
					$attributes['cas_groups'] = array($casBackend->defaultGroup);
				}


				if (!$userDatabase->userExists($uid)) {
					// create users if they do not exist
					if (preg_match( '/[^a-zA-Z0-9 _\.@\-]/', $uid)) {
						return false;
					}
					else {
						$random_password = OC_Util::generateRandomBytes(20);
						$userDatabase->createUser($uid, $random_password);

						// after creating the user, fill the attributes
						if($userDatabase->userExists($uid)) 
							OC_USER_CAS_Hooks::update_user($uid,$attributes);
						
					}
				}
				
				
				// try to update user attributes
				if ($casBackend->updateUserData) 
					OC_USER_CAS_Hooks::update_user($cas_uid,$attributes);

				
				return true;
			}
		}
		return false;
	}

	static public function update_user($uid, $attributes) {

		$casBackend = OC_USER_CAS::getInstance();

		if(isset($attributes['cas_email'])) {
			update_mail($uid, $attributes['cas_email']);
		}
		if (isset($attributes['cas_name'])) {
			update_name($uid, $attributes['cas_name']);
		}
		if (isset($attributes['cas_groups'])) {
			update_groups($uid, $attributes['cas_groups'], $casBackend->protectedGroups, false);
		}
	}


	static public function logout($parameters) {
		$casBackend = OC_USER_CAS::getInstance();

		if (eolephpCAS::isAuthenticated()) 
			$urllogout="https://".$_SERVER["SERVER_NAME"]."/owncloud";
			eolephpCAS::logoutWithUrl($urllogout);
		
		return true;
	}

}

function update_mail($uid, $email) {
	if ($email != OC_Preferences::getValue($uid, 'settings', 'email', '')) {
		OC_Preferences::setValue($uid, 'settings', 'email', $email);
	}
}

function update_name($uid, $name) {
		$casBackend = OC_USER_CAS::getInstance();
		$casBackend->setDisplayName($uid, $name);
}

/**
* Gets an array of groups and will try to add the group to OC and then add the user to the groups.
* 
*/
function update_groups($uid, $groups, $protected_groups=array(), $just_created=false) {

	if(!$just_created) {
		$old_groups = OC_Group::getUserGroups($uid);
		foreach($old_groups as $group) {
			if(!in_array($group, $protected_groups) && !in_array($group, $groups)) {
				OC_Group::removeFromGroup($uid,$group);
			}
		}
	}

	foreach($groups as $group) {
		if (!preg_match( '/[^a-zA-Z0-9 _\.@\-]/', $group)) {
			if (!OC_Group::inGroup($uid, $group)) {
				if (!OC_Group::groupExists($group)) {
					OC_Group::createGroup($group);
				}
				OC_Group::addToGroup($uid, $group);
			}
		}
	}
}
