-- example de création d'une base de données MySQL
-- création de la base de donnée
CREATE DATABASE owncloud CHARACTER SET utf8 COLLATE utf8_general_ci;

-- création du user de la base
grant all privileges on owncloud.* to owncloud@%%adresse_ip_web identified by 'owncloud';
flush privileges ;

-- connexion à la base
\r owncloud


SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Base de données: `owncloud`
--

-- --------------------------------------------------------

--
-- Structure de la table `oc_appconfig`
--

CREATE TABLE IF NOT EXISTS `oc_appconfig` (
  `appid` varchar(32) NOT NULL DEFAULT ' ',
  `configkey` varchar(64) NOT NULL DEFAULT ' ',
  `configvalue` longtext,
  KEY `appconfig_appid_key_index` (`appid`,`configkey`),
  KEY `appconfig_config_key_index` (`configkey`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Contenu de la table `oc_appconfig`
--

INSERT INTO `oc_appconfig` (`appid`, `configkey`, `configvalue`) VALUES
('core', 'installedat', '1374505708.5236'),
('core', 'lastupdatedat', '1374505708.5248'),
('core', 'remote_core.css', '/core/minimizer.php'),
('core', 'remote_core.js', '/core/minimizer.php'),
('admin_migrate', 'installed_version', '0.1'),
('admin_migrate', 'enabled', 'yes'),
('files_texteditor', 'installed_version', '0.3'),
('files_texteditor', 'enabled', 'yes'),
('files_trashbin', 'installed_version', '0.4'),
('files_trashbin', 'types', 'filesystem'),
('files_trashbin', 'enabled', 'yes'),
('updater', 'installed_version', '0.3'),
('updater', 'enabled', 'yes'),
('updater', 'types', ''),
('files_odfviewer', 'installed_version', '0.1'),
('files_odfviewer', 'enabled', 'yes'),
('files_imageviewer', 'installed_version', '1.0'),
('files_imageviewer', 'enabled', 'yes'),
('media', 'installed_version', '0.4.3'),
('core', 'remote_ampache', 'media/remote.php'),
('media', 'enabled', 'yes'),
('calendar', 'installed_version', '0.6.3'),
('core', 'remote_calendar', 'calendar/appinfo/remote.php'),
('core', 'remote_caldav', 'calendar/appinfo/remote.php'),
('core', 'public_calendar', 'calendar/share.php'),
('core', 'public_caldav', 'calendar/share.php'),
('calendar', 'enabled', 'no'),
('files_versions', 'installed_version', '1.0.3'),
('files_versions', 'types', 'filesystem'),
('files_versions', 'enabled', 'yes'),
('user_migrate', 'installed_version', '0.1'),
('user_migrate', 'enabled', 'yes'),
('files_sharing', 'installed_version', '0.3.3'),
('core', 'public_files', 'files_sharing/public.php'),
('core', 'public_webdav', 'files_sharing/public.php'),
('files_sharing', 'types', 'filesystem'),
('files_sharing', 'enabled', 'yes'),
('files_videoviewer', 'installed_version', '0.1.1'),
('files_videoviewer', 'enabled', 'yes'),
('files_pdfviewer', 'installed_version', '0.2'),
('files_pdfviewer', 'enabled', 'yes'),
('search_lucene', 'installed_version', '0.5.0'),
('search_lucene', 'types', 'filesystem'),
('search_lucene', 'enabled', 'yes'),
('files', 'installed_version', '1.1.7'),
('core', 'remote_files', 'files/appinfo/remote.php'),
('core', 'remote_webdav', 'files/appinfo/remote.php'),
('core', 'remote_filesync', 'files/appinfo/filesync.php'),
('files', 'types', 'filesystem'),
('files', 'enabled', 'yes'),
('firstrunwizard', 'installed_version', '1.0'),
('firstrunwizard', 'enabled', 'yes'),
('gallery', 'installed_version', '0.5.2'),
('core', 'public_gallery', 'gallery/sharing.php'),
('gallery', 'types', 'filesystem'),
('gallery', 'enabled', 'yes'),
('contacts', 'installed_version', '0.2.5'),
('core', 'remote_contacts', 'contacts/appinfo/remote.php'),
('core', 'remote_carddav', 'contacts/appinfo/remote.php'),
('core', 'remote_contactthumbnail', 'contacts/thumbnail.php'),
('contacts', 'enabled', 'yes'),
('core', 'backgroundjobs_task', ''),
('core', 'global_cache_gc_lastrun', '1379061313'),
('core', 'backgroundjobs_step', 'regular_tasks'),
('envole_cas', 'installed_version', '0.1.1'),
('envole_cas', 'types', 'prelogin,authentication'),
('envole_cas', 'enabled', 'yes');

-- --------------------------------------------------------

--
-- Structure de la table `oc_clndr_calendars`
--

CREATE TABLE IF NOT EXISTS `oc_clndr_calendars` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` varchar(255) DEFAULT NULL,
  `displayname` varchar(100) DEFAULT NULL,
  `uri` varchar(255) DEFAULT NULL,
  `active` int(11) NOT NULL DEFAULT '1',
  `ctag` int(10) unsigned NOT NULL DEFAULT '0',
  `calendarorder` int(10) unsigned NOT NULL DEFAULT '0',
  `calendarcolor` varchar(10) DEFAULT NULL,
  `timezone` longtext,
  `components` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `oc_clndr_calendars`
--


-- --------------------------------------------------------

--
-- Structure de la table `oc_clndr_objects`
--

CREATE TABLE IF NOT EXISTS `oc_clndr_objects` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `calendarid` int(10) unsigned NOT NULL DEFAULT '0',
  `objecttype` varchar(40) NOT NULL DEFAULT ' ',
  `startdate` datetime DEFAULT '1970-01-01 00:00:00',
  `enddate` datetime DEFAULT '1970-01-01 00:00:00',
  `repeating` int(11) DEFAULT NULL,
  `summary` varchar(255) DEFAULT NULL,
  `calendardata` longtext,
  `uri` varchar(255) DEFAULT NULL,
  `lastmodified` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `oc_clndr_objects`
--


-- --------------------------------------------------------

--
-- Structure de la table `oc_clndr_repeat`
--

CREATE TABLE IF NOT EXISTS `oc_clndr_repeat` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `eventid` int(10) unsigned NOT NULL DEFAULT '0',
  `calid` int(10) unsigned NOT NULL DEFAULT '0',
  `startdate` datetime DEFAULT '1970-01-01 00:00:00',
  `enddate` datetime DEFAULT '1970-01-01 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `oc_clndr_repeat`
--


-- --------------------------------------------------------

--
-- Structure de la table `oc_clndr_share_calendar`
--

CREATE TABLE IF NOT EXISTS `oc_clndr_share_calendar` (
  `owner` varchar(255) NOT NULL DEFAULT ' ',
  `share` varchar(255) NOT NULL DEFAULT ' ',
  `sharetype` varchar(6) NOT NULL DEFAULT ' ',
  `calendarid` bigint(20) unsigned NOT NULL DEFAULT '0',
  `permissions` tinyint(4) NOT NULL DEFAULT '0',
  `active` int(11) NOT NULL DEFAULT '1'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Contenu de la table `oc_clndr_share_calendar`
--


-- --------------------------------------------------------

--
-- Structure de la table `oc_clndr_share_event`
--

CREATE TABLE IF NOT EXISTS `oc_clndr_share_event` (
  `owner` varchar(255) NOT NULL DEFAULT ' ',
  `share` varchar(255) NOT NULL DEFAULT ' ',
  `sharetype` varchar(6) NOT NULL DEFAULT ' ',
  `eventid` bigint(20) unsigned NOT NULL DEFAULT '0',
  `permissions` tinyint(4) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Contenu de la table `oc_clndr_share_event`
--


-- --------------------------------------------------------

--
-- Structure de la table `oc_contacts_addressbooks`
--

CREATE TABLE IF NOT EXISTS `oc_contacts_addressbooks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` varchar(255) NOT NULL DEFAULT ' ',
  `displayname` varchar(255) DEFAULT NULL,
  `uri` varchar(200) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `ctag` int(10) unsigned NOT NULL DEFAULT '1',
  `active` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Contenu de la table `oc_contacts_addressbooks`
--

INSERT INTO `oc_contacts_addressbooks` (`id`, `userid`, `displayname`, `uri`, `description`, `ctag`, `active`) VALUES
(1, 'admin', 'Contacts', 'contacts', 'Default Address Book', 1, 1);

-- --------------------------------------------------------

--
-- Structure de la table `oc_contacts_cards`
--

CREATE TABLE IF NOT EXISTS `oc_contacts_cards` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `addressbookid` int(10) unsigned NOT NULL DEFAULT '0',
  `fullname` varchar(255) DEFAULT NULL,
  `carddata` longtext,
  `uri` varchar(200) DEFAULT NULL,
  `lastmodified` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `oc_contacts_cards`
--


-- --------------------------------------------------------

--
-- Structure de la table `oc_contacts_cards_properties`
--

CREATE TABLE IF NOT EXISTS `oc_contacts_cards_properties` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` varchar(255) NOT NULL DEFAULT ' ',
  `contactid` int(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(64) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  `preferred` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `cp_name_index` (`name`),
  KEY `cp_value_index` (`value`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `oc_contacts_cards_properties`
--


-- --------------------------------------------------------

--
-- Structure de la table `oc_filecache`
--

CREATE TABLE IF NOT EXISTS `oc_filecache` (
  `fileid` int(11) NOT NULL AUTO_INCREMENT,
  `storage` int(11) NOT NULL DEFAULT '0',
  `path` varchar(512) DEFAULT NULL,
  `path_hash` varchar(32) NOT NULL DEFAULT ' ',
  `parent` int(11) NOT NULL DEFAULT '0',
  `name` varchar(250) DEFAULT NULL,
  `mimetype` int(11) NOT NULL DEFAULT '0',
  `mimepart` int(11) NOT NULL DEFAULT '0',
  `size` bigint(20) NOT NULL DEFAULT '0',
  `mtime` int(11) NOT NULL DEFAULT '0',
  `encrypted` int(11) NOT NULL DEFAULT '0',
  `unencrypted_size` bigint(20) NOT NULL DEFAULT '0',
  `etag` varchar(40) NOT NULL DEFAULT ' ',
  PRIMARY KEY (`fileid`),
  UNIQUE KEY `fs_storage_path_hash` (`storage`,`path_hash`),
  KEY `fs_parent_name_hash` (`parent`,`name`),
  KEY `fs_storage_mimetype` (`storage`,`mimetype`),
  KEY `fs_storage_mimepart` (`storage`,`mimepart`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=20 ;

--
-- Contenu de la table `oc_filecache`
--

INSERT INTO `oc_filecache` (`fileid`, `storage`, `path`, `path_hash`, `parent`, `name`, `mimetype`, `mimepart`, `size`, `mtime`, `encrypted`, `unencrypted_size`, `etag`) VALUES
(1, 1, '', 'd41d8cd98f00b204e9800998ecf8427e', -1, '', 2, 1, 4658, 1374503404, 0, 0, '51ed4b0fa29a5'),
(2, 1, 'files', '45b963397aa40d4a0063e0d85e4fe7a1', 1, 'files', 2, 1, 0, 1374503404, 0, 0, '51ed4b0fa34cf'),
(3, 1, 'files_trashbin', 'fb66dca5f27af6f15c1d1d81e6f8d28b', 1, 'files_trashbin', 2, 1, 0, 1374503404, 0, 0, '51ed4b0fa2e06'),
(4, 1, 'cache', '0fea6a13c52b4d4725368f24b045ca84', 1, 'cache', 2, 1, 0, 1374498087, 0, 0, '51ed4b0fa3073'),
(5, 1, 'lucene_index', 'a0c55384eae17768d8f9fe6696efed6e', 1, 'lucene_index', 2, 1, 518, 1374498624, 0, 0, '51ed4b0fa32ab'),
(6, 1, 'gallery', '2767cc3ede7592a47bd6657e3799565c', 1, 'gallery', 2, 1, 4140, 1374498317, 0, 0, '51ed4b0fa36ca'),
(7, 1, 'files_trashbin/versions', 'c639d144d3f1014051e14a98beac5705', 3, 'versions', 2, 1, 0, 1374503404, 0, 0, '51ed4b0fa3c3e'),
(8, 1, 'files_trashbin/share-keys', 'efadb182f5229706b54ec20d20e8c46d', 3, 'share-keys', 2, 1, 0, 1374503404, 0, 0, '51ed4b0fa415e'),
(9, 1, 'files_trashbin/keyfiles', '728c7d8454e585e21166e28b78be8546', 3, 'keyfiles', 2, 1, 0, 1374503404, 0, 0, '51ed4b0fa4603'),
(10, 1, 'files_trashbin/files', '3014a771cbe30761f2e9ff3272110dbf', 3, 'files', 2, 1, 0, 1374503433, 0, 0, '51ed4b0fa4aa0'),
(11, 1, 'lucene_index/segments_2', '4e3d9a206e2c8b034c154f013e48a613', 5, 'segments_2', 4, 3, 41, 1374498624, 0, 0, '51ed4b0fb3d29'),
(12, 1, 'lucene_index/_0.cfs', 'ee7432dc785031929af88f48070d0f4f', 5, '_0.cfs', 4, 3, 457, 1374498624, 0, 0, '51ed4b0fb6632'),
(13, 1, 'lucene_index/segments.gen', 'b4533f6e69cc5dcf734c3f111628fc42', 5, 'segments.gen', 4, 3, 20, 1374498624, 0, 0, '51ed4b0fb8548'),
(14, 1, 'lucene_index/optimization.lock.file', '2a82e92faf84809712711c9a0692ca45', 5, 'optimization.lock.file', 5, 3, 0, 1374498624, 0, 0, '51ed4b0fb89e4'),
(15, 1, 'lucene_index/read.lock.file', 'c552a6ffa233ac764087f9e77dca4376', 5, 'read.lock.file', 5, 3, 0, 1374498624, 0, 0, '51ed4b0fb8d73'),
(16, 1, 'lucene_index/write.lock.file', '8133cd3935de55cc850d33ecc907a769', 5, 'write.lock.file', 5, 3, 0, 1374498624, 0, 0, '51ed4b0fb900d'),
(17, 1, 'lucene_index/read-lock-processing.lock.file', '3158d330efbfaf1c0bd82562636e283c', 5, 'read-lock-processing.lock.file', 5, 3, 0, 1374498624, 0, 0, '51ed4b0fb92a8'),
(18, 1, 'gallery/admin', '58b82cc33170329a9a4cc93ed2036166', 6, 'admin', 2, 1, 4140, 1374498317, 0, 0, '51ed4b0fb9ac1'),
(19, 1, 'gallery/admin/Sans-titre-1.jpg', 'e636d054f500f31309e06d84606666a4', 18, 'Sans-titre-1.jpg', 7, 6, 4140, 1374498317, 0, 0, '51ed4b0fbd210');

-- --------------------------------------------------------

--
-- Structure de la table `oc_files_trash`
--

CREATE TABLE IF NOT EXISTS `oc_files_trash` (
  `id` varchar(250) NOT NULL DEFAULT ' ',
  `user` varchar(64) NOT NULL DEFAULT ' ',
  `timestamp` varchar(12) NOT NULL DEFAULT ' ',
  `location` varchar(512) NOT NULL DEFAULT ' ',
  `type` varchar(4) NOT NULL DEFAULT ' ',
  `mime` varchar(30) NOT NULL DEFAULT ' ',
  KEY `id_index` (`id`),
  KEY `timestamp_index` (`timestamp`),
  KEY `user_index` (`user`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Contenu de la table `oc_files_trash`
--


-- --------------------------------------------------------

--
-- Structure de la table `oc_files_trashsize`
--

CREATE TABLE IF NOT EXISTS `oc_files_trashsize` (
  `user` varchar(64) NOT NULL DEFAULT ' ',
  `size` varchar(50) NOT NULL DEFAULT ' '
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Contenu de la table `oc_files_trashsize`
--


-- --------------------------------------------------------

--
-- Structure de la table `oc_files_versions`
--

CREATE TABLE IF NOT EXISTS `oc_files_versions` (
  `user` varchar(64) NOT NULL DEFAULT ' ',
  `size` varchar(50) NOT NULL DEFAULT ' '
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Contenu de la table `oc_files_versions`
--


-- --------------------------------------------------------

--
-- Structure de la table `oc_file_map`
--

CREATE TABLE IF NOT EXISTS `oc_file_map` (
  `logic_path` varchar(512) NOT NULL DEFAULT ' ',
  `logic_path_hash` varchar(32) NOT NULL DEFAULT ' ',
  `physic_path` varchar(512) NOT NULL DEFAULT ' ',
  `physic_path_hash` varchar(32) NOT NULL DEFAULT ' ',
  UNIQUE KEY `file_map_lp_index` (`logic_path_hash`),
  UNIQUE KEY `file_map_pp_index` (`physic_path_hash`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Contenu de la table `oc_file_map`
--


-- --------------------------------------------------------

--
-- Structure de la table `oc_gallery_sharing`
--

CREATE TABLE IF NOT EXISTS `oc_gallery_sharing` (
  `token` varchar(64) NOT NULL DEFAULT ' ',
  `gallery_id` int(11) NOT NULL DEFAULT '0',
  `recursive` tinyint(4) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Contenu de la table `oc_gallery_sharing`
--


-- --------------------------------------------------------

--
-- Structure de la table `oc_groups`
--

CREATE TABLE IF NOT EXISTS `oc_groups` (
  `gid` varchar(64) NOT NULL DEFAULT ' ',
  PRIMARY KEY (`gid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Contenu de la table `oc_groups`
--

INSERT INTO `oc_groups` (`gid`) VALUES
('admin');

-- --------------------------------------------------------

--
-- Structure de la table `oc_group_admin`
--

CREATE TABLE IF NOT EXISTS `oc_group_admin` (
  `gid` varchar(64) NOT NULL DEFAULT ' ',
  `uid` varchar(64) NOT NULL DEFAULT ' ',
  KEY `group_admin_uid` (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Contenu de la table `oc_group_admin`
--


-- --------------------------------------------------------

--
-- Structure de la table `oc_group_user`
--

CREATE TABLE IF NOT EXISTS `oc_group_user` (
  `gid` varchar(64) NOT NULL DEFAULT ' ',
  `uid` varchar(64) NOT NULL DEFAULT ' '
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Contenu de la table `oc_group_user`
--

INSERT INTO `oc_group_user` (`gid`, `uid`) VALUES
('admin', 'admin');

-- --------------------------------------------------------

--
-- Structure de la table `oc_locks`
--

CREATE TABLE IF NOT EXISTS `oc_locks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` varchar(64) DEFAULT NULL,
  `owner` varchar(100) DEFAULT NULL,
  `timeout` int(10) unsigned DEFAULT '0',
  `created` bigint(20) DEFAULT '0',
  `token` varchar(100) DEFAULT NULL,
  `scope` tinyint(4) DEFAULT '0',
  `depth` tinyint(4) DEFAULT '0',
  `uri` longtext,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `oc_locks`
--


-- --------------------------------------------------------

--
-- Structure de la table `oc_lucene_status`
--

CREATE TABLE IF NOT EXISTS `oc_lucene_status` (
  `fileid` int(11) NOT NULL DEFAULT '0',
  `status` varchar(1) DEFAULT NULL,
  KEY `status_index` (`status`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Contenu de la table `oc_lucene_status`
--


-- --------------------------------------------------------

--
-- Structure de la table `oc_media_albums`
--

CREATE TABLE IF NOT EXISTS `oc_media_albums` (
  `album_id` int(11) NOT NULL AUTO_INCREMENT,
  `album_name` varchar(200) NOT NULL DEFAULT ' ',
  `album_artist` int(11) NOT NULL DEFAULT '0',
  `album_art` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`album_id`),
  KEY `album_name_index` (`album_name`),
  KEY `album_artist_index` (`album_artist`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `oc_media_albums`
--


-- --------------------------------------------------------

--
-- Structure de la table `oc_media_artists`
--

CREATE TABLE IF NOT EXISTS `oc_media_artists` (
  `artist_id` int(11) NOT NULL AUTO_INCREMENT,
  `artist_name` varchar(200) NOT NULL DEFAULT ' ',
  PRIMARY KEY (`artist_id`),
  UNIQUE KEY `artist_name` (`artist_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `oc_media_artists`
--


-- --------------------------------------------------------

--
-- Structure de la table `oc_media_sessions`
--

CREATE TABLE IF NOT EXISTS `oc_media_sessions` (
  `session_id` int(11) NOT NULL AUTO_INCREMENT,
  `token` varchar(64) NOT NULL DEFAULT ' ',
  `user_id` varchar(64) NOT NULL DEFAULT ' ',
  `start` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  PRIMARY KEY (`session_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `oc_media_sessions`
--


-- --------------------------------------------------------

--
-- Structure de la table `oc_media_songs`
--

CREATE TABLE IF NOT EXISTS `oc_media_songs` (
  `song_id` int(11) NOT NULL AUTO_INCREMENT,
  `song_name` varchar(200) NOT NULL DEFAULT ' ',
  `song_artist` int(11) NOT NULL DEFAULT '0',
  `song_album` int(11) NOT NULL DEFAULT '0',
  `song_path` varchar(200) NOT NULL DEFAULT ' ',
  `song_user` varchar(64) NOT NULL DEFAULT '0',
  `song_length` int(11) NOT NULL DEFAULT '0',
  `song_track` int(11) NOT NULL DEFAULT '0',
  `song_size` int(11) NOT NULL DEFAULT '0',
  `song_playcount` int(11) NOT NULL DEFAULT '0',
  `song_lastplayed` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`song_id`),
  KEY `song_album_index` (`song_album`),
  KEY `song_artist_index` (`song_artist`),
  KEY `song_name_index` (`song_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `oc_media_songs`
--


-- --------------------------------------------------------

--
-- Structure de la table `oc_media_users`
--

CREATE TABLE IF NOT EXISTS `oc_media_users` (
  `user_id` varchar(64) NOT NULL DEFAULT '0',
  `user_password_sha256` varchar(64) NOT NULL DEFAULT ' '
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Contenu de la table `oc_media_users`
--


-- --------------------------------------------------------

--
-- Structure de la table `oc_mimetypes`
--

CREATE TABLE IF NOT EXISTS `oc_mimetypes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `mimetype` varchar(255) NOT NULL DEFAULT ' ',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mimetype_id_index` (`mimetype`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=8 ;

--
-- Contenu de la table `oc_mimetypes`
--

INSERT INTO `oc_mimetypes` (`id`, `mimetype`) VALUES
(1, 'httpd'),
(2, 'httpd/unix-directory'),
(3, 'application'),
(4, 'application/octet-stream'),
(5, 'application/x-empty'),
(6, 'image'),
(7, 'image/jpeg');

-- --------------------------------------------------------

--
-- Structure de la table `oc_permissions`
--

CREATE TABLE IF NOT EXISTS `oc_permissions` (
  `fileid` int(11) NOT NULL DEFAULT '0',
  `user` varchar(64) NOT NULL DEFAULT ' ',
  `permissions` int(11) NOT NULL DEFAULT '0',
  UNIQUE KEY `id_user_index` (`fileid`,`user`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Contenu de la table `oc_permissions`
--

INSERT INTO `oc_permissions` (`fileid`, `user`, `permissions`) VALUES
(2, 'admin', 31);

-- --------------------------------------------------------

--
-- Structure de la table `oc_pictures_images_cache`
--

CREATE TABLE IF NOT EXISTS `oc_pictures_images_cache` (
  `uid_owner` varchar(64) NOT NULL DEFAULT ' ',
  `path` varchar(256) NOT NULL DEFAULT ' ',
  `width` int(11) NOT NULL DEFAULT '0',
  `height` int(11) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Contenu de la table `oc_pictures_images_cache`
--


-- --------------------------------------------------------

--
-- Structure de la table `oc_preferences`
--

CREATE TABLE IF NOT EXISTS `oc_preferences` (
  `userid` varchar(64) NOT NULL DEFAULT ' ',
  `appid` varchar(32) NOT NULL DEFAULT ' ',
  `configkey` varchar(64) NOT NULL DEFAULT ' ',
  `configvalue` longtext,
  KEY `pref_userid_appid_key_index` (`userid`,`appid`,`configkey`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Contenu de la table `oc_preferences`
--

INSERT INTO `oc_preferences` (`userid`, `appid`, `configkey`, `configvalue`) VALUES
('admin', 'firstrunwizard', 'show', '0'),
('admin', 'files', 'cache_version', '5');

-- --------------------------------------------------------

--
-- Structure de la table `oc_properties`
--

CREATE TABLE IF NOT EXISTS `oc_properties` (
  `userid` varchar(64) NOT NULL DEFAULT ' ',
  `propertypath` varchar(255) NOT NULL DEFAULT ' ',
  `propertyname` varchar(255) NOT NULL DEFAULT ' ',
  `propertyvalue` varchar(255) NOT NULL DEFAULT ' ',
  KEY `property_index` (`userid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Contenu de la table `oc_properties`
--


-- --------------------------------------------------------

--
-- Structure de la table `oc_queuedtasks`
--

CREATE TABLE IF NOT EXISTS `oc_queuedtasks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `app` varchar(255) NOT NULL DEFAULT ' ',
  `klass` varchar(255) NOT NULL DEFAULT ' ',
  `method` varchar(255) NOT NULL DEFAULT ' ',
  `parameters` varchar(255) NOT NULL DEFAULT ' ',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `oc_queuedtasks`
--


-- --------------------------------------------------------

--
-- Structure de la table `oc_share`
--

CREATE TABLE IF NOT EXISTS `oc_share` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `share_type` tinyint(4) NOT NULL DEFAULT '0',
  `share_with` varchar(255) DEFAULT NULL,
  `uid_owner` varchar(255) NOT NULL DEFAULT ' ',
  `parent` int(11) DEFAULT '0',
  `item_type` varchar(64) NOT NULL DEFAULT ' ',
  `item_source` varchar(255) DEFAULT NULL,
  `item_target` varchar(255) DEFAULT NULL,
  `file_source` int(11) DEFAULT '0',
  `file_target` varchar(512) DEFAULT NULL,
  `permissions` tinyint(4) NOT NULL DEFAULT '0',
  `stime` bigint(20) NOT NULL DEFAULT '0',
  `accepted` tinyint(4) NOT NULL DEFAULT '0',
  `expiration` datetime DEFAULT NULL,
  `token` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `token_index` (`token`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `oc_share`
--


-- --------------------------------------------------------

--
-- Structure de la table `oc_storages`
--

CREATE TABLE IF NOT EXISTS `oc_storages` (
  `id` varchar(64) DEFAULT NULL,
  `numeric_id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`numeric_id`),
  UNIQUE KEY `storages_id_index` (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Contenu de la table `oc_storages`
--

INSERT INTO `oc_storages` (`id`, `numeric_id`) VALUES
('local::/var/www/html/owncloud/data/admin/', 1);

-- --------------------------------------------------------

--
-- Structure de la table `oc_users`
--

CREATE TABLE IF NOT EXISTS `oc_users` (
  `uid` varchar(64) NOT NULL DEFAULT ' ',
  `displayname` varchar(64) DEFAULT NULL,
  `password` varchar(255) NOT NULL DEFAULT ' ',
  PRIMARY KEY (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


-- --------------------------------------------------------

--
-- Structure de la table `oc_vcategory`
--

CREATE TABLE IF NOT EXISTS `oc_vcategory` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uid` varchar(64) NOT NULL DEFAULT ' ',
  `type` varchar(64) NOT NULL DEFAULT ' ',
  `category` varchar(255) NOT NULL DEFAULT ' ',
  PRIMARY KEY (`id`),
  KEY `uid_index` (`uid`),
  KEY `type_index` (`type`),
  KEY `category_index` (`category`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Contenu de la table `oc_vcategory`
--


-- --------------------------------------------------------

--
-- Structure de la table `oc_vcategory_to_object`
--

CREATE TABLE IF NOT EXISTS `oc_vcategory_to_object` (
  `objid` int(10) unsigned NOT NULL DEFAULT '0',
  `categoryid` int(10) unsigned NOT NULL DEFAULT '0',
  `type` varchar(64) NOT NULL DEFAULT ' ',
  PRIMARY KEY (`categoryid`,`objid`,`type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Contenu de la table `oc_vcategory_to_object`
--

