\r owncloud
SET character_set_client = utf8;

-- Suppression des doublons
DROP PROCEDURE IF EXISTS PurgeDoublon;
DELIMITER |
CREATE PROCEDURE PurgeDoublon()
BEGIN
	/* Suppression doublon appconfig */
	DROP TABLE IF EXISTS temptable;
	CREATE TABLE  `owncloud`.`temptable` (
		`appid` VARCHAR( 32 ) COLLATE utf8_bin NOT NULL DEFAULT  ' ',
		`configkey` VARCHAR( 64 ) COLLATE utf8_bin NOT NULL DEFAULT  ' ',
		`configvalue` LONGTEXT COLLATE utf8_bin,
		
		KEY  `appconfig_appid_key_index` (`appid`,`configkey`),
		KEY  `appconfig_config_key_index` ( `configkey` )
	) ENGINE = INNODB DEFAULT CHARSET = utf8 COLLATE = utf8_bin;


	INSERT INTO temptable (appid,configkey,configvalue)
	SELECT appid,configkey,configvalue FROM oc_appconfig GROUP BY appid,configkey	;
	
	DROP TABLE oc_appconfig;
	
	RENAME TABLE temptable TO  oc_appconfig ;
	
	/* Suppression doublon preference */
	DROP TABLE IF EXISTS temptable;
	CREATE TABLE  `owncloud`.`temptable` (
		`userid` VARCHAR( 64 ) COLLATE utf8_bin NOT NULL DEFAULT  ' ',
		`appid` VARCHAR( 32 ) COLLATE utf8_bin NOT NULL DEFAULT  ' ',
		`configkey` VARCHAR( 64 ) COLLATE utf8_bin NOT NULL DEFAULT  ' ',
		`configvalue` LONGTEXT COLLATE utf8_bin,
		
		KEY  `pref_userid_appid_key_index` (  `userid` ,  `appid` ,  `configkey` )
	) ENGINE = MYISAM DEFAULT CHARSET = utf8 COLLATE = utf8_bin;

	INSERT INTO temptable (userid,appid,configkey,configvalue)
	SELECT userid,appid,configkey,configvalue FROM oc_preferences GROUP BY userid,appid,configkey	;
	DROP TABLE oc_preferences;
	RENAME TABLE temptable TO  oc_preferences ;
	
	/* Suppression doublon preference */
	DROP TABLE IF EXISTS temptable;
	CREATE TABLE  `owncloud`.`temptable` (
		`userid` VARCHAR( 64 ) COLLATE utf8_bin NOT NULL DEFAULT  ' ',
		`appid` VARCHAR( 32 ) COLLATE utf8_bin NOT NULL DEFAULT  ' ',
		`configkey` VARCHAR( 64 ) COLLATE utf8_bin NOT NULL DEFAULT  ' ',
		`configvalue` LONGTEXT COLLATE utf8_bin,
		
		KEY  `pref_userid_appid_key_index` (  `userid` ,  `appid` ,  `configkey` )
	) ENGINE = MYISAM DEFAULT CHARSET = utf8 COLLATE = utf8_bin;

	INSERT INTO temptable (userid,appid,configkey,configvalue)
	SELECT userid,appid,configkey,configvalue FROM oc_preferences GROUP BY userid,appid,configkey	;
	DROP TABLE oc_preferences;
	RENAME TABLE temptable TO  oc_preferences ;
	
	/* Suppression doublon oc_lucene_status */
	CREATE TABLE  `owncloud`.`temptable` (
		`fileid` INT( 11 ) NOT NULL DEFAULT  '0',
		`status` VARCHAR( 1 ) COLLATE utf8_bin DEFAULT NULL ,
		KEY  `status_index` (  `status` )
	) ENGINE = MYISAM DEFAULT CHARSET = utf8 COLLATE = utf8_bin;

	INSERT INTO temptable (fileid,status)
	SELECT fileid,status FROM oc_lucene_status GROUP BY fileid;
	DROP TABLE oc_lucene_status;
	RENAME TABLE temptable TO  oc_lucene_status ;
	
END|
DELIMITER ;
CALL PurgeDoublon();
DROP PROCEDURE IF EXISTS PurgeDoublon;


-- Création du parametrage LDAP
DELETE FROM oc_appconfig WHERE appid='user_ldap';

%if %%is_defined("ldap_reader_passfile")
INSERT INTO `oc_appconfig` (`appid`, `configkey`, `configvalue`) VALUES
('user_ldap', 'enabled', 'yes'),
('user_ldap', 'ldap_host', '%%adresse_ip_ldap'),
('user_ldap', 'ldap_port', '%%ldap_port'),

('user_ldap', 'ldap_dn', '%%ldap_reader'),
('user_ldap', 'ldap_agent_password', '%%pwdreader("base64",%%ldap_reader_passfile)'),

('user_ldap', 'ldap_base', '%%ldap_base_dn'),
('user_ldap', 'ldap_base_groups', '%%ldap_base_dn'),
('user_ldap', 'ldap_base_users', '%%ldap_base_dn'),


('user_ldap', 'ldap_login_filter', '(&(|(objectclass=inetOrgPerson))(uid=%uid))'),
('user_ldap', 'ldap_userlist_filter', '(|(objectclass=inetOrgPerson))'),
('user_ldap', 'ldap_userfilter_objectclass', 'inetOrgPerson'),

('user_ldap', 'ldap_group_filter', '(&(|(objectclass=posixGroup)))'),
('user_ldap', 'ldap_groupfilter_objectclass', 'posixGroup'),
('user_ldap', 'ldap_group_member_assoc_attribute', 'memberUid'),

('user_ldap', 'ldap_display_name', '%%ldap_fill_displayname'),
('user_ldap', 'ldap_email_attr', '%%ldap_fill_mail'),
('user_ldap', 'ldap_group_display_name', '%%ldap_fill_displaygroup'),
('user_ldap', 'ldap_expert_uuid_user_attr', 'uid'),

('user_ldap', 'has_memberof_filter_support', ''),
('user_ldap', 'home_folder_naming_rule', ''),
('user_ldap', 'installed_version', '0.4.3'),
('user_ldap', 'last_jpegPhoto_lookup', '0'),
('user_ldap', 'ldap_attributes_for_group_search', ''),
('user_ldap', 'ldap_attributes_for_user_search', ''),
('user_ldap', 'ldap_backup_host', ''),
('user_ldap', 'ldap_backup_port', ''),
('user_ldap', 'ldap_cache_ttl', '600'),
('user_ldap', 'ldap_configuration_active', '1'),
('user_ldap', 'ldap_expert_username_attr', ''),
('user_ldap', 'ldap_expert_uuid_group_attr', ''),
('user_ldap', 'ldap_group_filter_mode', '0'),
('user_ldap', 'ldap_groupfilter_groups', ''),
('user_ldap', 'ldap_login_filter_mode', '0'),
('user_ldap', 'ldap_loginfilter_attributes', ''),
('user_ldap', 'ldap_loginfilter_email', '0'),
('user_ldap', 'ldap_loginfilter_username', '1'),
('user_ldap', 'ldap_nested_groups', '0'),
('user_ldap', 'ldap_nocase', '0'),
('user_ldap', 'ldap_override_main_server', '0'),
('user_ldap', 'ldap_paging_size', '500'),
('user_ldap', 'ldap_quota_attr', ''),
('user_ldap', 'ldap_quota_def', ''),
('user_ldap', 'ldap_tls', '0'),
('user_ldap', 'ldap_turn_off_cert_check', '0'),
('user_ldap', 'ldap_user_filter_mode', '1'),
('user_ldap', 'ldap_userfilter_groups', ''),
('user_ldap', 'ocsid', '166061'),
('user_ldap', 'types', 'authentication');

/* Paramétrage LDAP 2.3 */
%else
INSERT INTO `oc_appconfig` (`appid`, `configkey`, `configvalue`) VALUES
('user_ldap', 'enabled', 'yes'),
%if(%%eolesso_ldap[0] in ("localhost","127.0.0.1"))
('user_ldap', 'ldap_host', '%%adresse_ip_ldap'),
%else
('user_ldap', 'ldap_host', '%%eolesso_ldap[0]'),
%end if
('user_ldap', 'ldap_port', '389'),

('user_ldap', 'ldap_dn', '%%eolesso_ldap[0].eolesso_ldap_reader'),
('user_ldap', 'ldap_agent_password', '%%pwdreader("base64",%%eolesso_ldap[0].eolesso_ldap_reader_passfile)'),

('user_ldap', 'ldap_base', '%%eolesso_ldap[0].eolesso_base_ldap'),
('user_ldap', 'ldap_base_groups', '%%eolesso_ldap[0].eolesso_base_ldap'),
('user_ldap', 'ldap_base_users', '%%eolesso_ldap[0].eolesso_base_ldap'),


('user_ldap', 'ldap_login_filter', '(&(|(objectclass=inetOrgPerson))(uid=%uid))'),
('user_ldap', 'ldap_userlist_filter', '(|(objectclass=inetOrgPerson))'),
('user_ldap', 'ldap_userfilter_objectclass', 'inetOrgPerson'),

('user_ldap', 'ldap_group_filter', '(&(|(objectclass=posixGroup)))'),
('user_ldap', 'ldap_groupfilter_objectclass', 'posixGroup'),
('user_ldap', 'ldap_group_member_assoc_attribute', 'memberUid'),

('user_ldap', 'ldap_display_name', '%%eolesso_ldap[0].eolesso_ldap_fill_displayname'),
('user_ldap', 'ldap_email_attr', '%%eolesso_ldap[0].eolesso_ldap_fill_mail'),
('user_ldap', 'ldap_group_display_name', '%%eolesso_ldap[0].eolesso_ldap_fill_displaygroup'),
('user_ldap', 'ldap_expert_uuid_user_attr', 'uid'),

('user_ldap', 'has_memberof_filter_support', ''),
('user_ldap', 'home_folder_naming_rule', ''),
('user_ldap', 'installed_version', '0.4.3'),
('user_ldap', 'last_jpegPhoto_lookup', '0'),
('user_ldap', 'ldap_attributes_for_group_search', ''),
('user_ldap', 'ldap_attributes_for_user_search', ''),
('user_ldap', 'ldap_backup_host', ''),
('user_ldap', 'ldap_backup_port', ''),
('user_ldap', 'ldap_cache_ttl', '600'),
('user_ldap', 'ldap_configuration_active', '1'),
('user_ldap', 'ldap_expert_username_attr', ''),
('user_ldap', 'ldap_expert_uuid_group_attr', ''),
('user_ldap', 'ldap_group_filter_mode', '0'),
('user_ldap', 'ldap_groupfilter_groups', ''),
('user_ldap', 'ldap_login_filter_mode', '0'),
('user_ldap', 'ldap_loginfilter_attributes', ''),
('user_ldap', 'ldap_loginfilter_email', '0'),
('user_ldap', 'ldap_loginfilter_username', '1'),
('user_ldap', 'ldap_nested_groups', '0'),
('user_ldap', 'ldap_nocase', '0'),
('user_ldap', 'ldap_override_main_server', '0'),
('user_ldap', 'ldap_paging_size', '500'),
('user_ldap', 'ldap_quota_attr', ''),
('user_ldap', 'ldap_quota_def', ''),
('user_ldap', 'ldap_tls', '0'),
('user_ldap', 'ldap_turn_off_cert_check', '0'),
('user_ldap', 'ldap_user_filter_mode', '1'),
('user_ldap', 'ldap_userfilter_groups', ''),
('user_ldap', 'ocsid', '166061'),
('user_ldap', 'types', 'authentication');
%end if

-- Activation Application envole_cas
DELETE FROM oc_appconfig WHERE appid='envole_cas';
INSERT INTO `oc_appconfig` (`appid`, `configkey`, `configvalue`) VALUES
('envole_cas', 'enabled', 'yes'),
('envole_cas', 'installed_version', '0.1.1'),
('envole_cas', 'types', 'prelogin,authentication');



-- Activation Application calendar
DELETE FROM oc_appconfig WHERE appid='calendar';
INSERT INTO `oc_appconfig` (`appid`, `configkey`, `configvalue`) VALUES
('calendar', 'enabled', 'yes'),
('calendar', 'installed_version', '0.6.4'),
('calendar', 'ocsid', '166043');



-- Activation Application documents
DELETE FROM oc_appconfig WHERE appid='documents';
INSERT INTO `oc_appconfig` (`appid`, `configkey`, `configvalue`) VALUES
('documents', 'enabled', 'yes'),
('documents', 'installed_version', '0.8.2'),
('documents', 'ocsid', '166045'),
('documents', 'types', '');


-- Désactivation de l'application Contacts
UPDATE oc_appconfig SET configvalue='no' WHERE appid='contacts' AND  configkey='enabled';


-- Activation de la notification par email
DELETE FROM oc_appconfig WHERE appid='core' AND  configkey='shareapi_allow_mail_notification';
INSERT IGNORE INTO oc_appconfig (`appid`, `configkey`, `configvalue`) VALUES
('core','shareapi_allow_mail_notification','yes');


-- Creation des tables LDAP
CREATE TABLE IF NOT EXISTS `oc_ldap_group_mapping` (
  `ldap_dn` varchar(255) COLLATE utf8_bin NOT NULL DEFAULT '',
  `owncloud_name` varchar(255) COLLATE utf8_bin NOT NULL DEFAULT '',
  `directory_uuid` varchar(255) COLLATE utf8_bin NOT NULL DEFAULT '',
  PRIMARY KEY (`ldap_dn`),
  UNIQUE KEY `owncloud_name_groups` (`owncloud_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

CREATE TABLE IF NOT EXISTS `oc_ldap_group_members` (
  `owncloudname` varchar(255) COLLATE utf8_bin NOT NULL DEFAULT '',
  `owncloudusers` longtext COLLATE utf8_bin NOT NULL,
  PRIMARY KEY (`owncloudname`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

CREATE TABLE IF NOT EXISTS `oc_ldap_user_mapping` (
  `ldap_dn` varchar(255) COLLATE utf8_bin NOT NULL DEFAULT '',
  `owncloud_name` varchar(255) COLLATE utf8_bin NOT NULL DEFAULT '',
  `directory_uuid` varchar(255) COLLATE utf8_bin NOT NULL DEFAULT '',
  PRIMARY KEY (`owncloud_name`),
  UNIQUE KEY `ldap_dn_users` (`ldap_dn`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;



-- Creation table EnvoleCDT
CREATE TABLE IF NOT EXISTS `oc_clndr_envolecdt` (
  `idowncloud` int(11) NOT NULL,
  `login` varchar(50) NOT NULL,
  `typecdt` varchar(20) NOT NULL,
  `idsem` int(11) NOT NULL,
  `idcdt` int(11) NOT NULL,
  UNIQUE KEY `typecdt` (`login`,`typecdt`,`idsem`,`idcdt`,`idowncloud`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


-- Creation table document
CREATE TABLE IF NOT EXISTS `oc_documents_invite` (
  `es_id` varchar(64) COLLATE utf8_bin NOT NULL COMMENT 'Related editing session id',
  `uid` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  `status` smallint(6) DEFAULT '0',
  `sent_on` int(10) unsigned DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

CREATE TABLE IF NOT EXISTS `oc_documents_member` (
  `member_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Unique per user and session',
  `es_id` varchar(64) COLLATE utf8_bin NOT NULL COMMENT 'Related editing session id',
  `uid` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  `color` varchar(32) COLLATE utf8_bin DEFAULT NULL,
  `last_activity` int(10) unsigned DEFAULT NULL,
  `is_guest` smallint(5) unsigned NOT NULL DEFAULT '0',
  `token` varchar(32) COLLATE utf8_bin DEFAULT NULL,
  `status` smallint(5) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`member_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `oc_documents_op` (
  `seq` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Sequence number',
  `es_id` varchar(64) COLLATE utf8_bin NOT NULL COMMENT 'Editing session id',
  `member` int(10) unsigned NOT NULL DEFAULT '1' COMMENT 'User and time specific',
  `opspec` longtext COLLATE utf8_bin COMMENT 'json-string',
  PRIMARY KEY (`seq`),
  UNIQUE KEY `documents_op_eis_idx` (`es_id`,`seq`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `oc_documents_revisions` (
  `es_id` varchar(64) COLLATE utf8_bin NOT NULL COMMENT 'Related editing session id',
  `seq_head` int(10) unsigned NOT NULL COMMENT 'Sequence head number',
  `member_id` int(10) unsigned NOT NULL COMMENT 'the member that saved the revision',
  `file_id` varchar(512) COLLATE utf8_bin DEFAULT NULL COMMENT 'Relative to storage e.g. /welcome.odt',
  `save_hash` varchar(128) COLLATE utf8_bin NOT NULL COMMENT 'used to lookup revision in documents folder of member, eg hash.odt',
  UNIQUE KEY `documents_rev_eis_idx` (`es_id`,`seq_head`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;


CREATE TABLE IF NOT EXISTS `oc_documents_session` (
  `es_id` varchar(64) COLLATE utf8_bin NOT NULL COMMENT 'Editing session id',
  `genesis_url` varchar(512) COLLATE utf8_bin DEFAULT NULL COMMENT 'Relative to owner documents storage /welcome.odt',
  `genesis_hash` varchar(128) COLLATE utf8_bin NOT NULL COMMENT 'To be sure the genesis did not change',
  `file_id` varchar(512) COLLATE utf8_bin DEFAULT NULL COMMENT 'Relative to storage e.g. /welcome.odt',
  `owner` varchar(64) COLLATE utf8_bin NOT NULL COMMENT 'oC user who created the session',
  PRIMARY KEY (`es_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;


%if %%is_defined('activer_addadmin') and %%activer_addadmin == 'oui'

%if %%is_defined('activer_owncloud') and %%activer_owncloud == 'oui'
-- ------------------------------------------------------------------------------------------------------------------------------------------
-- OWNCLOUD = Création admin secondaire

\r owncloud
SET character_set_client = utf8;

DROP PROCEDURE IF EXISTS AddAdminOwncloud;
delimiter |
CREATE PROCEDURE AddAdminOwncloud(_adminuser VARCHAR( 32 ))
BEGIN
    INSERT IGNORE INTO `oc_group_user` (`gid`, `uid`) VALUES
    ( 'admin', _adminuser);
END|
DELIMITER ;

CALL AddAdminOwncloud('%%uid_addadmin');
%end if

%end if
