<?php
/*
Plugin Name: EoleCAS
Version: 0.1
Description: Connexion des utilisateurs avec l'authentification CAS et récupération automatique de leurs informations
Plugin URI:
Author: Equipe EOLE
Author URI: http://eole.orion.education.fr/
*/

// pour le debug
ini_set('error_reporting', E_ALL);
ini_set('display_errors', true);

if (!defined('PHPWG_ROOT_PATH')) die ("Hacking attempt!");

global $conf;
$conf['allow_user_registration'] = false;     // Interdiction de se créer un compte local Piwigo
$conf['guest_access'] = false;                // Interdiction d'utiliser le compte invité
$conf['external_authentification'] = true;    // Activation de l'autenfification externe (vérifier si utile)


// Réaction à l'initialisation de Piwigo
add_event_handler('init', 'eole_connexion');

add_event_handler('user_logout', 'eole_deconnexion');

if(!defined('COMMUNITY_PERMISSIONS_TABLE')){
    define('COMMUNITY_PERMISSIONS_TABLE', 'piwigo_community_permissions');
}



function eole_connexion() {
    global $conf, $redirect_to;

        require_once("configCAS/cas.inc.php");
        require_once("CAS-1.3.1/eoleCAS.php");

        eolephpCAS::client(__CAS_VERSION, __CAS_SERVER, __CAS_PORT, __CAS_FOLDER, false);
        if (__CAS_DEBUG){
			eolephpCAS::setDebug('/var/log/posh/piwigo_cas.log');
		}
		
        // Maj pour phpCAS 1.3.1
        if (__CAS_VALIDER_CA) {
            EolephpCAS::setCasServerCACert(__CAS_CA_LOCATION); // vérification par rapport à la CA
        } else {
            if (method_exists("EolephpCAS", "setNoCasServerValidation")){
                EolephpCAS::setNoCasServerValidation();
            }
        }
        if (__CAS_LOGOUT){
            if (method_exists('eolephpCAS', 'eolelogoutRequests')){
                eolephpCAS::EoleLogoutRequests(false);
            }
        }

    // Page d'identification
   
    if (script_basename() == 'identification'){

        eolephpCAS::forceAuthentication();

        // A partir d'ici l'utilisateur est authentifié sur CAS
        $resultCAS = eolephpCAS::getDetails();

        // Récupération des infos de l'utilisateur
        $login = $resultCAS["utilisateur"]["user"][0];
        $profil = $resultCAS["utilisateur"]["profil"][0];
        $password = md5(substr(str_shuffle('ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789'),0,7));
        $mail_address = $resultCAS["utilisateur"]["email"][0];
        $classes = array();
        if (isset($resultCAS["utilisateur"]["classes"])){
            // élève
            array_push($classes, $resultCAS["utilisateur"]["classes"][0]);
        } else {
            // pour les autres on scrute le filtre user_groups à la recherche des groupes commençant par "profs-" (= équipe pédagogique liée à une classe)
            $prefixe = "profs-";
            if (isset($resultCAS["utilisateur"]["user_groups"])){
                $classes = array();
                foreach ($resultCAS["utilisateur"]["user_groups"] as $user_group) {
                    if (stripos($user_group, $prefixe)===0){
                        // "profs-" trouvé donc on le vire pour récupérer le nom de la classe
                        $classe = str_replace($prefixe, "", $user_group);
                        array_push($classes, $classe);
                    }
                }
            }
        }

        // Test d'existence de ce login dans la base locale de Piwigo
        $userid=get_userid($login);

        // Si ce user n'existe pas dans la base locale de Piwigo alors on le crée
        if ($userid === false){
            $userid = eole_create_user($login, $password, $mail_address, $profil, $classes);
        }

        // Création des groupes et albums correspondant aux classes
        if (is_array($classes)){
            foreach ($classes as $une_classe) {
                $une_classe = str_replace("profs-", "", $une_classe);// Pour les profs, les classes ou "équipes pédagogiques" sont préfixées par "profs-"
                $albumid = eole_add_group_album($une_classe, $userid);

                // Attribution des permissions d'ajout de photo aux profs grace au plugin Community
                if ($profil=="professeur" || $profil=="professeur_principal"){
                    if (($userid !== false) && ($albumid !== false)){
                        eole_add_perm($userid, $albumid);
                    }
                }
            }
        }

        log_user($userid, false);
        redirect(empty($redirect_to) ? make_index_url() : $redirect_to);
    }

}

function eole_deconnexion() {
    require_once("configCAS/cas.inc.php");
    require_once("CAS-1.3.1/eoleCAS.php");

	session_name("piwigo");
    session_start();
    session_unset();
    session_destroy();
    if (__CAS_DEBUG){
        eolephpCAS::setDebug('/var/log/posh/piwigo_cas.log');
    }
    eolephpCAS::client(__CAS_VERSION, __CAS_SERVER, __CAS_PORT, __CAS_FOLDER, false);
    // Maj pour phpCAS 1.3.1
    if (__CAS_VALIDER_CA) {
        EolephpCAS::setCasServerCACert(__CAS_CA_LOCATION); // vérification par rapport à la CA
    } else {
        if (method_exists("EolephpCAS", "setNoCasServerValidation")){
            EolephpCAS::setNoCasServerValidation();
        }
    }
	if (__CAS_LOGOUT){
		if (method_exists('eolephpCAS', 'eolelogoutRequests')){
			eolephpCAS::EoleLogoutRequests(false);
		}
	}
            
    $orig_url = $_SERVER['SCRIPT_URI'];
    eolephpCAS::logout(array("url"=>$orig_url));
}

function eole_create_user($login, $password, $mail_address, $profil) {
    register_user($login, $password, $mail_address);
    $id = get_userid($login);
    $lang= "fr_FR";

    if ($id !== false){
        // Remplissage des user infos
        $override_values = array();
        switch ($profil) {
            case 'professeur';
                ////$override_values["status"] = "normal";
                $override_values["level"] = 2;
                $override_values["language"] = $lang;
            break;
            case 'professeur_principal';
                ////$override_values["status"] = "normal";
                $override_values["level"] = 2;
                $override_values["language"] = $lang;
            break;
            case 'administratif';
                ////$override_values["status"] = "normal";
                $override_values["level"] = 2;
                $override_values["language"] = $lang;
            break;

            default : // eleve / responsable
                ////$override_values["status"] = "normal";
                $override_values["level"] = 1;
                $override_values["language"] = $lang;
            break;
        }
        single_update(USER_INFOS_TABLE,$override_values,array('user_id' => $id));
    }
    return $id;
}

/**
 * Ajoute un groupe et un album et y associe l'utilisateur
 *
 * @param nom de la classe
 * @param id de l'utilisateur
 * @return id de l'album crée (ou existant) ou false si erreur
 */
function eole_add_group_album($une_classe, $userid) {

    $nom_group = "groupe_".$une_classe;
    $nom_album = "album_".$une_classe;

    // Création du group
    $id_group = eole_create_group($nom_group);

    // Création de l'album associé
    $id_album = eole_create_album($nom_album);

    // Création de la relation user / group
    if (($userid !== false) && ($id_group !== false)){
        if (eole_test_assoc_usergroup($userid, $id_group) == false){
            single_insert(USER_GROUP_TABLE, array('user_id' => $userid, 'group_id' => $id_group));
        }
    }

    // Création de la relation user / album => Pas forcément souhaitable
    ////if (($userid !== false) && ($id_album !== false)){
        ////if (eole_test_assoc_useraccess($userid, $id_album) == false){
            ////single_insert(USER_ACCESS_TABLE, array('user_id' => $userid, 'cat_id' => $id_album));
        ////}
    ////}

    // Création de la relation album / group
    if (($id_album !== false) && ($id_group !== false)){
        if (eole_test_assoc_groupaccess($id_album, $id_group) == false){
            single_insert(GROUP_ACCESS_TABLE, array('cat_id' => $id_album, 'group_id' => $id_group));
        }
    }
    return $id_album;
}

/**
 * Crée un groupe
 *
 * @param nom du groupe
 * @return id du groupe crée (ou existant) ou false si erreur
 */
function eole_create_group($nomgroup) {

    $nomgroup = pwg_db_real_escape_string($nomgroup);

    $query = '
                SELECT COUNT(*)
                FROM '.GROUPS_TABLE.'
                WHERE name = \''.$nomgroup.'\'
            ;';
    list($count) = pwg_db_fetch_row(pwg_query($query));
    if ($count == 0){
        $query = '
                    INSERT INTO '.GROUPS_TABLE.'
                      (name)
                      VALUES
                      (\''.$nomgroup.'\')
                ;';
        pwg_query($query);
    }

    $query = '
                SELECT id
                FROM '.GROUPS_TABLE.'
                WHERE name = \''.$nomgroup.'\'
            ;';
    $result = pwg_query($query);

    if (pwg_db_num_rows($result) == 0){
        return false;
    }else{
        list($id) = pwg_db_fetch_row($result);
        return $id;
    }
}

/**
 * Crée un sous-album virtuel de l'album "Classes" (=> l'album dont l'id = 1)
 *
 * @param nom de l'album
 * @return id de l'album crée (ou existant) ou false si erreur
 */
function eole_create_album($nomalbum) {

    include_once("admin/include/functions.php");

    $nomalbum = pwg_db_real_escape_string($nomalbum);

    $query = '
                SELECT COUNT(*)
                FROM '.CATEGORIES_TABLE.'
                WHERE name = \''.$nomalbum.'\'
            ;';
    list($count) = pwg_db_fetch_row(pwg_query($query));
    if ($count == 0){
        // création de l'album
        $retour = create_virtual_category($nomalbum, 1);

        if (isset($retour["error"])){
            return false;
        }else{
            return $retour["id"];
        }
    }else{
        // récup de l'id de l'album
        $query = '
                    SELECT id
                    FROM '.CATEGORIES_TABLE.'
                    WHERE name = \''.$nomalbum.'\'
                ;';
        $result = pwg_query($query);

        if (pwg_db_num_rows($result) == 0){
            return false;
        }else{
            list($id) = pwg_db_fetch_row($result);
            return $id;
        }
    }
}

/**
 * Test l'existence d'un enregistrement dans la table piwigo_user_group
 *
 * @param id de l'utilisateur
 * @param id du groupe
 * @return true : existe / false : n'existe pas
 */
function eole_test_assoc_usergroup($userid, $id_group) {
    $query = '
                SELECT COUNT(*)
                FROM '.USER_GROUP_TABLE.'
                WHERE user_id = \''.$userid.'\'
                AND group_id = \''.$id_group.'\'
            ;';
    list($count) = pwg_db_fetch_row(pwg_query($query));
    if ($count == 0){
        return false;
    }else{
        return true;
    }
}

/**
 * Test l'existence d'un enregistrement dans la table piwigo_user_access
 *
 * @param id de l'utilisateur
 * @param id de l'album
 * @return true : existe / false : n'existe pas
 */
function eole_test_assoc_useraccess($userid, $id_album) {
    $query = '
                SELECT COUNT(*)
                FROM '.USER_ACCESS_TABLE.'
                WHERE user_id = \''.$userid.'\'
                AND cat_id = \''.$id_album.'\'
            ;';
    list($count) = pwg_db_fetch_row(pwg_query($query));
    if ($count == 0){
        return false;
    }else{
        return true;
    }
}

/**
 * Test l'existence d'un enregistrement dans la table piwigo_group_access
 *
 * @param id de l'album
 * @param id du groupe
 * @return true : existe / false : n'existe pas
 */
function eole_test_assoc_groupaccess($id_album, $id_group) {
    $query = '
                SELECT COUNT(*)
                FROM '.GROUP_ACCESS_TABLE.'
                WHERE cat_id = \''.$id_album.'\'
                AND group_id = \''.$id_group.'\'
            ;';
    list($count) = pwg_db_fetch_row(pwg_query($query));
    if ($count == 0){
        return false;
    }else{
        return true;
    }
}

/**
 * Ajoute (si besoin) la permission d'ajout de photo pour un utilisateur sur
 * un album grace au plugin Community (table piwigo_community_permissions)
 *
 * @param id de l'utilisateur
 * @param id de l'album
 * @return true : existe / false : n'existe pas
 */
function eole_add_perm($userid, $albumid) {
    $query = '
                SELECT COUNT(*)
                FROM '.COMMUNITY_PERMISSIONS_TABLE.'
                WHERE type = \'user\'
                AND user_id = '.$userid.'
                AND category_id = '.$albumid.'
            ;';
    list($count) = pwg_db_fetch_row(pwg_query($query));
    if ($count == 0){
        single_insert(COMMUNITY_PERMISSIONS_TABLE, array('type' => 'user', 'user_id' => $userid, 'category_id' => $albumid, 'moderated' => 'false'));
    }
}

?>
