\r piwik
ALTER TABLE piwik_goal ENGINE = INNODB;
ALTER TABLE piwik_access ENGINE = INNODB;
ALTER TABLE piwik_logger_message ENGINE = INNODB;
ALTER TABLE piwik_log_action ENGINE = INNODB;
ALTER TABLE piwik_log_conversion ENGINE = INNODB;
ALTER TABLE piwik_log_conversion_item ENGINE = INNODB;
ALTER TABLE piwik_log_link_visit_action ENGINE = INNODB;
ALTER TABLE piwik_log_profiling ENGINE = INNODB;
ALTER TABLE piwik_log_visit ENGINE = INNODB;
ALTER TABLE piwik_option ENGINE = INNODB;
ALTER TABLE piwik_report ENGINE = INNODB;
ALTER TABLE piwik_segment ENGINE = INNODB;
ALTER TABLE piwik_session ENGINE = INNODB;
ALTER TABLE piwik_site ENGINE = INNODB;
ALTER TABLE piwik_site_url ENGINE = INNODB;
ALTER TABLE piwik_user ENGINE = INNODB;
ALTER TABLE piwik_user_dashboard ENGINE = INNODB;
ALTER TABLE piwik_user_language ENGINE = INNODB;

ALTER TABLE  piwik_session CHANGE id id VARCHAR( 255 ) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL;

INSERT INTO `piwik_option` (`option_name`, `option_value`, `autoload`) VALUES ('enableBrowserTriggerArchiving', '0', 1) ON DUPLICATE KEY UPDATE option_value='0';
INSERT INTO `piwik_option` (`option_name`, `option_value`, `autoload`) VALUES ('todayArchiveTimeToLive', '150', 1) ON DUPLICATE KEY UPDATE option_value='150';

%if %%is_defined('activer_addadmin') and %%activer_addadmin == 'oui'

%if %%is_defined('activer_piwik') and %%activer_piwik == 'oui'
-- ------------------------------------------------------------------------------------------------------------------------------------------
-- PIWIK = Création admin secondaire

\r piwik
SET character_set_client = utf8;

DROP PROCEDURE IF EXISTS AddAdminPiwik;
delimiter |
CREATE PROCEDURE AddAdminPiwik(_adminuser VARCHAR( 32 ))
BEGIN
    DECLARE keyexit INT DEFAULT 0;
    
    SELECT COUNT(*) INTO keyexit FROM information_schema.columns WHERE table_schema = 'piwik' AND table_name = 'piwik_user' AND column_name = 'superuser_access';
    
    IF keyexit > 0 THEN
        INSERT IGNORE INTO `piwik_user` (`login`, `superuser_access`) VALUES
            (_adminuser, 1);
        
        UPDATE piwik_user SET superuser_access = 1 WHERE login = _adminuser;
    END IF;	    
END|
DELIMITER ;

CALL AddAdminPiwik('%%uid_addadmin');
%end if

%end if
